/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.neural.Vector;
import java.util.ArrayList;
import java.util.List;

public class NNExample {
    private final List<Double> normalizedInput;
    private final List<Double> normalizedTarget;

    public NNExample(List<Double> normalizedInput, List<Double> normalizedTarget) {
        this.normalizedInput = normalizedInput;
        this.normalizedTarget = normalizedTarget;
    }

    public NNExample copyExample() {
        ArrayList<Double> newInput = new ArrayList<Double>();
        ArrayList<Double> newTarget = new ArrayList<Double>();
        for (Double d : this.normalizedInput) {
            newInput.add(new Double(d));
        }
        for (Double d : this.normalizedTarget) {
            newTarget.add(new Double(d));
        }
        return new NNExample(newInput, newTarget);
    }

    public Vector getInput() {
        Vector v = new Vector(this.normalizedInput);
        return v;
    }

    public Vector getTarget() {
        Vector v = new Vector(this.normalizedTarget);
        return v;
    }

    public boolean isCorrect(Vector prediction) {
        return this.getTarget().indexHavingMaxValue() == prediction.indexHavingMaxValue();
    }
}

