/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.Util;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class MeanStDevTests
extends TestCase {
    private List<Double> values;

    @Override
    public void setUp() {
        this.values = new ArrayList<Double>();
        this.values.add(1.0);
        this.values.add(2.0);
        this.values.add(3.0);
        this.values.add(4.0);
        this.values.add(5.0);
    }

    public void testMeanCalculation() {
        MeanStDevTests.assertEquals(3.0, Util.calculateMean(this.values));
    }

    public void testStDevCalculation() {
        MeanStDevTests.assertEquals(1.5811, Util.calculateStDev(this.values, 3.0), 0.001);
    }

    public void testNormalization() {
        List<Double> nrm = Util.normalizeFromMeanAndStdev(this.values, 3.0, 1.5811);
        MeanStDevTests.assertEquals(-1.264, nrm.get(0), 0.001);
        MeanStDevTests.assertEquals(-0.632, nrm.get(1), 0.001);
        MeanStDevTests.assertEquals(0.0, nrm.get(2), 0.001);
        MeanStDevTests.assertEquals(0.632, nrm.get(3), 0.001);
        MeanStDevTests.assertEquals(1.264, nrm.get(4), 0.001);
    }

    public void testRandomNumberGenrationWhenStartAndEndNumbersAreSame() {
        int i = Util.randomNumberBetween(0, 0);
        int j = Util.randomNumberBetween(23, 23);
        MeanStDevTests.assertEquals(0, i);
        MeanStDevTests.assertEquals(23, j);
    }
}

