/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.search.framework.Successor;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensSuccessorFunction;
import java.util.List;
import junit.framework.TestCase;

public class NQueensSuccessorFunctionTest
extends TestCase {
    NQueensSuccessorFunction successorFunction;
    NQueensBoard oneBoard;
    NQueensBoard eightBoard;

    @Override
    public void setUp() {
        this.successorFunction = new NQueensSuccessorFunction();
        this.oneBoard = new NQueensBoard(1);
        this.eightBoard = new NQueensBoard(8);
    }

    public void testSimpleBoardSuccessorGenerator() {
        List successors = this.successorFunction.getSuccessors(this.oneBoard);
        NQueensSuccessorFunctionTest.assertEquals(1, successors.size());
        Successor successor = (Successor)successors.get(0);
        NQueensBoard next = (NQueensBoard)successor.getState();
        NQueensSuccessorFunctionTest.assertEquals(1, next.getNumberOfQueensOnBoard());
    }

    public void testComplexBoardSuccessorGenerator() {
        List successors = this.successorFunction.getSuccessors(this.eightBoard);
        NQueensSuccessorFunctionTest.assertEquals(8, successors.size());
        Successor successor = (Successor)successors.get(0);
        NQueensBoard next = (NQueensBoard)successor.getState();
        NQueensSuccessorFunctionTest.assertEquals(1, next.getNumberOfQueensOnBoard());
        successors = this.successorFunction.getSuccessors(next);
        NQueensSuccessorFunctionTest.assertEquals(6, successors.size());
    }
}

