/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensFitnessFunction;
import java.util.Set;
import junit.framework.TestCase;

public class NQueensFitnessFunctionTest
extends TestCase {
    NQueensFitnessFunction fitnessFunction;

    @Override
    public void setUp() {
        this.fitnessFunction = new NQueensFitnessFunction();
    }

    public void test_getValue() {
        NQueensFitnessFunctionTest.assertTrue(0.0 == this.fitnessFunction.getValue("00000000"));
        NQueensFitnessFunctionTest.assertTrue(0.0 == this.fitnessFunction.getValue("01234567"));
        NQueensFitnessFunctionTest.assertTrue(0.0 == this.fitnessFunction.getValue("76543210"));
        NQueensFitnessFunctionTest.assertTrue(23.0 == this.fitnessFunction.getValue("56136477"));
        NQueensFitnessFunctionTest.assertTrue(28.0 == this.fitnessFunction.getValue("04752613"));
    }

    public void test_isGoalState() {
        NQueensFitnessFunctionTest.assertTrue(this.fitnessFunction.isGoalState("04752613"));
        NQueensFitnessFunctionTest.assertFalse(this.fitnessFunction.isGoalState("00000000"));
        NQueensFitnessFunctionTest.assertFalse(this.fitnessFunction.isGoalState("56136477"));
    }

    public void test_getBoardForIndividual() {
        NQueensBoard board = this.fitnessFunction.getBoardForIndividual("56136477");
        NQueensFitnessFunctionTest.assertEquals(" -  -  -  -  -  -  -  - \n -  -  Q  -  -  -  -  - \n -  -  -  -  -  -  -  - \n -  -  -  Q  -  -  -  - \n -  -  -  -  -  Q  -  - \n Q  -  -  -  -  -  -  - \n -  Q  -  -  Q  -  -  - \n -  -  -  -  -  -  Q  Q \n", board.getBoardPic());
        NQueensFitnessFunctionTest.assertEquals("--------\n--Q-----\n--------\n---Q----\n-----Q--\nQ-------\n-Q--Q---\n------QQ\n", board.toString());
    }

    public void test_generateRandomIndividual() {
        for (int i = 2; i <= 36; ++i) {
            String individual = this.fitnessFunction.generateRandomIndividual(i);
            NQueensFitnessFunctionTest.assertEquals(i, individual.length());
        }
    }

    public void test_getFiniteAlphabet() {
        for (int i = 2; i <= 36; ++i) {
            Set<Character> fab = this.fitnessFunction.getFiniteAlphabetForBoardOfSize(i);
            NQueensFitnessFunctionTest.assertEquals(i, fab.size());
        }
    }
}

