/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.basic.Percept;
import aima.search.framework.GraphSearch;
import aima.search.framework.Search;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.uninformed.UniformCostSearch;
import junit.framework.TestCase;

public class MapEnvironmentTest
extends TestCase {
    MapEnvironment me;
    MapAgent ma;

    @Override
    public void setUp() {
        ExtendableMap aMap = new ExtendableMap();
        aMap.addBidirectionalLink("A", "B", 5.0);
        aMap.addBidirectionalLink("A", "C", 6.0);
        aMap.addBidirectionalLink("B", "C", 4.0);
        aMap.addBidirectionalLink("C", "D", 7.0);
        aMap.addUnidirectionalLink("B", "E", 14.0);
        this.me = new MapEnvironment(aMap);
        this.ma = new MapAgent(this.me, (Search)new UniformCostSearch(new GraphSearch()), new String[]{"A"});
    }

    public void testAddAgent() {
        this.me.addAgent(this.ma, "E");
        MapEnvironmentTest.assertEquals(this.ma.getAttribute("location"), (Object)"E");
    }

    public void testExecuteAction() {
        this.me.addAgent(this.ma, "D");
        this.me.executeAction(this.ma, "C");
        MapEnvironmentTest.assertEquals(this.ma.getAttribute("location"), (Object)"C");
    }

    public void testPerceptSeenBy() {
        this.me.addAgent(this.ma, "D");
        Percept p = this.me.getPerceptSeenBy(this.ma);
        MapEnvironmentTest.assertEquals(p.getAttribute("In"), (Object)"D");
    }
}

