/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class FOLKnowledgeBaseTest
extends TestCase {
    private FOLKnowledgeBase weaponsKB;
    private FOLKnowledgeBase kingsKB;

    @Override
    public void setUp() {
        StandardizeApartIndexicalFactory.flush();
        this.weaponsKB = new FOLKnowledgeBase(DomainFactory.weaponsDomain());
        this.kingsKB = new FOLKnowledgeBase(DomainFactory.kingsDomain());
    }

    public void testAddRuleAndFact() {
        this.weaponsKB.tell("(Missile(x) => Weapon(x))");
        FOLKnowledgeBaseTest.assertEquals(1, this.weaponsKB.getNumberRules());
        this.weaponsKB.tell("American(West)");
        FOLKnowledgeBaseTest.assertEquals(1, this.weaponsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals(1, this.weaponsKB.getNumberFacts());
    }

    public void testAddComplexRule() {
        this.weaponsKB.tell("( (((American(x) AND Weapon(y)) AND Sells(x,y,z)) AND Hostile(z)) => Criminal(x))");
        FOLKnowledgeBaseTest.assertEquals(1, this.weaponsKB.getNumberRules());
        this.weaponsKB.tell("American(West)");
        FOLKnowledgeBaseTest.assertEquals(1, this.weaponsKB.getNumberRules());
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("v0"));
        Clause dcRule = this.weaponsKB.getAllDefiniteClauseImplications().get(0);
        FOLKnowledgeBaseTest.assertNotNull(dcRule);
        FOLKnowledgeBaseTest.assertEquals(true, dcRule.isImplicationDefiniteClause());
        FOLKnowledgeBaseTest.assertEquals(new Literal(new Predicate("Criminal", terms)), dcRule.getPositiveLiterals().get(0));
    }

    public void testFactNotAddedWhenAlreadyPresent() {
        this.kingsKB.tell("((King(x) AND Greedy(x)) => Evil(x))");
        this.kingsKB.tell("King(John)");
        this.kingsKB.tell("King(Richard)");
        this.kingsKB.tell("Greedy(John)");
        FOLKnowledgeBaseTest.assertEquals(1, this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals(3, this.kingsKB.getNumberFacts());
        this.kingsKB.tell("King(John)");
        this.kingsKB.tell("King(Richard)");
        this.kingsKB.tell("Greedy(John)");
        FOLKnowledgeBaseTest.assertEquals(1, this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals(3, this.kingsKB.getNumberFacts());
        this.kingsKB.tell("(((King(John))))");
        this.kingsKB.tell("(((King(Richard))))");
        this.kingsKB.tell("(((Greedy(John))))");
        FOLKnowledgeBaseTest.assertEquals(1, this.kingsKB.getNumberRules());
        FOLKnowledgeBaseTest.assertEquals(3, this.kingsKB.getNumberFacts());
    }
}

