/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest.neural;

import aima.learning.neural.NNExample;
import aima.learning.neural.RabbitEyeDataSet;
import java.util.List;
import junit.framework.TestCase;

public class DataSetTests
extends TestCase {
    public void testNormalizationOfFileBasedDataProducesCorrectMeanStdDevAndNormalizedValues() throws Exception {
        RabbitEyeDataSet reds = new RabbitEyeDataSet();
        reds.createNormalizedDataFromFile("rabbiteyes");
        List<Double> means = reds.getMeans();
        DataSetTests.assertEquals(2, means.size());
        DataSetTests.assertEquals(244.771, means.get(0), 0.001);
        DataSetTests.assertEquals(145.505, means.get(1), 0.001);
        List<Double> stdev = reds.getStdevs();
        DataSetTests.assertEquals(2, stdev.size());
        DataSetTests.assertEquals(213.554, stdev.get(0), 0.001);
        DataSetTests.assertEquals(65.776, stdev.get(1), 0.001);
        List<List<Double>> normalized = reds.getNormalizedData();
        DataSetTests.assertEquals(70, normalized.size());
        DataSetTests.assertEquals(-1.0759, normalized.get(0).get(0), 0.001);
        DataSetTests.assertEquals(-1.882, normalized.get(0).get(1), 0.001);
        DataSetTests.assertEquals(2.88, normalized.get(69).get(0), 0.001);
        DataSetTests.assertEquals(1.538, normalized.get(69).get(1), 0.001);
    }

    public void testExampleFormation() throws Exception {
        RabbitEyeDataSet reds = new RabbitEyeDataSet();
        reds.createExamplesFromFile("rabbiteyes");
        DataSetTests.assertEquals(70, reds.howManyExamplesLeft());
        NNExample e = reds.getExampleAtRandom();
        DataSetTests.assertEquals(69, reds.howManyExamplesLeft());
        NNExample e2 = reds.getExampleAtRandom();
        DataSetTests.assertEquals(68, reds.howManyExamplesLeft());
    }
}

