/*
 * Decompiled with CFR 0.152.
 */
package aima.search.map;

import aima.basic.Agent;
import aima.basic.Environment;
import aima.basic.Percept;
import aima.search.map.Map;
import java.util.ArrayList;

public class MapEnvironment
extends Environment {
    private Map aMap = null;

    public MapEnvironment(Map aMap) {
        this.aMap = aMap;
    }

    public void addAgent(Agent a, String startLocation) {
        super.addAgent(a);
        a.setAttribute("location", startLocation);
        a.setAttribute("travelDistance", 0.0);
    }

    @Override
    public void executeAction(Agent a, String act) {
        String currLoc = (String)a.getAttribute("location");
        Double distance = this.aMap.getDistance(currLoc, act);
        if (distance != null) {
            double currTD = (Double)a.getAttribute("travelDistance");
            a.setAttribute("travelDistance", currTD + distance);
            a.setAttribute("location", act);
        }
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        String currLoc = (String)anAgent.getAttribute("location");
        ArrayList<Object> possibleActions = new ArrayList<Object>();
        for (String a : this.aMap.getLocationsLinkedTo(currLoc)) {
            possibleActions.add(a);
            possibleActions.add(new Double(this.aMap.getDistance(currLoc, a)));
        }
        return new Percept("In", currLoc, "PossibleActions", possibleActions);
    }

    public Map getMap() {
        return this.aMap;
    }
}

