/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing.ast;

import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.ComplexSentence;
import aima.logic.propositional.parsing.ast.Sentence;

public class BinarySentence
extends ComplexSentence {
    private String operator;
    private Sentence first;
    private Sentence second;

    public BinarySentence(String operator, Sentence first, Sentence second) {
        this.operator = operator;
        this.first = first;
        this.second = second;
    }

    public Sentence getFirst() {
        return this.first;
    }

    public String getOperator() {
        return this.operator;
    }

    public Sentence getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinarySentence bs = (BinarySentence)o;
        return bs.getOperator().equals(this.getOperator()) && bs.getFirst().equals(this.first) && bs.getSecond().equals(this.second);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.first.hashCode();
        result = 37 * result + this.second.hashCode();
        return result;
    }

    public String toString() {
        return " ( " + this.first.toString() + " " + this.operator + " " + this.second.toString() + " )";
    }

    @Override
    public Object accept(PLVisitor plv, Object arg) {
        return plv.visitBinarySentence(this, arg);
    }

    public boolean isOrSentence() {
        return this.getOperator().equals("OR");
    }

    public boolean isAndSentence() {
        return this.getOperator().equals("AND");
    }

    public boolean isImplication() {
        return this.getOperator().equals("=>");
    }

    public boolean isBiconditional() {
        return this.getOperator().equals("<=>");
    }

    public boolean firstTermIsAndSentence() {
        return this.getFirst() instanceof BinarySentence && ((BinarySentence)this.getFirst()).isAndSentence();
    }

    public boolean secondTermIsAndSentence() {
        return this.getSecond() instanceof BinarySentence && ((BinarySentence)this.getSecond()).isAndSentence();
    }
}

