/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class PLFCEntails {
    private Hashtable<HornClause, Integer> count = new Hashtable();
    private Hashtable<Symbol, Boolean> inferred = new Hashtable();
    private Stack<Symbol> agenda = new Stack();

    public boolean plfcEntails(KnowledgeBase kb, String s) {
        return this.plfcEntails(kb, new Symbol(s));
    }

    public boolean plfcEntails(KnowledgeBase kb, Symbol q) {
        List<HornClause> hornClauses = this.asHornClauses(kb.getSentences());
        while (this.agenda.size() != 0) {
            Symbol p = this.agenda.pop();
            while (!this.inferred(p)) {
                this.inferred.put(p, Boolean.TRUE);
                for (int i = 0; i < hornClauses.size(); ++i) {
                    HornClause hornClause = hornClauses.get(i);
                    if (!hornClause.premisesContainsSymbol(p)) continue;
                    this.decrementCount(hornClause);
                    if (!this.countisZero(hornClause)) continue;
                    if (hornClause.head().equals(q)) {
                        return true;
                    }
                    this.agenda.push(hornClause.head());
                }
            }
        }
        return false;
    }

    private List<HornClause> asHornClauses(List sentences) {
        ArrayList<HornClause> hornClauses = new ArrayList<HornClause>();
        for (int i = 0; i < sentences.size(); ++i) {
            Sentence sentence = (Sentence)sentences.get(i);
            HornClause clause = new HornClause(sentence);
            hornClauses.add(clause);
        }
        return hornClauses;
    }

    private boolean countisZero(HornClause hornClause) {
        return this.count.get(hornClause) == 0;
    }

    private void decrementCount(HornClause hornClause) {
        int value = this.count.get(hornClause);
        this.count.put(hornClause, new Integer(value - 1));
    }

    private boolean inferred(Symbol p) {
        Boolean value = this.inferred.get(p);
        return value == null || ((Object)value).equals(Boolean.TRUE);
    }

    public class HornClause {
        List<Symbol> premiseSymbols;
        Symbol head;

        public HornClause(Sentence sentence) {
            if (sentence instanceof Symbol) {
                this.head = (Symbol)sentence;
                PLFCEntails.this.agenda.push(this.head);
                this.premiseSymbols = new ArrayList<Symbol>();
                PLFCEntails.this.count.put(this, new Integer(0));
                PLFCEntails.this.inferred.put(this.head, Boolean.FALSE);
            } else {
                if (!this.isImpliedSentence(sentence)) {
                    throw new RuntimeException("Sentence " + sentence + " is not a horn clause");
                }
                BinarySentence bs = (BinarySentence)sentence;
                this.head = (Symbol)bs.getSecond();
                PLFCEntails.this.inferred.put(this.head, Boolean.FALSE);
                Set<Symbol> symbolsInPremise = new SymbolCollector().getSymbolsIn(bs.getFirst());
                Iterator<Symbol> iter = symbolsInPremise.iterator();
                while (iter.hasNext()) {
                    PLFCEntails.this.inferred.put(iter.next(), Boolean.FALSE);
                }
                this.premiseSymbols = new Converter<Symbol>().setToList(symbolsInPremise);
                PLFCEntails.this.count.put(this, new Integer(this.premiseSymbols.size()));
            }
        }

        private boolean isImpliedSentence(Sentence sentence) {
            return sentence instanceof BinarySentence && ((BinarySentence)sentence).getOperator().equals("=>");
        }

        public Symbol head() {
            return this.head;
        }

        public boolean premisesContainsSymbol(Symbol q) {
            return this.premiseSymbols.contains(q);
        }

        public List getPremiseSymbols() {
            return this.premiseSymbols;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HornClause ohc = (HornClause)o;
            if (this.premiseSymbols.size() != ohc.premiseSymbols.size()) {
                return false;
            }
            boolean result = true;
            for (Symbol s : this.premiseSymbols) {
                if (ohc.premiseSymbols.contains(s)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            for (Symbol s : this.premiseSymbols) {
                result = 37 * result + s.hashCode();
            }
            return result;
        }

        public String toString() {
            return this.premiseSymbols.toString() + " => " + this.head;
        }
    }
}

