/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.AbstractProofStep;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProofStepBwChGoal
extends AbstractProofStep {
    private List<ProofStep> predecessors = new ArrayList<ProofStep>();
    private Clause toProve = null;
    private Literal currentGoal = null;
    private Map<Variable, Term> bindings = new LinkedHashMap<Variable, Term>();

    public ProofStepBwChGoal(Clause toProve, Literal currentGoal, Map<Variable, Term> bindings) {
        this.toProve = toProve;
        this.currentGoal = currentGoal;
        this.bindings.putAll(bindings);
    }

    public Map<Variable, Term> getBindings() {
        return this.bindings;
    }

    public void setPredecessor(ProofStep predecessor) {
        this.predecessors.clear();
        this.predecessors.add(predecessor);
    }

    @Override
    public List<ProofStep> getPredecessorSteps() {
        return Collections.unmodifiableList(this.predecessors);
    }

    @Override
    public String getProof() {
        StringBuilder sb = new StringBuilder();
        List<Literal> nLits = this.toProve.getNegativeLiterals();
        for (int i = 0; i < this.toProve.getNumberNegativeLiterals(); ++i) {
            sb.append(nLits.get(i).getAtomicSentence());
            if (i == this.toProve.getNumberNegativeLiterals() - 1) continue;
            sb.append(" AND ");
        }
        if (this.toProve.getNumberNegativeLiterals() > 0) {
            sb.append(" => ");
        }
        sb.append(this.toProve.getPositiveLiterals().get(0));
        return sb.toString();
    }

    @Override
    public String getJustification() {
        return "Current Goal " + this.currentGoal.getAtomicSentence().toString() + ", " + this.bindings;
    }
}

