/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.Unifier;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class AbstractModulation {
    protected VariableCollector variableCollector = new VariableCollector();
    protected Unifier unifier = new Unifier();
    protected SubstVisitor substVisitor = new SubstVisitor();

    protected abstract boolean isValidMatch(Term var1, Set<Variable> var2, Term var3, Map<Variable, Term> var4);

    protected IdentifyCandidateMatchingTerm getMatchingSubstitution(Term toMatch, AtomicSentence expression) {
        IdentifyCandidateMatchingTerm icm = new IdentifyCandidateMatchingTerm(toMatch, expression);
        if (icm.isMatch()) {
            return icm;
        }
        return null;
    }

    protected class ReplaceMatchingTerm
    implements FOLVisitor {
        private Term toReplace = null;
        private Term replaceWith = null;
        private boolean replaced = false;

        public AtomicSentence replace(AtomicSentence expression, Term toReplace, Term replaceWith) {
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
            return (AtomicSentence)expression.accept(this, null);
        }

        @Override
        public Object visitPredicate(Predicate p, Object arg) {
            ArrayList<Term> newTerms = new ArrayList<Term>();
            for (Term t : p.getTerms()) {
                Term subsTerm = (Term)t.accept(this, arg);
                newTerms.add(subsTerm);
            }
            return new Predicate(p.getPredicateName(), newTerms);
        }

        @Override
        public Object visitTermEquality(TermEquality equality, Object arg) {
            Term newTerm1 = (Term)equality.getTerm1().accept(this, arg);
            Term newTerm2 = (Term)equality.getTerm2().accept(this, arg);
            return new TermEquality(newTerm1, newTerm2);
        }

        @Override
        public Object visitVariable(Variable variable, Object arg) {
            if (!this.replaced && this.toReplace.equals(variable)) {
                this.replaced = true;
                return this.replaceWith;
            }
            return variable;
        }

        @Override
        public Object visitConstant(Constant constant, Object arg) {
            if (!this.replaced && this.toReplace.equals(constant)) {
                this.replaced = true;
                return this.replaceWith;
            }
            return constant;
        }

        @Override
        public Object visitFunction(Function function, Object arg) {
            if (!this.replaced && this.toReplace.equals(function)) {
                this.replaced = true;
                return this.replaceWith;
            }
            ArrayList<Term> newTerms = new ArrayList<Term>();
            for (Term t : function.getTerms()) {
                Term subsTerm = (Term)t.accept(this, arg);
                newTerms.add(subsTerm);
            }
            return new Function(function.getFunctionName(), newTerms);
        }

        @Override
        public Object visitNotSentence(NotSentence sentence, Object arg) {
            throw new IllegalStateException("visitNotSentence() should not be called.");
        }

        @Override
        public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
            throw new IllegalStateException("visitConnectedSentence() should not be called.");
        }

        @Override
        public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
            throw new IllegalStateException("visitQuantifiedSentence() should not be called.");
        }
    }

    protected class IdentifyCandidateMatchingTerm
    implements FOLVisitor {
        private Term toMatch = null;
        private Set<Variable> toMatchVariables = null;
        private Term matchingTerm = null;
        private Map<Variable, Term> substitution = null;

        public IdentifyCandidateMatchingTerm(Term toMatch, AtomicSentence expression) {
            this.toMatch = toMatch;
            this.toMatchVariables = AbstractModulation.this.variableCollector.collectAllVariables(toMatch);
            expression.accept(this, null);
        }

        public boolean isMatch() {
            return null != this.matchingTerm;
        }

        public Term getMatchingTerm() {
            return this.matchingTerm;
        }

        public Map<Variable, Term> getMatchingSubstitution() {
            return this.substitution;
        }

        @Override
        public Object visitPredicate(Predicate p, Object arg) {
            for (Term t : p.getArgs()) {
                if (null != this.matchingTerm) break;
                t.accept(this, null);
            }
            return p;
        }

        @Override
        public Object visitTermEquality(TermEquality equality, Object arg) {
            for (Term t : equality.getArgs()) {
                if (null != this.matchingTerm) break;
                t.accept(this, null);
            }
            return equality;
        }

        @Override
        public Object visitVariable(Variable variable, Object arg) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, variable);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, variable, this.substitution)) {
                this.matchingTerm = variable;
            }
            return variable;
        }

        @Override
        public Object visitConstant(Constant constant, Object arg) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, constant);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, constant, this.substitution)) {
                this.matchingTerm = constant;
            }
            return constant;
        }

        @Override
        public Object visitFunction(Function function, Object arg) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, function);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, function, this.substitution)) {
                this.matchingTerm = function;
            }
            if (null == this.matchingTerm) {
                for (Term t : function.getArgs()) {
                    if (null != this.matchingTerm) break;
                    t.accept(this, null);
                }
            }
            return function;
        }

        @Override
        public Object visitNotSentence(NotSentence sentence, Object arg) {
            throw new IllegalStateException("visitNotSentence() should not be called.");
        }

        @Override
        public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
            throw new IllegalStateException("visitConnectedSentence() should not be called.");
        }

        @Override
        public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
            throw new IllegalStateException("visitQuantifiedSentence() should not be called.");
        }
    }
}

