/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.List;

class CollectAllVariables
implements FOLVisitor {
    @Override
    public Object visitVariable(Variable var, Object arg) {
        List variables = (List)arg;
        variables.add(var);
        return var;
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        List variables = (List)arg;
        variables.addAll(sentence.getVariables());
        sentence.getQuantified().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object arg) {
        for (Term t : predicate.getTerms()) {
            t.accept(this, arg);
        }
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        equality.getTerm1().accept(this, arg);
        equality.getTerm2().accept(this, arg);
        return equality;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        for (Term t : function.getTerms()) {
            t.accept(this, arg);
        }
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        sentence.getNegated().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        sentence.getFirst().accept(this, arg);
        sentence.getSecond().accept(this, arg);
        return sentence;
    }
}

