/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.Connectors;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

class CNFConstructor
implements FOLVisitor {
    public CNF construct(Sentence orDistributedOverAnd) {
        ArgData ad = new ArgData();
        orDistributedOverAnd.accept(this, ad);
        return new CNF(ad.clauses);
    }

    @Override
    public Object visitPredicate(Predicate p, Object arg) {
        ArgData ad = (ArgData)arg;
        if (ad.negated) {
            ad.clauses.get(ad.clauses.size() - 1).addNegativeLiteral(p);
        } else {
            ad.clauses.get(ad.clauses.size() - 1).addPositiveLiteral(p);
        }
        return p;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        ArgData ad = (ArgData)arg;
        if (ad.negated) {
            ad.clauses.get(ad.clauses.size() - 1).addNegativeLiteral(equality);
        } else {
            ad.clauses.get(ad.clauses.size() - 1).addPositiveLiteral(equality);
        }
        return equality;
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        throw new IllegalStateException("visitVariable() should not be called.");
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        throw new IllegalStateException("visitConstant() should not be called.");
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        throw new IllegalStateException("visitFunction() should not be called.");
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        ArgData ad = (ArgData)arg;
        ad.negated = true;
        sentence.getNegated().accept(this, arg);
        ad.negated = false;
        return sentence;
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        ArgData ad = (ArgData)arg;
        Sentence first = sentence.getFirst();
        Sentence second = sentence.getSecond();
        first.accept(this, arg);
        if (Connectors.isAND(sentence.getConnector())) {
            ad.clauses.add(new Clause());
        }
        second.accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        throw new IllegalStateException("All quantified sentences should have already been removed.");
    }

    class ArgData {
        public List<Clause> clauses = new ArrayList<Clause>();
        public boolean negated = false;

        public ArgData() {
            this.clauses.add(new Clause());
        }
    }
}

