/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.inductive.ConstantDecisonTree;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.MajorityLearner;
import aima.util.Util;
import java.util.Iterator;
import java.util.List;

public class DecisionTreeLearner
implements Learner {
    private DecisionTree tree;
    private String defaultValue;

    public DecisionTreeLearner() {
        this.defaultValue = "Unable To Classify";
    }

    public DecisionTreeLearner(DecisionTree tree, String defaultValue) {
        this.tree = tree;
        this.defaultValue = defaultValue;
    }

    @Override
    public void train(DataSet ds) {
        List<String> attributes = ds.getNonTargetAttributes();
        this.tree = this.decisionTreeLearning(ds, attributes, new ConstantDecisonTree(this.defaultValue));
    }

    @Override
    public String predict(Example e) {
        return (String)this.tree.predict(e);
    }

    @Override
    public int[] test(DataSet ds) {
        int[] results = new int[]{0, 0};
        for (Example e : ds.examples) {
            if (e.targetValue().equals(this.tree.predict(e))) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }

    private DecisionTree decisionTreeLearning(DataSet ds, List<String> attributeNames, ConstantDecisonTree defaultTree) {
        if (ds.size() == 0) {
            return defaultTree;
        }
        if (this.allExamplesHaveSameClassification(ds)) {
            return new ConstantDecisonTree(ds.getExample(0).targetValue());
        }
        if (attributeNames.size() == 0) {
            return this.majorityValue(ds);
        }
        String chosenAttribute = this.chooseAttribute(ds, attributeNames);
        DecisionTree tree = new DecisionTree(chosenAttribute);
        ConstantDecisonTree m = this.majorityValue(ds);
        List<String> values = ds.getPossibleAttributeValues(chosenAttribute);
        for (String v : values) {
            DataSet filtered = ds.matchingDataSet(chosenAttribute, v);
            List<String> newAttribs = Util.removeFrom(attributeNames, chosenAttribute);
            DecisionTree subTree = this.decisionTreeLearning(filtered, newAttribs, m);
            tree.addNode(v, subTree);
        }
        return tree;
    }

    private ConstantDecisonTree majorityValue(DataSet ds) {
        MajorityLearner learner = new MajorityLearner();
        learner.train(ds);
        return new ConstantDecisonTree(learner.predict(ds.getExample(0)));
    }

    private String chooseAttribute(DataSet ds, List<String> attributeNames) {
        double greatestGain = 0.0;
        String attributeWithGreatestGain = attributeNames.get(0);
        for (String attr : attributeNames) {
            double gain = ds.calculateGainFor(attr);
            if (!(gain > greatestGain)) continue;
            greatestGain = gain;
            attributeWithGreatestGain = attr;
        }
        return attributeWithGreatestGain;
    }

    private boolean allExamplesHaveSameClassification(DataSet ds) {
        String classification = ds.getExample(0).targetValue();
        Iterator<Example> iter = ds.iterator();
        while (iter.hasNext()) {
            Example element = iter.next();
            if (element.targetValue().equals(classification)) continue;
            return false;
        }
        return true;
    }

    public DecisionTree getDecisionTree() {
        return this.tree;
    }
}

