/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.basic.Agent;
import aima.gui.framework.AgentAppModel;
import aima.search.map.Map;
import aima.search.map.Point2D;
import aima.search.map.Scenario;
import java.util.ArrayList;
import java.util.List;

public class MapAgentModel
extends AgentAppModel {
    protected Scenario scenario;
    protected List<String> destinations;
    private final ArrayList<String> tourHistory = new ArrayList();

    public List<String> getTourHistory() {
        return this.tourHistory;
    }

    public void clearTourHistory() {
        this.tourHistory.clear();
    }

    @Override
    public void envChanged(String command) {
        for (AgentAppModel.ModelChangedListener listener : this.listeners) {
            listener.logMessage(command);
        }
        if (this.getLocCoords(command) != null || command.equals("NoOP")) {
            String loc = (String)this.getAgent().getAttribute("location");
            this.tourHistory.add(loc);
            this.fireModelChanged();
        }
    }

    public void prepare(Scenario s, List<String> d) {
        this.scenario = s;
        this.destinations = d;
        this.clearTourHistory();
        this.fireModelChanged();
    }

    public boolean isEmpty() {
        return this.scenario == null;
    }

    public List<String> getLocations() {
        List<String> result = this.scenario.getEnvMap().getLocations();
        if (!result.containsAll(this.scenario.getAgentMap().getLocations())) {
            result = new ArrayList<String>(result);
            for (String loc : this.scenario.getAgentMap().getLocations()) {
                if (result.contains(loc)) continue;
                result.add(loc);
            }
        }
        return result;
    }

    public Map getAgentMap() {
        return this.scenario.getAgentMap();
    }

    public Map getEnvMap() {
        return this.scenario.getEnvMap();
    }

    public Agent getAgent() {
        return (Agent)this.scenario.getEnv().getAgents().get(0);
    }

    public boolean isStart(String loc) {
        return this.scenario.getInitAgentLocation() == loc;
    }

    public boolean isDestination(String loc) {
        return this.destinations != null && this.destinations.contains(loc);
    }

    public Point2D getLocCoords(String loc) {
        return this.scenario.getEnvMap().getPosition(loc);
    }

    public boolean hasInfos(String loc) {
        return false;
    }

    public boolean hasObjects(String loc) {
        return false;
    }
}

