/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import aima.search.framework.GoalTest;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.SuccessorFunction;
import aima.search.framework.TreeSearch;
import aima.search.informed.AStarSearch;
import aima.search.informed.GreedyBestFirstSearch;
import aima.search.uninformed.BreadthFirstSearch;
import aima.search.uninformed.DepthFirstSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import aima.search.uninformed.UniformCostSearch;
import com.github.daytron.simpledialogfx.dialog.Dialog;
import com.jfoenix.controls.JFXBadge;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSnackbar;
import com.jfoenix.controls.JFXToggleButton;
import fxgraph.FXEdge;
import fxgraph.FXGraph;
import fxgraph.FXGraphBuilder;
import fxgraph.FXNode;
import fxgraph.FXNodeGeneric;
import fxgraph.OnAddLink;
import fxgraph.OnRemoveNode;
import fxgraph.OnRemoveSelection;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import mcgraphresolver.Main;
import mcgraphresolver.aima_classes.informed.AStarNodeSuccessorFunction;
import mcgraphresolver.aima_classes.informed.GreedyNodeSuccessorFunction;
import mcgraphresolver.aima_classes.informed.NodeStateInformed;
import mcgraphresolver.aima_classes.uninformed.BreadthFirstNodeSuccessorFunction;
import mcgraphresolver.aima_classes.uninformed.DepthFirstNodeSuccessorFunction;
import mcgraphresolver.aima_classes.uninformed.IterativeDeepeningNodeSuccessorFunction;
import mcgraphresolver.aima_classes.uninformed.NodeStateUninformed;
import mcgraphresolver.aima_classes.uninformed.UniformCostNodeSuccessorFunction;
import mcgraphresolver.bucket.CustomNodeForHeuristicAdmissiblity;
import mcgraphresolver.bucket.License;
import mcgraphresolver.bucket.TreeNode;
import mcgraphresolver.controllers.AddNewNodeController;
import mcgraphresolver.controllers.ChooseAlgorithmController;
import mcgraphresolver.controllers.ConfirmDialogController;
import mcgraphresolver.controllers.DownloadingDialogController;
import mcgraphresolver.controllers.EditNodeController;
import mcgraphresolver.controllers.ExpansionTreeController;
import mcgraphresolver.controllers.HelpController;
import mcgraphresolver.controllers.LicenseController;
import mcgraphresolver.controllers.LinkNodesController;
import mcgraphresolver.controllers.SettingsController;
import mcgraphresolver.utils.ResourcesEnum;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class MainController
implements Initializable {
    public static int countSourceNode = 0;
    public static int countDestinationNode = 0;
    public static final int GRAPH_ORIENTED_VALUE = 0;
    public static final int GRAPH_NOT_ORIENTED_VALUE = 1;
    public static final String VERSION = "1.0.6";
    public Label lblVersion;
    public ScrollPane scroolPaneToolbar;
    public JFXButton btnPrint;
    @FXML
    private JFXButton btnGenericNode;
    public Label lblLoading;
    public JFXButton btnUpdate;
    public JFXToggleButton toggleGraphType;
    public JFXBadge badgeGenericNode;
    public JFXBadge badgeSourceNode;
    public JFXBadge badgeDestinationNode;
    public BorderPane borderPaneRoot;
    public AnchorPane anchorPaneToolbox;
    public VBox vboxGenericNode;
    public VBox vboxSourceNode;
    public JFXButton btnSourceNode;
    public VBox vboxDestinationNode;
    public JFXButton btnDestinationNode;
    public Button btnCalculate;
    public Button btnClean;
    public Pane paneGraphView;
    public BorderPane anchorPaneGraph;
    public JFXButton btnSettings;
    public ListView listViewEstimates;
    public JFXToggleButton toggleShowEstimatesLabel;
    public TitledPane titledPaneEstimates;
    public Label lblSourceNode;
    public Label lblDestinationNode;
    public Label lblGenericNode;
    public VBox vboxLoading;
    public JFXButton btnIta;
    public JFXButton btnEn;
    public JFXButton btnHelp;
    public JFXButton btnSnapshot;
    public JFXButton btnExport;
    public JFXButton btnImport;
    public JFXButton btnLinkNodes;
    public JFXButton btnRandomWeight;
    public JFXButton btnRandomEstimate;
    List<String> wrongAdmissibilityPathsList;
    private HostServices hostServices;
    private Circle dragImageView;
    private FXGraph fxGraph;
    private TreeNode tree;
    private boolean orientedGraph = true;
    private JFXSnackbar snackbar;
    private ContextMenu contextMenu;
    private boolean endOfFileFound;
    private SharePreferencesHandler sharePreferencesHandler;
    private Utils utils = new Utils();
    private ResourceBundle resourceBundle;
    private Dialog dialog;
    private Stage stage;
    private OnRemoveSelection onRemoveSelection;

    public void initialize(URL location, ResourceBundle resources) {
        this.hostServices = Main.hostServices;
        this.resourceBundle = resources;
        this.onRemoveSelection = () -> this.showConfirmDialog(this.resourceBundle.getString("text_confirm_delete_selected_node"), () -> {
            for (FXNode fxNode : this.fxGraph.getFxGraphSelectionTool().getCurrentSelection()) {
                if (!(fxNode instanceof FXNodeGeneric)) continue;
                ((FXNodeGeneric)fxNode).getOnRemoveNodeListener().onRemove(false);
            }
            return null;
        }, null, null);
        FXGraphBuilder theBuilder = FXGraphBuilder.create();
        this.fxGraph = theBuilder.build();
        this.fxGraph.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
        this.fxGraph.setOnRemoveSelection(this.onRemoveSelection);
        this.paneGraphView.getChildren().add((Object)this.fxGraph);
        this.snackbar = new JFXSnackbar((Pane)this.borderPaneRoot);
        this.scroolPaneToolbar.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.lblVersion.setText(String.format(this.resourceBundle.getString("text_version"), VERSION));
        this.listViewEstimates.getSelectionModel().selectedIndexProperty().addListener((observable, oldvalue, newValue) -> Platform.runLater(() -> this.listViewEstimates.getSelectionModel().select(-1)));
        this.sharePreferencesHandler = new SharePreferencesHandler();
        this.updateColorFromSharePreferencesHandler();
        this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
        this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
        this.lblGenericNode.setText(String.format("%s (%s)", this.resourceBundle.getString("text_generic_node"), this.resourceBundle.getString("text_simbol_infinity")));
        this.registerDragAndDropEvent((Node)this.btnGenericNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.GENERIC_NODE);
        this.registerDragAndDropEvent((Node)this.btnSourceNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.SOURCE_NODE);
        this.registerDragAndDropEvent((Node)this.btnDestinationNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.DESTINATION_NODE);
        this.btnGenericNode.setOnAction(event -> {
            float x = (float)(Math.random() * 400.0);
            float y = (float)(Math.random() * 400.0);
            this.showAddNewNode(x, y, FXNodeGeneric.nodeType.GENERIC_NODE);
        });
        this.btnSourceNode.setOnAction(event -> {
            if (countSourceNode < this.sharePreferencesHandler.getMaxNumSourceNodes()) {
                float x = (float)(Math.random() * 400.0);
                float y = (float)(Math.random() * 400.0);
                this.showAddNewNode(x, y, FXNodeGeneric.nodeType.SOURCE_NODE);
            } else {
                this.snackbar.show(String.format(this.resourceBundle.getString("text_num_source_limit"), this.sharePreferencesHandler.getMaxNumSourceNodes()), 2000L);
            }
        });
        this.btnDestinationNode.setOnAction(event -> {
            if (countDestinationNode < this.sharePreferencesHandler.getMaxNumDestinationNodes()) {
                float x = (float)(Math.random() * 400.0);
                float y = (float)(Math.random() * 400.0);
                this.showAddNewNode(x, y, FXNodeGeneric.nodeType.DESTINATION_NODE);
            } else {
                this.snackbar.show(String.format(this.resourceBundle.getString("text_num_destination_limit"), this.sharePreferencesHandler.getMaxNumDestinationNodes()), 2000L);
            }
        });
        this.btnLinkNodes.setOnAction(event -> this.showLinkNodesDialog(null));
        this.btnSnapshot.setOnAction(event -> this.saveImage(this.sharePreferencesHandler.getSnapshotPDF()));
        this.btnPrint.setOnAction(event -> this.printGraphToPrinter());
        this.btnExport.setOnAction(event -> {
            JFXSnackbar bar = new JFXSnackbar((Pane)this.borderPaneRoot);
            this.exportGraphAsFile();
        });
        this.btnImport.setOnAction(event -> {
            if (this.fxGraph.getModel().getNodes().size() == 0) {
                this.importGraphAsFile();
            } else {
                this.showConfirmDialog(this.resourceBundle.getString("text_confirm_import_new_graph"), () -> {
                    this.exportGraphAsFile();
                    this.importGraphAsFile();
                    return null;
                }, () -> {
                    this.importGraphAsFile();
                    return null;
                }, null);
            }
        });
        this.btnRandomWeight.setOnAction(event -> this.randomWeightValues());
        this.btnRandomEstimate.setOnAction(event -> this.randomEstimateValues());
        this.btnClean.setOnAction(event -> {
            if (this.fxGraph.getModel().getNodes().size() != 0) {
                this.showConfirmDialog(this.resourceBundle.getString("text_confirm_clean_all"), () -> {
                    this.clearGraph();
                    return null;
                }, null, null);
            }
        });
        this.btnCalculate.setOnAction(event -> {
            if (countSourceNode == 0) {
                JFXSnackbar bar = new JFXSnackbar((Pane)this.borderPaneRoot);
                bar.enqueue(new JFXSnackbar.SnackbarEvent(this.resourceBundle.getString("text_select_at_least_one_source")));
            } else if (countDestinationNode == 0) {
                JFXSnackbar bar = new JFXSnackbar((Pane)this.borderPaneRoot);
                bar.enqueue(new JFXSnackbar.SnackbarEvent(this.resourceBundle.getString("text_select_at_least_one_destination")));
            } else {
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_chooseAlgorithm.fxml"), this.resourceBundle);
                    loader.setResources(this.resourceBundle);
                    BorderPane pane = (BorderPane)loader.load();
                    pane.getStylesheets().add((Object)"/css/style.css");
                    Scene _scene = new Scene((Parent)pane);
                    Stage stage = new Stage();
                    ChooseAlgorithmController chooseAlgorithmController = (ChooseAlgorithmController)loader.getController();
                    stage.resizableProperty().setValue(Boolean.FALSE);
                    stage.initOwner(this.utils.getWindowOwner());
                    stage.initStyle(StageStyle.UTILITY);
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setScene(_scene);
                    stage.setTitle(this.resourceBundle.getString("text_calculate"));
                    stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                        stage.centerOnScreen();
                        Platform.runLater(() -> stage.requestFocus());
                    });
                    stage.showAndWait();
                    ChooseAlgorithmController.algorithm choosenAlgorithm = chooseAlgorithmController.getSelectedAlgorithm();
                    if (choosenAlgorithm != null) {
                        switch (choosenAlgorithm) {
                            case ASTAR_SEARCH: {
                                this.wrongAdmissibilityPathsList = new ArrayList<String>();
                                if (this.checkHeuristicAdmissible()) {
                                    this.startAStarSearch();
                                    break;
                                }
                                this.showConfirmDialog(String.format("%s\n%s", this.resourceBundle.getString("text_confirm_procede_to_calculate_graph_not_admissible"), Utils.listToString(this.wrongAdmissibilityPathsList)), () -> {
                                    this.startAStarSearch();
                                    return null;
                                }, null, null);
                                break;
                            }
                            case BREADTH_FIRST_SEARCH: {
                                this.startBreadthFirstSearch();
                                break;
                            }
                            case DEPTH_FIRST_SEARCH: {
                                this.startDepthFirstSearch();
                                break;
                            }
                            case GREEDY_BEST_FIRST_SEARCH: {
                                this.startGreedyBestFirstSearch();
                                break;
                            }
                            case UNIFORM_COST_SEARCH: {
                                this.startUniformCostSearch();
                                break;
                            }
                            case ITERATIVE_DEEPENING_SEARCH: {
                                this.startIterativeDeepeningSearch();
                                break;
                            }
                            default: {
                                this.startAStarSearch();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.dialog = new Dialog(e);
                    this.dialog.showAndWait();
                }
            }
        });
        this.btnHelp.setOnAction(event -> this.showHelp());
        this.btnSettings.setOnAction(event -> this.showSettings());
        this.btnIta.setOnAction(event -> {
            if (this.fxGraph.getModel().getNodes().size() == 0) {
                this.changeLanguage(Locale.ITALIAN);
            } else {
                this.showConfirmDialog(this.resourceBundle.getString("text_confirm_import_new_graph"), () -> {
                    this.exportGraphAsFile();
                    this.changeLanguage(Locale.ITALIAN);
                    return null;
                }, () -> {
                    this.changeLanguage(Locale.ITALIAN);
                    return null;
                }, null);
            }
        });
        this.btnEn.setOnAction(event -> {
            if (this.fxGraph.getModel().getNodes().size() == 0) {
                this.changeLanguage(Locale.ENGLISH);
            } else {
                this.showConfirmDialog(this.resourceBundle.getString("text_confirm_import_new_graph"), () -> {
                    this.exportGraphAsFile();
                    this.changeLanguage(Locale.ENGLISH);
                    return null;
                }, () -> {
                    this.changeLanguage(Locale.ENGLISH);
                    return null;
                }, null);
            }
        });
        this.toggleGraphType.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                MainController.this.orientedGraph = newValue;
                if (!newValue.booleanValue()) {
                    MainController.this.toggleGraphType.setText(MainController.this.resourceBundle.getString("text_not_oriented_graph"));
                } else {
                    MainController.this.toggleGraphType.setText(MainController.this.resourceBundle.getString("text_oriented_graph"));
                }
            }
        });
        this.toggleShowEstimatesLabel.selectedProperty().addListener((observable, oldValue, newValue) -> {
            for (FXNode fxNode : this.fxGraph.getModel().getNodes()) {
                ((FXNodeGeneric)fxNode).getLblEstimate().setVisible(newValue.booleanValue());
            }
        });
        this.btnUpdate.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                MainController.this.btnUpdate.setCursor(Cursor.HAND);
            }
        });
        this.btnUpdate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Task<Boolean> task = new Task<Boolean>(){

                    public Boolean call() {
                        MainController.this.borderPaneRoot.setDisable(true);
                        MainController.this.fxGraph.setVisible(false);
                        MainController.this.vboxLoading.setVisible(true);
                        Platform.runLater(() -> MainController.this.lblLoading.setText(MainController.this.resourceBundle.getString("text_checking_for_update")));
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MainController.this.checkUpdate();
                        return true;
                    }
                };
                task.setOnSucceeded(e -> Platform.runLater(() -> {
                    MainController.this.vboxLoading.setVisible(false);
                    Platform.runLater(() -> MainController.this.lblLoading.setText(MainController.this.resourceBundle.getString("text_loading")));
                    MainController.this.fxGraph.setVisible(true);
                    MainController.this.borderPaneRoot.setDisable(false);
                }));
                Thread thread = new Thread((Runnable)task);
                thread.setDaemon(true);
                thread.start();
            }
        });
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                MainController.this.resizeFxGraph();
            }
        }, 500L);
    }

    private void downloadUpdate(String filenameToDownloadWithExtension) {
        String FILE_URL = String.format("%s/%s", "http://provadatabaseandroid.altervista.org/javaFxFolderForDeploy/MCGraphResolver/releases", filenameToDownloadWithExtension);
        try (BufferedInputStream in = new BufferedInputStream(new URL(FILE_URL).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(String.format("%s%s%s", new File(".").getAbsolutePath(), System.getProperty("file.separator"), filenameToDownloadWithExtension));){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void checkUpdate() {
        String FILE_URL = "http://provadatabaseandroid.altervista.org/javaFxFolderForDeploy/MCGraphResolver/releases/update_mcgraphresolver.txt";
        try {
            URL url = new URL(FILE_URL);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            if (line != null) {
                // empty if block
            }
            in.close();
            if (line != null && line.length() != 0 && line.contains("#")) {
                String[] stringSplitted = line.split("#");
                String versionFilenameJarToDownload = stringSplitted[0];
                String newFilenameJarToDownload = stringSplitted[1];
                if (!VERSION.equalsIgnoreCase(versionFilenameJarToDownload.replace("_", "."))) {
                    Platform.runLater(() -> this.showConfirmDialog(String.format("%s\n%s", String.format(this.resourceBundle.getString("text_found_this_version"), versionFilenameJarToDownload), this.resourceBundle.getString("text_are_you_sure_to_download_the_latest_version")), () -> this.showDownloadingDialog(newFilenameJarToDownload), null, null));
                } else {
                    Platform.runLater(() -> this.snackbar.show(this.resourceBundle.getString("text_you_are_running_the_latest_version"), 5000L));
                }
            }
        }
        catch (MalformedURLException e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        catch (IOException e) {
            Platform.runLater(() -> this.snackbar.show(this.resourceBundle.getString("text_no_internet_connection_found"), 5000L));
        }
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void resizeFxGraph() {
        if (this.fxGraph != null) {
            this.fxGraph.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
        }
    }

    private boolean checkHeuristicAdmissible() {
        for (FXNode fxNode : this.fxGraph.getModel().getNodes()) {
            double sum;
            double heuristic;
            CustomNodeForHeuristicAdmissiblity customNodeForHeuristicAdmissiblity;
            FXNodeGeneric fxNodeGeneric;
            if (!(fxNode instanceof FXNodeGeneric) || (fxNodeGeneric = (FXNodeGeneric)fxNode).getType() == FXNodeGeneric.nodeType.DESTINATION_NODE || this.isAdmissible(customNodeForHeuristicAdmissiblity = new CustomNodeForHeuristicAdmissiblity(fxNodeGeneric, new ArrayList<FXNodeGeneric>()), heuristic = Double.parseDouble(fxNodeGeneric.getLblEstimate().getText()), sum = 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean isAdmissible(CustomNodeForHeuristicAdmissiblity customNodeForHeuristicAdmissiblity, double heuristicToCheck, double sum) {
        boolean result = true;
        Set<FXEdge> fxEdges = this.fxGraph.getModel().getEdgesWithoutDuplicateFromSourceNodeEdge(customNodeForHeuristicAdmissiblity.getFxNodeGeneric());
        for (FXEdge fxEdge : fxEdges) {
            double currentSum = 0.0;
            if (!(fxEdge.getDestination() instanceof FXNodeGeneric)) continue;
            FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxEdge.getDestination();
            if (customNodeForHeuristicAdmissiblity.getArrayListPath().contains(fxNodeGeneric)) continue;
            double weight = fxEdge.getWeight();
            currentSum = sum + weight;
            ArrayList<FXNodeGeneric> arrayList = new ArrayList<FXNodeGeneric>();
            arrayList.addAll(customNodeForHeuristicAdmissiblity.getArrayListPath());
            arrayList.add(customNodeForHeuristicAdmissiblity.getFxNodeGeneric());
            CustomNodeForHeuristicAdmissiblity nodeForHeuristicAdmissiblity = new CustomNodeForHeuristicAdmissiblity(fxNodeGeneric, arrayList);
            if (fxNodeGeneric.getType() == FXNodeGeneric.nodeType.DESTINATION_NODE) {
                boolean bl = result = result && heuristicToCheck <= currentSum;
                if (!(heuristicToCheck > currentSum)) continue;
                this.wrongAdmissibilityPathsList.add(String.format("%s%s [%s = %s]", this.getArraylistPathString(nodeForHeuristicAdmissiblity.getArrayListPath()), fxNodeGeneric.getBtnNode().getText(), this.resourceBundle.getString("text_path_cost"), String.valueOf(currentSum)));
                continue;
            }
            result = result && this.isAdmissible(nodeForHeuristicAdmissiblity, heuristicToCheck, currentSum);
        }
        return result;
    }

    public String getArraylistPathString(ArrayList<FXNodeGeneric> arrayList) {
        String results = "";
        for (FXNodeGeneric fxNodeGeneric : arrayList) {
            results = results + String.format("%s -> ", fxNodeGeneric.getBtnNode().getText());
        }
        return results;
    }

    private void startAStarSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s + %.2f = %.2f", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText(), 0.0, Double.parseDouble(this.fxGraph.getModel().getSourceNode().getLblEstimate().getText())), 0.0, "1");
        NodeStateInformed initState = new NodeStateInformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem(initState, new AStarNodeSuccessorFunction(), initState, initState, initState);
        AStarSearch search = new AStarSearch(new TreeSearch());
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_astar_search"), ChooseAlgorithmController.algorithm.ASTAR_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void startGreedyBestFirstSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText()), 0.0, "1");
        NodeStateInformed initState = new NodeStateInformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem(initState, new GreedyNodeSuccessorFunction(), initState, initState, initState);
        GreedyBestFirstSearch search = new GreedyBestFirstSearch(new TreeSearch());
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_greedy_best_first_search"), ChooseAlgorithmController.algorithm.GREEDY_BEST_FIRST_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void startBreadthFirstSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText()), 0.0, "1");
        NodeStateUninformed initState = new NodeStateUninformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)new BreadthFirstNodeSuccessorFunction(), (GoalTest)initState, initState);
        BreadthFirstSearch search = new BreadthFirstSearch(new TreeSearch());
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_breadth_first_search"), ChooseAlgorithmController.algorithm.BREADTH_FIRST_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void startDepthFirstSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText()), 0.0, "1");
        NodeStateUninformed initState = new NodeStateUninformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)new DepthFirstNodeSuccessorFunction(), (GoalTest)initState, initState);
        DepthFirstSearch search = new DepthFirstSearch(new TreeSearch());
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_depth_first_search"), ChooseAlgorithmController.algorithm.DEPTH_FIRST_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void startUniformCostSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText()), 0.0, "1");
        NodeStateUninformed initState = new NodeStateUninformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)new UniformCostNodeSuccessorFunction(), (GoalTest)initState, initState);
        UniformCostSearch search = new UniformCostSearch(new TreeSearch());
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_uniform_cost_search"), ChooseAlgorithmController.algorithm.UNIFORM_COST_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void startIterativeDeepeningSearch() {
        this.tree = new TreeNode<FXNodeGeneric>(this.fxGraph.getModel().getSourceNode(), String.format("f = %s", this.fxGraph.getModel().getSourceNode().getLblEstimate().getText()), 0.0, "1");
        NodeStateUninformed initState = new NodeStateUninformed(this.fxGraph.getModel().getSourceNode(), this.fxGraph, 0.0, this.tree, new ArrayList<FXNodeGeneric>());
        initState.setExpansionOrder(1);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)new IterativeDeepeningNodeSuccessorFunction(), (GoalTest)initState, initState);
        IterativeDeepeningSearch search = new IterativeDeepeningSearch();
        try {
            SearchAgent agent = null;
            agent = new SearchAgent(problem, search);
            this.showExpansionTree(agent, this.resourceBundle.getString("text_radio_button_iterative_deepening_search"), ChooseAlgorithmController.algorithm.ITERATIVE_DEEPENING_SEARCH);
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private <T> void printTree(TreeNode<T> node, String appender) {
        FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)node.getData();
        System.out.println(appender + fxNodeGeneric.getBtnNode().getText() + " - " + node.getLabelF() + " - [" + node.getExpansionOrder() + "]");
        node.getChildren().forEach(each -> this.printTree((TreeNode)each, appender + appender));
    }

    private void changeLanguage(Locale locale) {
        try {
            this.borderPaneRoot.getScene().setRoot((Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource("layouts/layout_main.fxml"), (ResourceBundle)ResourceBundle.getBundle("bundles.strings", locale)));
        }
        catch (IOException e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
    }

    private void registerDragAndDropEvent(Node source, Node target, Pane root, FXNodeGeneric.nodeType type) {
        this.dragImageView = new Circle(30.0);
        source.setOnDragDetected(event -> {
            if (!root.getChildren().contains((Object)this.dragImageView)) {
                root.getChildren().add((Object)this.dragImageView);
            }
            DropShadow dropShadow = new DropShadow();
            dropShadow.setRadius(5.0);
            dropShadow.setOffsetX(3.0);
            dropShadow.setOffsetY(3.0);
            dropShadow.setColor(Color.color((double)0.4, (double)0.5, (double)0.5));
            source.setEffect((Effect)dropShadow);
            this.dragImageView.setOpacity(0.5);
            this.dragImageView.toFront();
            this.dragImageView.setMouseTransparent(true);
            this.dragImageView.setVisible(true);
            this.dragImageView.relocate((double)((int)(event.getSceneX() - this.dragImageView.getBoundsInLocal().getWidth() / 2.0)), (double)((int)(event.getSceneY() - this.dragImageView.getBoundsInLocal().getHeight() / 2.0)));
            Dragboard db = source.startDragAndDrop(TransferMode.ANY);
            ClipboardContent content = new ClipboardContent();
            content.putString("Test");
            db.setContent((Map)content);
            event.consume();
        });
        source.setOnDragDone(event -> {
            this.dragImageView.setVisible(false);
            DropShadow dropShadow = new DropShadow();
            dropShadow.setRadius(10.0);
            dropShadow.setOffsetX(0.0);
            dropShadow.setOffsetY(7.0);
            dropShadow.setColor(Color.rgb((int)4, (int)5, (int)5, (double)0.2));
            source.setEffect((Effect)dropShadow);
            event.consume();
        });
        root.setOnDragOver(e -> {
            Point2D localPoint = source.getScene().getRoot().sceneToLocal(new Point2D(e.getSceneX(), e.getSceneY()));
            this.dragImageView.relocate((double)((int)(localPoint.getX() - this.dragImageView.getBoundsInLocal().getWidth() / 2.0)), (double)((int)(localPoint.getY() - this.dragImageView.getBoundsInLocal().getHeight() / 2.0)));
            e.consume();
        });
        target.setOnDragOver(event -> {
            if (event.getGestureSource() != target && event.getDragboard().hasString()) {
                DropShadow dropShadow = new DropShadow();
                dropShadow.setRadius(5.0);
                dropShadow.setOffsetX(3.0);
                dropShadow.setOffsetY(3.0);
                dropShadow.setColor(Color.color((double)0.4, (double)0.5, (double)0.5));
                target.setEffect((Effect)dropShadow);
                event.acceptTransferModes(TransferMode.ANY);
            }
        });
        target.setOnDragEntered(event -> {
            if (event.getGestureSource() != target && event.getDragboard().hasString()) {
                target.setOpacity(0.5);
            }
            event.consume();
        });
        target.setOnDragExited(event -> {
            target.setEffect(null);
            target.setOpacity(1.0);
            event.consume();
        });
        target.setOnDragDropped(t -> {
            Dragboard db = t.getDragboard();
            String string = db.getString();
            t.setDropCompleted(true);
            t.consume();
            Platform.runLater(() -> {
                if (((Object)((Object)((JFXButton)((Object)((Object)((Object)t.getGestureSource())))))).equals((Object)this.btnSourceNode) && countSourceNode < this.sharePreferencesHandler.getMaxNumSourceNodes()) {
                    this.showAddNewNode(t.getX(), t.getY(), FXNodeGeneric.nodeType.SOURCE_NODE);
                } else if (((Object)((Object)((JFXButton)((Object)((Object)((Object)t.getGestureSource())))))).equals((Object)this.btnSourceNode)) {
                    this.snackbar.show(String.format(this.resourceBundle.getString("text_num_source_limit"), this.sharePreferencesHandler.getMaxNumSourceNodes()), 2000L);
                } else if (((Object)((Object)((JFXButton)((Object)((Object)((Object)t.getGestureSource())))))).equals((Object)this.btnDestinationNode) && countDestinationNode < this.sharePreferencesHandler.getMaxNumDestinationNodes()) {
                    this.showAddNewNode(t.getX(), t.getY(), FXNodeGeneric.nodeType.DESTINATION_NODE);
                } else if (((Object)((Object)((JFXButton)((Object)((Object)((Object)t.getGestureSource())))))).equals((Object)this.btnDestinationNode)) {
                    this.snackbar.show(String.format(this.resourceBundle.getString("text_num_destination_limit"), this.sharePreferencesHandler.getMaxNumDestinationNodes()), 2000L);
                } else if (((Object)((Object)((JFXButton)((Object)((Object)((Object)t.getGestureSource())))))).equals((Object)this.btnGenericNode)) {
                    this.showAddNewNode(t.getX(), t.getY(), FXNodeGeneric.nodeType.GENERIC_NODE);
                }
            });
        });
    }

    private boolean showDownloadingDialog(String newFilenameJarToDownload) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_downloadingDialog.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            DownloadingDialogController downloadingDialogController = (DownloadingDialogController)loader.getController();
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_title_downloading"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> {
                    stage.requestFocus();
                    downloadingDialogController.downloadUpdate(newFilenameJarToDownload);
                });
            });
            stage.showAndWait();
            boolean success = downloadingDialogController.isSuccess();
            if (success) {
                Process proc = Runtime.getRuntime().exec("java -jar " + newFilenameJarToDownload);
                InputStream in = proc.getInputStream();
                InputStream err = proc.getErrorStream();
                Platform.exit();
            } else {
                this.snackbar.show(this.resourceBundle.getString("text_error_during_download"), 2000L);
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showAddNewNode(double x, double y, FXNodeGeneric.nodeType nodeType2) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_addNewNode.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            AddNewNodeController addNewNodeController = (AddNewNodeController)loader.getController();
            addNewNodeController.setFxGraph(this.fxGraph);
            addNewNodeController.setTypeNode(nodeType2);
            addNewNodeController.populateItems();
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(String.format(this.resourceBundle.getString("text_addNewNode"), FXNodeGeneric.getNodeTypeString(nodeType2, this.resourceBundle).toLowerCase()));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
            final FXNodeGeneric currentFXNodeGenericToAdd = addNewNodeController.getFXNodeGenericToAdd();
            if (currentFXNodeGenericToAdd != null) {
                currentFXNodeGenericToAdd.setOwner(this.fxGraph);
                currentFXNodeGenericToAdd.setPosition(x, y);
                currentFXNodeGenericToAdd.setType(nodeType2);
                if (nodeType2 == FXNodeGeneric.nodeType.SOURCE_NODE) {
                    ++countSourceNode;
                }
                if (nodeType2 == FXNodeGeneric.nodeType.DESTINATION_NODE) {
                    ++countDestinationNode;
                }
                this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
                this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
                this.registerMouseClickEventOnNode(currentFXNodeGenericToAdd);
                currentFXNodeGenericToAdd.setOnRemoveNodeListener(new OnRemoveNode(){

                    @Override
                    public void onRemove(boolean isConfirmRequest) {
                        if (isConfirmRequest) {
                            MainController.this.showConfirmDialog(MainController.this.resourceBundle.getString("text_confirm_delete_selected_node"), () -> {
                                MainController.this.removeNodeFromGraph(currentFXNodeGenericToAdd);
                                MainController.this.fxGraph.getFxGraphSelectionTool().resetSelection();
                                MainController.this.fxGraph.getFxGraphSelectionTool().updateSelectionInScene();
                                return null;
                            }, null, null);
                        } else {
                            MainController.this.removeNodeFromGraph(currentFXNodeGenericToAdd);
                        }
                    }

                    @Override
                    public String getTextDeleteNode() {
                        return MainController.this.resourceBundle.getString("text_delete_node");
                    }
                });
                currentFXNodeGenericToAdd.setOnAddLinkToNodeListener(new OnAddLink(){

                    @Override
                    public void onAddLink() {
                        MainController.this.showLinkNodesDialog(currentFXNodeGenericToAdd.getBtnNode().getText());
                    }

                    @Override
                    public String getTextNodeToLink() {
                        return MainController.this.resourceBundle.getString("text_add_link");
                    }
                });
                this.fxGraph.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
                this.fxGraph.addNode(currentFXNodeGenericToAdd);
                this.paneGraphView.getChildren().clear();
                this.paneGraphView.getChildren().add(0, (Object)this.fxGraph);
                currentFXNodeGenericToAdd.getLblEstimate().setVisible(this.toggleShowEstimatesLabel.isSelected());
                Label lblListItem = new Label(currentFXNodeGenericToAdd.getBtnNode().getText() + " [" + currentFXNodeGenericToAdd.getLblEstimate().getText() + "]");
                lblListItem.setStyle("-fx-font-family: 'Roboto Medium'; -fx-font-size: 12px");
                this.refreshEstimateList();
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private void registerMouseClickEventOnNode(FXNodeGeneric fxNodeGeneric) {
        fxNodeGeneric.getVBox().setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
                this.showEditNode(fxNodeGeneric);
            }
            if (event.getButton().equals((Object)MouseButton.SECONDARY)) {
                VBox vBox = fxNodeGeneric.getVBox();
                vBox.setOnContextMenuRequested(event1 -> fxNodeGeneric.getContextMenu().show((Node)vBox, event1.getScreenX(), event1.getScreenY()));
            }
        });
        fxNodeGeneric.getVBox().setOnMouseReleased(mouseEvent -> {
            this.contextMenu.hide();
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                VBox vBox = fxNodeGeneric.getVBox();
                fxNodeGeneric.getContextMenu().show((Node)vBox, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        });
    }

    private boolean removeNodeFromGraph(FXNodeGeneric currentFXNodeGenericToAdd) {
        this.removeEstimateNodeFromList(currentFXNodeGenericToAdd);
        this.fxGraph.removeEdges(this.fxGraph.getModel().getEdgesFromNode(currentFXNodeGenericToAdd));
        if (this.fxGraph.getModel().getEdges().size() == 0) {
            this.toggleGraphType.setDisable(false);
        }
        this.fxGraph.removeNode(currentFXNodeGenericToAdd);
        if (currentFXNodeGenericToAdd.getType() == FXNodeGeneric.nodeType.DESTINATION_NODE) {
            --countDestinationNode;
        }
        if (currentFXNodeGenericToAdd.getType() == FXNodeGeneric.nodeType.SOURCE_NODE) {
            --countSourceNode;
        }
        this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
        this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
        this.fxGraph.getContentPane().getChildren().remove((Object)currentFXNodeGenericToAdd.getVBox());
        return true;
    }

    private boolean showExpansionTree(SearchAgent agent, String title, ChooseAlgorithmController.algorithm choosenAlgorithm) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_expansionTree.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            Parent root = (Parent)loader.load();
            root.getStylesheets().add((Object)"/css/style.css");
            final Stage stage = new Stage();
            Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
            Scene scene = new Scene(root, screenSize.getWidth(), screenSize.getHeight());
            stage.setTitle(this.resourceBundle.getString("text_title"));
            ExpansionTreeController expansionTreeController = (ExpansionTreeController)loader.getController();
            expansionTreeController.setTitleSearch(title);
            expansionTreeController.setFxGraph(this.fxGraph);
            expansionTreeController.setTree(this.tree);
            expansionTreeController.setAgent(agent);
            expansionTreeController.setSharePreferencesHandles(this.sharePreferencesHandler);
            expansionTreeController.setChoosenAlgorithmType(choosenAlgorithm);
            stage.setScene(scene);
            stage.setMaximized(true);
            stage.widthProperty().addListener((observable, oldValue, newValue) -> {
                stage.setWidth(screenSize.getWidth());
                expansionTreeController.resizeFxGraph();
            });
            stage.heightProperty().addListener((observable, oldValue, newValue) -> {
                stage.setHeight(screenSize.getHeight());
                expansionTreeController.resizeFxGraph();
            });
            stage.getIcons().add((Object)new Image(Main.class.getResourceAsStream("/icons/logo_mc_graph_resolver.png")));
            Task<Boolean> task = new Task<Boolean>(){

                public Boolean call() {
                    stage.show();
                    return true;
                }
            };
            task.setOnSucceeded(e -> Platform.runLater(() -> expansionTreeController.populateItems()));
            new Thread((Runnable)task).run();
        }
        catch (Exception e2) {
            this.dialog = new Dialog(e2);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showEditNode(FXNodeGeneric nodeToEdit) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_editNode.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            EditNodeController editNodeController = (EditNodeController)loader.getController();
            editNodeController.setFxGraph(this.fxGraph);
            editNodeController.setNodeToEdit(nodeToEdit);
            editNodeController.populateItems();
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            Button buttonNodeToEdit = (Button)((VBox)nodeToEdit.getWrappedNode()).getChildren().get(1);
            stage.setTitle(String.format(this.resourceBundle.getString("text_editNodeTitle"), buttonNodeToEdit.getText()));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
            FXNodeGeneric nodeEdited = editNodeController.getFxNodeGenericToEdit();
            if (nodeEdited != null) {
                this.fxGraph.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
                this.paneGraphView.getChildren().clear();
                this.paneGraphView.getChildren().add(0, (Object)this.fxGraph);
                this.refreshEstimateList();
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showLinkNodesDialog(String nodeLabel) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_linkNodes.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            LinkNodesController controller = (LinkNodesController)loader.getController();
            controller.setGraph(this.fxGraph);
            controller.setOrientedGraph(this.orientedGraph);
            controller.populateItems(nodeLabel);
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_link_nodes"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
            List<FXEdge> fxEdges = controller.getResults();
            if (fxEdges != null) {
                FXNodeGeneric fxNodeGenericSource = controller.getFxNodeGenericSource();
                if (this.orientedGraph) {
                    this.fxGraph.removeEdges(this.fxGraph.getModel().getEdgesWithoutDuplicateFromSourceNodeEdge(fxNodeGenericSource));
                } else {
                    this.fxGraph.removeEdges(this.fxGraph.getModel().getEdgesFromNode(fxNodeGenericSource));
                }
                for (FXEdge fxEdge : fxEdges) {
                    this.fxGraph.addEdge(fxEdge);
                }
                if (this.fxGraph.getModel().getEdges().size() > 0) {
                    this.toggleGraphType.setDisable(true);
                } else {
                    this.toggleGraphType.setDisable(false);
                }
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showConfirmDialog(String contentText, Callable positiveCallable, Callable negativeCallable, Callable neutralCallable) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_confirmDialog.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            ConfirmDialogController confirmDialogController = (ConfirmDialogController)loader.getController();
            confirmDialogController.setContent(contentText);
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_title_confirm_dialog"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
            ResourcesEnum.CONFIRM_DIALOG_BUTTON_TYPE result = confirmDialogController.getTypeButtonResult();
            if (result == ResourcesEnum.CONFIRM_DIALOG_BUTTON_TYPE.POSITIVE_BUTTON) {
                if (positiveCallable != null) {
                    positiveCallable.call();
                }
            } else if (result == ResourcesEnum.CONFIRM_DIALOG_BUTTON_TYPE.NEGATIVE_BUTTON) {
                if (negativeCallable != null) {
                    negativeCallable.call();
                }
            } else if (neutralCallable != null) {
                neutralCallable.call();
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private void removeEstimateNodeFromList(FXNodeGeneric fxNodeGeneric) {
        for (Object label : this.listViewEstimates.getItems()) {
            Label item = (Label)label;
            if (!item.getText().equalsIgnoreCase(fxNodeGeneric.getBtnNode().getText() + " [" + fxNodeGeneric.getLblEstimate().getText() + "]")) continue;
            this.listViewEstimates.getItems().remove((Object)item);
            return;
        }
    }

    private void refreshEstimateList() {
        this.listViewEstimates.getItems().clear();
        ArrayList<Label> listEstimates = new ArrayList<Label>();
        for (FXNode fxNode : this.fxGraph.getModel().getNodes()) {
            FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxNode;
            Label item = new Label(String.format("%s [%s]", fxNodeGeneric.getBtnNode().getText(), fxNodeGeneric.getLblEstimate().getText()));
            item.setStyle("-fx-font-family: 'Roboto Medium'; -fx-font-size: 12px");
            switch (fxNodeGeneric.getType()) {
                case SOURCE_NODE: {
                    item.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000")));
                    break;
                }
                case DESTINATION_NODE: {
                    item.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853")));
                    break;
                }
                default: {
                    item.setTextFill((Paint)Color.BLACK);
                }
            }
            listEstimates.add(item);
        }
        Collections.sort(listEstimates, (o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
        this.listViewEstimates.getItems().addAll(listEstimates);
    }

    private void clearGraph() {
        this.paneGraphView.getChildren().clear();
        FXGraphBuilder theBuilder = FXGraphBuilder.create();
        this.fxGraph = theBuilder.build();
        this.fxGraph.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
        this.fxGraph.setOnRemoveSelection(this.onRemoveSelection);
        this.paneGraphView.getChildren().add((Object)this.fxGraph);
        this.registerDragAndDropEvent((Node)this.btnGenericNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.GENERIC_NODE);
        this.registerDragAndDropEvent((Node)this.btnSourceNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.SOURCE_NODE);
        this.registerDragAndDropEvent((Node)this.btnDestinationNode, (Node)this.fxGraph, (Pane)this.borderPaneRoot, FXNodeGeneric.nodeType.DESTINATION_NODE);
        countDestinationNode = 0;
        countSourceNode = 0;
        this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
        this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
        this.listViewEstimates.getItems().clear();
        this.toggleGraphType.setDisable(false);
        this.populateItems();
    }

    private boolean showHelp() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_help.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            HelpController helpController = (HelpController)loader.getController();
            helpController.setHostServices(this.hostServices);
            helpController.setSharePreferencesHandles(this.sharePreferencesHandler);
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            _scene.setFill((Paint)Color.TRANSPARENT);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_title_help"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showLicense() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_license.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            LicenseController licenseController = (LicenseController)loader.getController();
            ArrayList<License> licenseList = new ArrayList<License>();
            licenseList.add(new License("JFoenix", "https://github.com/jfoenixadmin/JFoenix", "Copyright \u00a9 JFoenix 2015-2017", License.licenseType.APACHE20));
            licenseList.add(new License("Aimacode", "https://github.com/aimacode/aima-java", "Copyright (c) 2015 aima-java contributors", License.licenseType.MIT));
            licenseList.add(new License("Javafxgraph", "https://github.com/mirkosertic/javafxgraph", "Copyright (C) 2007 Free Software Foundation", License.licenseType.LGPL3));
            licenseController.setLicenseList(licenseList);
            licenseController.setSharePreferencesHandles(this.sharePreferencesHandler);
            licenseController.setHostServices(this.hostServices);
            licenseController.populateItems();
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            _scene.setFill((Paint)Color.TRANSPARENT);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_license_open_source"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    private boolean showSettings() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getClassLoader().getResource("layouts/layout_settings.fxml"), this.resourceBundle);
            loader.setResources(this.resourceBundle);
            BorderPane pane = (BorderPane)loader.load();
            pane.getStylesheets().add((Object)"/css/style.css");
            Scene _scene = new Scene((Parent)pane);
            Stage stage = new Stage();
            SettingsController settingsController = (SettingsController)loader.getController();
            settingsController.setSharePreferencesHandles(this.sharePreferencesHandler);
            settingsController.setCurrentSourceNodeCount(countSourceNode);
            settingsController.setCurrentDestinationNodeCount(countDestinationNode);
            settingsController.populateItems();
            stage.resizableProperty().setValue(Boolean.FALSE);
            stage.initOwner(this.utils.getWindowOwner());
            stage.initStyle(StageStyle.UTILITY);
            _scene.setFill((Paint)Color.TRANSPARENT);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(_scene);
            stage.setTitle(this.resourceBundle.getString("text_settings"));
            stage.addEventHandler(WindowEvent.WINDOW_SHOWING, window -> {
                stage.centerOnScreen();
                Platform.runLater(() -> stage.requestFocus());
            });
            stage.showAndWait();
            if (settingsController.isConfirmed()) {
                this.updateColorFromSharePreferencesHandler();
            }
        }
        catch (Exception e) {
            this.dialog = new Dialog(e);
            this.dialog.showAndWait();
        }
        return true;
    }

    public void updateColorFromSharePreferencesHandler() {
        String btnSourceNodeColor = this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000");
        String btnDestinationNodeColor = this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853");
        String btnGenericNodeColor = this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4");
        String textColorInsideButton = this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE));
        String edgeColor = this.sharePreferencesHandler.getColorResource("color_edge", Utils.toRGBCode(Color.BLUE));
        String weigthTextColor = this.sharePreferencesHandler.getColorResource("color_weight", Utils.toRGBCode(Color.BLACK));
        String estimateTextColor = this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK));
        this.btnSourceNode.setStyle("-fx-background-color: " + btnSourceNodeColor + ";");
        this.btnDestinationNode.setStyle("-fx-background-color: " + btnDestinationNodeColor + ";");
        this.btnGenericNode.setStyle("-fx-background-color: " + btnGenericNodeColor + ";");
        for (FXNode fxNode : this.fxGraph.getModel().getNodes()) {
            FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxNode;
            fxNodeGeneric.getLblEstimate().setTextFill((Paint)Color.web((String)estimateTextColor));
            if (fxNodeGeneric.getType() == FXNodeGeneric.nodeType.SOURCE_NODE) {
                fxNodeGeneric.setBackgroundColor(Color.web((String)btnSourceNodeColor));
            } else if (fxNodeGeneric.getType() == FXNodeGeneric.nodeType.DESTINATION_NODE) {
                fxNodeGeneric.setBackgroundColor(Color.web((String)btnDestinationNodeColor));
            } else {
                fxNodeGeneric.setBackgroundColor(Color.web((String)btnGenericNodeColor));
            }
            fxNodeGeneric.getBtnNode().setTextFill((Paint)Color.web((String)textColorInsideButton));
        }
        for (FXEdge fxEdge : this.fxGraph.getModel().getEdges()) {
            fxEdge.setEdgeColor(edgeColor);
            fxEdge.setWeightTextColor(weigthTextColor);
        }
        this.refreshEstimateList();
        this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
        this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
    }

    public void saveBeforeClose(final WindowEvent windowEvent) {
        if (this.fxGraph.getModel().getNodes().size() != 0) {
            this.showConfirmDialog(this.resourceBundle.getString("text_confirm_import_new_graph"), () -> {
                this.exportGraphAsFile();
                return null;
            }, null, new Callable(){

                public Object call() throws Exception {
                    windowEvent.consume();
                    return null;
                }
            });
        }
    }

    public void populateItems() {
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnGenericNode.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnSourceNode.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnDestinationNode.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnLinkNodes.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnSnapshot.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnRandomWeight.fire());
        this.scroolPaneToolbar.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnRandomEstimate.fire());
    }

    public void setHostServices(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    private void saveListFile(File dirDestination) {
        if (dirDestination != null) {
            String absolutePathDir = dirDestination.getAbsolutePath();
            String absolutePath = String.format("%s%s%s_%s_%s_%s.%s", absolutePathDir, System.getProperty("file.separator"), this.resourceBundle.getString("text_snapshot_name_mc_graph_resolver"), this.toggleGraphType.isSelected() ? this.resourceBundle.getString("text_snapshot_name_oriented") : this.resourceBundle.getString("text_snapshot_name_not_oriented"), this.resourceBundle.getString("text_snapshot_name_estimate_list"), Utils.getTimestamp(), "txt");
            ObservableList list = this.listViewEstimates.getItems();
            PrintWriter fw = null;
            try {
                fw = new PrintWriter(absolutePath);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Object o : list) {
                    if (!(o instanceof Label)) continue;
                    bw.write(((Label)o).getText());
                    bw.newLine();
                }
                bw.close();
                fw.close();
            }
            catch (IOException e) {
                this.dialog = new Dialog(e);
                this.dialog.showAndWait();
            }
        }
    }

    private static PrintService findPrintService(String printerName) {
        PrintService[] printServices;
        for (PrintService printService : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().trim().equals(printerName)) continue;
            return printService;
        }
        return null;
    }

    private void saveImage(boolean pdfExtension) {
        Stage stage;
        File selectedDirectory;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_for_image"));
        File defaultFolder = new File(this.sharePreferencesHandler.getDefaultFolderForSnapshot(""));
        if (defaultFolder.exists()) {
            directoryChooser.setInitialDirectory(defaultFolder);
        }
        if ((selectedDirectory = directoryChooser.showDialog((Window)(stage = new Stage()))) != null) {
            String absolutePathDir = selectedDirectory.getAbsolutePath();
            BufferedImage bufferedImage = new BufferedImage(550, 400, 2);
            String absolutePath = String.format("%s%s%s_%s_%s_%s.%s", absolutePathDir, System.getProperty("file.separator"), this.resourceBundle.getString("text_snapshot_name_mc_graph_resolver"), this.resourceBundle.getString("text_snapshot_name_graph"), this.toggleGraphType.isSelected() ? this.resourceBundle.getString("text_snapshot_name_oriented") : this.resourceBundle.getString("text_snapshot_name_not_oriented"), Utils.getTimestamp(), "png");
            File file = new File(absolutePath);
            WritableImage snapshot = this.paneGraphView.snapshot(new SnapshotParameters(), null);
            BufferedImage image = SwingFXUtils.fromFXImage((Image)snapshot, (BufferedImage)bufferedImage);
            try {
                Graphics2D gd = (Graphics2D)image.getGraphics();
                gd.translate(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
                ImageIO.write((RenderedImage)image, "png", file);
                this.snackbar.show(this.resourceBundle.getString("text_screenshot_acquired"), this.resourceBundle.getString("text_open_saved_image"), 5000L, Utils.openFileWithDefaultOSProgram(file));
            }
            catch (IOException ex) {
                this.dialog = new Dialog(ex);
                this.dialog.showAndWait();
            }
            if (this.sharePreferencesHandler.getCompleteSnapshot()) {
                this.saveListFile(selectedDirectory);
            }
        }
    }

    private void printGraphToPrinter() {
        for (FXNode node : this.fxGraph.getModel().getNodes()) {
            if (node instanceof FXNodeGeneric) {
                VBox vBox = new VBox();
                Label lblEstimate = new Label(((FXNodeGeneric)node).getLblEstimate().getText());
                lblEstimate.setStyle("-fx-font-size: 15px; -fx-border-color: black; -fx-padding: 3px;");
                Button btnNode = new Button(((FXNodeGeneric)node).getBtnNode().getText());
                btnNode.getStyleClass().add((Object)"custom-jfx-button-fab-node");
                btnNode.setStyle("-fx-background-color: #00b8d4;");
                if (((FXNodeGeneric)node).getType() == FXNodeGeneric.nodeType.SOURCE_NODE) {
                    btnNode.setStyle("-fx-background-color: " + this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000") + ";");
                } else if (((FXNodeGeneric)node).getType() == FXNodeGeneric.nodeType.DESTINATION_NODE) {
                    btnNode.setStyle("-fx-background-color: " + this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853") + ";");
                } else {
                    btnNode.setStyle("-fx-background-color: " + this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4") + ";");
                }
                lblEstimate.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK))));
                btnNode.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE))));
                btnNode.setMouseTransparent(true);
                vBox.setAlignment(Pos.CENTER);
                vBox.setSpacing(5.0);
                vBox.setPadding(new Insets(2.0));
                vBox.getChildren().add((Object)lblEstimate);
                vBox.getChildren().add((Object)btnNode);
                vBox.requestFocus();
                vBox.setLayoutX(node.getWrappedNode().getLayoutX());
                vBox.setLayoutY(node.getWrappedNode().getLayoutY());
                vBox.setScaleX(node.getWrappedNode().getScaleX());
                vBox.setScaleY(node.getWrappedNode().getScaleY());
                this.paneGraphView.getChildren().add((Object)vBox);
            }
            node.getWrappedNode().setVisible(false);
        }
        try {
            Utils.printNode((Node)this.paneGraphView);
            for (FXNode fxNode : this.fxGraph.getModel().getNodes()) {
                fxNode.getWrappedNode().setVisible(true);
            }
            this.paneGraphView.getChildren().clear();
            this.paneGraphView.getChildren().add((Object)this.fxGraph);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportGraphAsFile() {
        Stage stage = new Stage();
        FileChooser fileChooser = new FileChooser();
        File defaultFolder = new File(this.sharePreferencesHandler.getDefaultFolderForImportExport(""));
        if (defaultFolder.exists()) {
            fileChooser.setInitialDirectory(defaultFolder);
        }
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(this.resourceBundle.getString("text_description_file_chooser_for_file_mc"), new String[]{"*.mc"});
        fileChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_for_file"));
        String initialFileNameInFileChooser = String.format("%s_%s_%s_%s", this.resourceBundle.getString("text_snapshot_name_mc_graph_resolver"), this.resourceBundle.getString("text_snapshot_name_graph"), this.toggleGraphType.isSelected() ? this.resourceBundle.getString("text_snapshot_name_oriented") : this.resourceBundle.getString("text_snapshot_name_not_oriented"), Utils.getTimestamp());
        fileChooser.setInitialFileName(initialFileNameInFileChooser);
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            String absolutePathFile = file.getAbsolutePath();
            if (!absolutePathFile.endsWith("mc")) {
                absolutePathFile = absolutePathFile + ".mc";
                file = new File(absolutePathFile);
            }
            PrintWriter out = null;
            try {
                out = new PrintWriter(absolutePathFile);
                Collection<FXNode> nodesSource = this.fxGraph.getModel().getNodesByNodeType(FXNodeGeneric.nodeType.SOURCE_NODE);
                Collection<FXNode> nodesDestination = this.fxGraph.getModel().getNodesByNodeType(FXNodeGeneric.nodeType.DESTINATION_NODE);
                Collection<FXNode> nodesGeneric = this.fxGraph.getModel().getNodesByNodeType(FXNodeGeneric.nodeType.GENERIC_NODE);
                Set<FXEdge> fxEdgesSet = this.fxGraph.getModel().getEdges();
                String ns = String.format("%s %d", ".ns", nodesSource.size());
                String nd = String.format("%s %d", ".nd", nodesDestination.size());
                String ng = String.format("%s %d", ".ng", nodesGeneric.size());
                String l = String.format("%s %d", ".l", fxEdgesSet.size());
                String o = String.format("%s %d", ".o", this.toggleGraphType.isSelected() ? 0 : 1);
                out.println(String.format("%s\n%s\n%s\n%s\n%s", ns, ng, nd, l, o));
                this.printNodesForExportFile(nodesSource, out);
                this.printNodesForExportFile(nodesDestination, out);
                this.printNodesForExportFile(nodesGeneric, out);
                this.printLinksForExportFile(fxEdgesSet, out);
                out.println(".end");
            }
            catch (FileNotFoundException ex) {
                this.dialog = new Dialog(ex);
                this.dialog.showAndWait();
            }
            finally {
                if (out != null) {
                    out.close();
                    this.snackbar.show(this.resourceBundle.getString("text_file_exported_with_success"), this.resourceBundle.getString("text_open_saved_file"), 5000L, Utils.openFileWithDefaultOSProgram(file));
                }
            }
        }
    }

    private void importGraphAsFile() {
        this.anchorPaneToolbox.setDisable(true);
        this.borderPaneRoot.getBottom().setDisable(true);
        this.borderPaneRoot.getTop().setDisable(true);
        Stage stage = new Stage();
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(this.resourceBundle.getString("text_description_file_chooser_for_file_mc"), new String[]{"*.mc"});
        fileChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_import_file"));
        File defaultFolder = new File(this.sharePreferencesHandler.getDefaultFolderForImportExport(""));
        if (defaultFolder.exists()) {
            fileChooser.setInitialDirectory(defaultFolder);
        }
        fileChooser.getExtensionFilters().add((Object)extFilter);
        ArrayList<String> fileLines = new ArrayList<String>();
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            String absolutePathFile = file.getAbsolutePath();
            if (absolutePathFile.endsWith(".mc")) {
                int numGenericNodes = 0;
                int numSourceNodes = 0;
                int numDestinationNodes = 0;
                int numLinks = 0;
                int oriented = 0;
                try {
                    String readLine;
                    FileReader fileReader = new FileReader(file);
                    BufferedReader b = new BufferedReader(fileReader);
                    int countLine = 0;
                    this.endOfFileFound = false;
                    while ((readLine = b.readLine()) != null) {
                        if (countLine < 5) {
                            String[] strSplitted = readLine.split(" ");
                            String prefix = "";
                            String possibleNumber = "";
                            if (strSplitted.length != 2) break;
                            prefix = strSplitted[0];
                            possibleNumber = strSplitted[1];
                            switch (countLine) {
                                case 0: {
                                    if (!prefix.equals(".ns")) break;
                                    numSourceNodes = Integer.parseInt(possibleNumber);
                                    break;
                                }
                                case 1: {
                                    if (!prefix.equals(".ng")) break;
                                    numGenericNodes = Integer.parseInt(possibleNumber);
                                    break;
                                }
                                case 2: {
                                    if (!prefix.equals(".nd")) break;
                                    numDestinationNodes = Integer.parseInt(possibleNumber);
                                    break;
                                }
                                case 3: {
                                    if (!prefix.equals(".l")) break;
                                    numLinks = Integer.parseInt(possibleNumber);
                                    break;
                                }
                                case 4: {
                                    if (!prefix.equals(".o")) break;
                                    oriented = Integer.parseInt(possibleNumber);
                                }
                            }
                        } else {
                            if (readLine.equalsIgnoreCase(".end")) {
                                this.endOfFileFound = true;
                                b.close();
                                break;
                            }
                            fileLines.add(readLine);
                        }
                        ++countLine;
                    }
                    b.close();
                }
                catch (IOException | NumberFormatException b) {
                    // empty catch block
                }
                if (this.endOfFileFound || fileLines.size() != 0) {
                    if (numSourceNodes <= this.sharePreferencesHandler.getMaxNumSourceNodes()) {
                        if (numDestinationNodes <= this.sharePreferencesHandler.getMaxNumDestinationNodes()) {
                            this.clearGraph();
                            this.toggleGraphType.setSelected(oriented == 0);
                            if (!this.getNodeImported(FXNodeGeneric.nodeType.SOURCE_NODE, numSourceNodes, fileLines)) {
                                if (!this.getNodeImported(FXNodeGeneric.nodeType.DESTINATION_NODE, numDestinationNodes, fileLines)) {
                                    if (!this.getNodeImported(FXNodeGeneric.nodeType.GENERIC_NODE, numGenericNodes, fileLines)) {
                                        if (!this.getEgdesImported(numLinks, fileLines)) {
                                            countSourceNode = numSourceNodes;
                                            countDestinationNode = numDestinationNodes;
                                            this.lblSourceNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes() - countSourceNode));
                                            this.lblDestinationNode.setText(String.format("%s (%d)", this.resourceBundle.getString("text_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes() - countDestinationNode));
                                            this.paneGraphView.getChildren().clear();
                                            Task<Boolean> task = new Task<Boolean>(){

                                                public Boolean call() {
                                                    MainController.this.fxGraph.setVisible(false);
                                                    MainController.this.vboxLoading.setVisible(true);
                                                    MainController.this.paneGraphView.getChildren().add((Object)MainController.this.fxGraph);
                                                    return true;
                                                }
                                            };
                                            task.setOnSucceeded(e -> Platform.runLater(() -> {
                                                this.vboxLoading.setVisible(false);
                                                this.fxGraph.setVisible(true);
                                                this.toggleGraphType.setDisable(true);
                                            }));
                                            new Thread((Runnable)task).run();
                                        } else {
                                            this.clearGraph();
                                            this.snackbar.show(this.resourceBundle.getString("text_import_file_error_something_went_wrong_edge"), 5000L);
                                        }
                                    } else {
                                        this.clearGraph();
                                        this.listViewEstimates.getItems().clear();
                                        this.snackbar.show(this.resourceBundle.getString("text_import_file_error_something_went_wrong_generic_nodes"), 5000L);
                                    }
                                } else {
                                    this.clearGraph();
                                    this.listViewEstimates.getItems().clear();
                                    this.snackbar.show(this.resourceBundle.getString("text_import_file_error_something_went_wrong_destination_nodes"), 5000L);
                                }
                            } else {
                                this.clearGraph();
                                this.listViewEstimates.getItems().clear();
                                this.snackbar.show(this.resourceBundle.getString("text_import_file_error_something_went_wrong_source_nodes"), 5000L);
                            }
                        } else {
                            this.snackbar.show(String.format(this.resourceBundle.getString("text_import_file_error_destination_num"), this.sharePreferencesHandler.getMaxNumDestinationNodes(), numDestinationNodes), 5000L);
                        }
                    } else {
                        this.snackbar.show(String.format(this.resourceBundle.getString("text_import_file_error_source_num"), this.sharePreferencesHandler.getMaxNumSourceNodes(), numSourceNodes), 5000L);
                    }
                } else {
                    this.snackbar.show(this.resourceBundle.getString("text_import_file_error_something_went_wrong"), 5000L);
                }
            } else {
                this.snackbar.show(String.format(this.resourceBundle.getString("text_import_file_error_no_valid_extension"), "mc"), 5000L);
            }
        }
        this.anchorPaneToolbox.setDisable(false);
        this.borderPaneRoot.getBottom().setDisable(false);
        this.borderPaneRoot.getTop().setDisable(false);
    }

    private boolean getNodeImported(FXNodeGeneric.nodeType nodeType2, int numOfNodes, List<String> fileLines) {
        this.fxGraph.getZoomHandler().zoomIn(numOfNodes / 2);
        for (int i = 0; i < numOfNodes; ++i) {
            double y;
            double x;
            double estimate;
            String label;
            String[] strSplitted = fileLines.get(0).split("#");
            try {
                label = strSplitted[0];
                String estimateString = strSplitted[1];
                String xString = strSplitted[2];
                String yString = strSplitted[3];
                estimate = Double.parseDouble(estimateString);
                x = Double.parseDouble(xString);
                y = Double.parseDouble(yString);
            }
            catch (NumberFormatException nf) {
                return true;
            }
            catch (NullPointerException np) {
                return true;
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                return true;
            }
            if (estimate >= 0.0 && estimate <= 999999.99) {
                if (label.length() > 20) {
                    return true;
                }
            } else {
                return true;
            }
            final FXNodeGeneric fxNodeGeneric = new FXNodeGeneric(label, estimate, this.fxGraph);
            fxNodeGeneric.setOwner(this.fxGraph);
            fxNodeGeneric.setType(nodeType2);
            fxNodeGeneric.setPosition(x, y);
            this.registerMouseClickEventOnNode(fxNodeGeneric);
            fxNodeGeneric.setOnRemoveNodeListener(new OnRemoveNode(){

                @Override
                public void onRemove(boolean isConfirmRequest) {
                    if (isConfirmRequest) {
                        MainController.this.showConfirmDialog(MainController.this.resourceBundle.getString("text_confirm_delete_selected_node"), () -> {
                            MainController.this.removeNodeFromGraph(fxNodeGeneric);
                            MainController.this.fxGraph.getFxGraphSelectionTool().resetSelection();
                            MainController.this.fxGraph.getFxGraphSelectionTool().updateSelectionInScene();
                            return null;
                        }, null, null);
                    } else {
                        MainController.this.removeNodeFromGraph(fxNodeGeneric);
                    }
                }

                @Override
                public String getTextDeleteNode() {
                    return MainController.this.resourceBundle.getString("text_delete_node");
                }
            });
            fxNodeGeneric.setOnAddLinkToNodeListener(new OnAddLink(){

                @Override
                public void onAddLink() {
                    MainController.this.showLinkNodesDialog(fxNodeGeneric.getBtnNode().getText());
                }

                @Override
                public String getTextNodeToLink() {
                    return MainController.this.resourceBundle.getString("text_add_link");
                }
            });
            fxNodeGeneric.getLblEstimate().setVisible(this.toggleShowEstimatesLabel.isSelected());
            this.fxGraph.addNode(fxNodeGeneric);
            Label lblListItem = new Label(fxNodeGeneric.getBtnNode().getText() + " [" + fxNodeGeneric.getLblEstimate().getText() + "]");
            lblListItem.setStyle("-fx-font-family: 'Roboto Medium'; -fx-font-size: 12px");
            this.refreshEstimateList();
            fileLines.remove(0);
        }
        return false;
    }

    private boolean getEgdesImported(int numOfEdges, List<String> fileLines) {
        for (int i = 0; i < numOfEdges; ++i) {
            double weight;
            String labelDestination;
            String labelSource;
            String[] strSplitted = fileLines.get(0).split("#");
            try {
                labelSource = strSplitted[0];
                labelDestination = strSplitted[1];
                String weightString = strSplitted[2];
                weight = Double.parseDouble(weightString);
            }
            catch (NumberFormatException nf) {
                return true;
            }
            catch (NullPointerException np) {
                return true;
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                return true;
            }
            if (weight >= 0.0 && weight <= 999999.99) {
                if (labelSource.length() > 20 && labelDestination.length() > 20) {
                    return true;
                }
            } else {
                return true;
            }
            FXNode fxNodeSource = this.fxGraph.getModel().getNodeGeneric(labelSource);
            FXNode fxNodeDestination = this.fxGraph.getModel().getNodeGeneric(labelDestination);
            FXEdge fxEdge = new FXEdge(this.fxGraph, fxNodeSource, fxNodeDestination);
            fxEdge.setWeight(weight);
            FXEdge fxEdgeReverse = new FXEdge(this.fxGraph, fxNodeDestination, fxNodeSource);
            fxEdgeReverse.setWeight(weight);
            fxEdge.setOriented(this.toggleGraphType.isSelected());
            this.fxGraph.addEdge(fxEdge);
            fileLines.remove(0);
        }
        return false;
    }

    private void printNodesForExportFile(Collection<FXNode> fxNodes, PrintWriter out) {
        for (FXNode fxNode : fxNodes) {
            FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxNode;
            out.println(String.format("%s%s%s%s%s%s%s", fxNodeGeneric.getBtnNode().getText(), "#", fxNodeGeneric.getLblEstimate().getText(), "#", String.valueOf(fxNodeGeneric.getPositionX()), "#", String.valueOf(fxNodeGeneric.getPositionY())));
        }
    }

    private void printLinksForExportFile(Set<FXEdge> fxEdgeSet, PrintWriter out) {
        for (FXEdge fxEdge : fxEdgeSet) {
            FXNodeGeneric fxNodeGenericSource = (FXNodeGeneric)fxEdge.getSource();
            FXNodeGeneric fxNodeGenericDestination = (FXNodeGeneric)fxEdge.getDestination();
            double weight = fxEdge.getWeight();
            out.println(String.format("%s%s%s%s%s", fxNodeGenericSource.getBtnNode().getText(), "#", fxNodeGenericDestination.getBtnNode().getText(), "#", String.valueOf(weight)));
        }
    }

    public void handlePlayStoreLink(ActionEvent actionEvent) {
        this.openURL("https://play.google.com/store/apps/dev?id=8629062604716991650");
    }

    public void handleMrJackLink(ActionEvent actionEvent) {
        this.openURL("https://github.com/biagiopietro");
    }

    public void handlePuffoCyanoLink(ActionEvent actionEvent) {
        this.openURL("https://github.com/PuffoCyano");
    }

    public void handleRefresh(ActionEvent actionEvent) {
        this.paneGraphView.getChildren().clear();
        this.paneGraphView.getChildren().add((Object)this.fxGraph);
        this.resizeFxGraph();
    }

    private void openURL(String url) {
        this.hostServices.showDocument(url);
    }

    public void handleLicense(ActionEvent actionEvent) {
        this.showLicense();
    }

    public void randomWeightValues() {
        Random random = new Random();
        Set<FXEdge> fxEdges = this.fxGraph.getModel().getEdges();
        int maxValueForRandomWeight = this.sharePreferencesHandler.getMaxValueForRandomWeight();
        int minValueForRandomWeight = this.sharePreferencesHandler.getMinValueForRandomWeight();
        if (fxEdges.size() != 0) {
            for (FXEdge fxEdge : fxEdges) {
                if (this.toggleGraphType.isSelected()) {
                    fxEdge.setWeight(random.nextInt(maxValueForRandomWeight - minValueForRandomWeight + 1) + minValueForRandomWeight);
                    continue;
                }
                double randomValue = random.nextInt(maxValueForRandomWeight - minValueForRandomWeight + 1) + minValueForRandomWeight;
                fxEdge.setWeight(randomValue);
                FXNode fxNodeSource = fxEdge.getSource();
                FXNode fxNodeDestination = fxEdge.getDestination();
                FXEdge otherwiseEdge = this.fxGraph.getModel().getEdge(fxNodeDestination, fxNodeSource);
                if (otherwiseEdge == null) continue;
                otherwiseEdge.setWeight(randomValue);
            }
        }
    }

    public void randomEstimateValues() {
        Random random = new Random();
        Collection<FXNode> fxNodes = this.fxGraph.getModel().getNodes();
        int maxValueForRandomEstimate = this.sharePreferencesHandler.getMaxValueForRandomEstimate();
        int minValueForRandomEstimate = this.sharePreferencesHandler.getMinValueForRandomEstimate();
        if (fxNodes.size() != 0) {
            for (FXNode fxNode : fxNodes) {
                FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxNode;
                fxNodeGeneric.getLblEstimate().setText("" + (double)(random.nextInt(maxValueForRandomEstimate - minValueForRandomEstimate + 1) + minValueForRandomEstimate));
            }
            this.refreshEstimateList();
        }
    }
}

