/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXTextArea;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import mcgraphresolver.bucket.License;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class LicenseController
implements Initializable {
    public Utils utils = new Utils();
    public SharePreferencesHandler sharePreferencesHandler;
    public List<License> licenseList;
    public VBox vBoxLicenses;
    private HostServices hostServices;
    private ResourceBundle resourceBundle;
    private Scene scene;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void setSharePreferencesHandles(SharePreferencesHandler sharePreferencesHandler) {
        this.sharePreferencesHandler = sharePreferencesHandler;
    }

    public void setHostServices(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    public void setLicenseList(List<License> licenseList) {
        this.licenseList = licenseList;
    }

    public void populateItems() {
        for (License license : this.licenseList) {
            HBox hBox = new HBox();
            hBox.setAlignment(Pos.CENTER);
            hBox.getStyleClass().add((Object)"card");
            Label lblLibName = new Label(license.getLibName());
            Hyperlink hyperLinkLibUrl = new Hyperlink(license.getUrlLib());
            hyperLinkLibUrl.setOnAction(e -> this.openURL(license.getUrlLib()));
            lblLibName.setMinWidth(500.0);
            lblLibName.setPadding(new Insets(2.0));
            lblLibName.setFont(Font.font((String)"Verdana", (double)20.0));
            lblLibName.setAlignment(Pos.CENTER);
            hyperLinkLibUrl.setMinWidth(500.0);
            hyperLinkLibUrl.setAlignment(Pos.CENTER);
            String libSummary = "";
            switch (license.getLicenseType()) {
                case APACHE20: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/files/apache2_license_summary")));
                    libSummary = Utils.loadTextFiles(reader);
                    break;
                }
                case MIT: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/files/mit_license_summary")));
                    libSummary = Utils.loadTextFiles(reader);
                    break;
                }
                case LGPL3: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/files/lgpl3_license_summary")));
                    libSummary = Utils.loadTextFiles(reader);
                }
            }
            JFXTextArea txtAreaLibLicense = new JFXTextArea(String.format("%s\n\n\n%s", license.getCopyright(), libSummary));
            txtAreaLibLicense.setMinWidth(500.0);
            txtAreaLibLicense.setMinHeight(200.0);
            txtAreaLibLicense.setStyle("-fx-padding: 0");
            txtAreaLibLicense.setEditable(false);
            txtAreaLibLicense.setWrapText(true);
            this.setAncor((Node)lblLibName);
            this.setAncor((Node)hyperLinkLibUrl);
            this.setAncor((Node)txtAreaLibLicense);
            this.vBoxLicenses.getChildren().addAll((Object[])new Node[]{lblLibName, hyperLinkLibUrl, txtAreaLibLicense});
        }
    }

    private void openURL(String url) {
        this.hostServices.showDocument(url);
    }

    public void setAncor(Node node) {
        AnchorPane.setBottomAnchor((Node)node, (Double)0.0);
        AnchorPane.setTopAnchor((Node)node, (Double)5.0);
        AnchorPane.setLeftAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)0.0);
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }
}

