/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXGraph;
import fxgraph.FXGraphSelectionTool;
import fxgraph.FXNode;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;

public class FXGraphKeyboardHandler {
    private FXGraphSelectionTool selectionTool;
    private FXGraph graph;

    public FXGraphKeyboardHandler(FXGraph aGraph) {
        this.graph = aGraph;
        this.selectionTool = this.graph.getFxGraphSelectionTool();
        this.graph.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case A: {
                        if (!event.isControlDown()) break;
                        FXGraphKeyboardHandler.this.selectionTool.resetSelection();
                        FXGraphKeyboardHandler.this.selectionTool.getCurrentSelection().addAll(FXGraphKeyboardHandler.this.graph.getModel().getNodes());
                        FXGraphKeyboardHandler.this.selectionTool.updateSelectionInScene();
                        break;
                    }
                    case DELETE: {
                        if (FXGraphKeyboardHandler.this.selectionTool.getCurrentSelection().isEmpty()) break;
                        FXGraphKeyboardHandler.this.graph.onRemoveMultipleNode();
                        FXGraphKeyboardHandler.this.selectionTool.resetSelection();
                        FXGraphKeyboardHandler.this.selectionTool.updateSelectionInScene();
                        break;
                    }
                    case LEFT: {
                        FXGraphKeyboardHandler.this.moveNodes(-1.0, 0.0);
                        break;
                    }
                    case RIGHT: {
                        FXGraphKeyboardHandler.this.moveNodes(1.0, 0.0);
                        break;
                    }
                    case UP: {
                        FXGraphKeyboardHandler.this.moveNodes(0.0, -1.0);
                        break;
                    }
                    case DOWN: {
                        FXGraphKeyboardHandler.this.moveNodes(0.0, 1.0);
                    }
                }
            }
        });
    }

    private void moveNodes(double movementX, double movementY) {
        for (FXNode fxNode : this.graph.getModel().getNodes()) {
            fxNode.translatePosition(movementX, movementY, this.graph.zoomHandler.currentZoomLevel);
        }
    }
}

