/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.SetOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class SetTest
extends TestCase {
    Set<Integer> s1;
    Set<Integer> s2;

    @Override
    public void setUp() {
        this.s1 = new HashSet<Integer>();
        this.s1.add(new Integer(1));
        this.s1.add(new Integer(2));
        this.s1.add(new Integer(3));
        this.s1.add(new Integer(4));
        this.s2 = new HashSet<Integer>();
        this.s2.add(new Integer(4));
        this.s2.add(new Integer(5));
        this.s2.add(new Integer(6));
    }

    public void testUnion() {
        Set<Integer> union = new SetOps<Integer>().union(this.s1, this.s2);
        SetTest.assertEquals(6, union.size());
        SetTest.assertEquals(4, this.s1.size());
        SetTest.assertEquals(3, this.s2.size());
        this.s1.remove(new Integer(1));
        SetTest.assertEquals(6, union.size());
        SetTest.assertEquals(3, this.s1.size());
        SetTest.assertEquals(3, this.s2.size());
    }

    public void testIntersection() {
        Set<Integer> intersection = new SetOps<Integer>().intersection(this.s1, this.s2);
        SetTest.assertEquals(1, intersection.size());
        SetTest.assertEquals(4, this.s1.size());
        SetTest.assertEquals(3, this.s2.size());
        this.s1.remove(new Integer(1));
        SetTest.assertEquals(1, intersection.size());
        SetTest.assertEquals(3, this.s1.size());
        SetTest.assertEquals(3, this.s2.size());
    }

    public void testDifference() {
        Set<Integer> difference = new SetOps<Integer>().difference(this.s1, this.s2);
        SetTest.assertEquals(3, difference.size());
        SetTest.assertTrue(difference.contains(new Integer(1)));
        SetTest.assertTrue(difference.contains(new Integer(2)));
        SetTest.assertTrue(difference.contains(new Integer(3)));
    }

    public void testDifference2() {
        HashSet<Integer> one = new HashSet<Integer>();
        HashSet<Integer> two = new HashSet<Integer>();
        one.add(new Integer(1));
        two.add(new Integer(1));
        Set difference = new SetOps<Integer>().difference(one, two);
        SetTest.assertTrue(difference.isEmpty());
    }

    public void testListRemove() {
        ArrayList<Integer> one = new ArrayList<Integer>();
        one.add(new Integer(1));
        SetTest.assertEquals(1, one.size());
        one.remove(0);
        SetTest.assertEquals(0, one.size());
    }
}

