/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.RandomVariable;
import aima.probability.Randomizer;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import aima.probability.reasoning.ParticleSet;
import aima.probability.reasoning.TransitionModel;
import aima.test.probabilitytest.MockRandomizer;
import junit.framework.TestCase;

public class ParticleFilterTest
extends TestCase {
    private HiddenMarkovModel rainman;
    private HiddenMarkovModel robot;
    ParticleSet particleSet;
    Randomizer randomizer;

    @Override
    public void setUp() {
        this.rainman = HMMFactory.createRainmanHMM();
        this.robot = HMMFactory.createRobotHMM();
        this.randomizer = new MockRandomizer(new double[]{0.1, 0.9});
        this.particleSet = new ParticleSet(this.rainman);
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("rain"));
        this.particleSet.add(new Particle("no_rain"));
    }

    public void testFilteringWithParticleSetsWorksForRainmanHmm() {
        MockRandomizer r = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet starting = this.rainman.prior().toParticleSet(this.rainman, r, 100);
        ParticleFilterTest.assertEquals(56, starting.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(44, starting.numberOfParticlesWithState("no_rain"));
        ParticleSet afterSeeingUmbrella = starting.filter("carries_umbrella", r);
        ParticleFilterTest.assertEquals(84, afterSeeingUmbrella.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(16, afterSeeingUmbrella.numberOfParticlesWithState("no_rain"));
        ParticleSet afterNotSeeingUmbrella = starting.filter("does_not_carry_umbrella", r);
        ParticleFilterTest.assertEquals(12, afterNotSeeingUmbrella.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(88, afterNotSeeingUmbrella.numberOfParticlesWithState("no_rain"));
    }

    public void testFilteringWithParticleSetsForRobotHmm() {
        MockRandomizer r = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet starting = this.robot.prior().toParticleSet(this.robot, r, 100);
        ParticleFilterTest.assertEquals(56, starting.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals(44, starting.numberOfParticlesWithState("closed"));
        ParticleSet afterStepOne = starting.filter("see_open", r);
        ParticleFilterTest.assertEquals(66, afterStepOne.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals(34, afterStepOne.numberOfParticlesWithState("closed"));
        ParticleSet afterStepTwo = starting.filter("push", "see_open", r);
        ParticleFilterTest.assertEquals(100, afterStepTwo.numberOfParticlesWithState("open"));
        ParticleFilterTest.assertEquals(0, afterStepTwo.numberOfParticlesWithState("closed"));
    }

    public void testRandomVariableConversionToParticleSet() {
        RandomVariable rv = this.rainman.prior();
        ParticleSet ps = rv.toParticleSet(this.rainman, this.randomizer, 10);
        ParticleFilterTest.assertEquals(5, ps.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(5, ps.numberOfParticlesWithState("no_rain"));
    }

    public void testParticleSetConversionToRandomVariable() {
        RandomVariable rv = this.particleSet.toRandomVariable();
        ParticleFilterTest.assertEquals(0.75, rv.getProbabilityOf("rain"));
        ParticleFilterTest.assertEquals(0.25, rv.getProbabilityOf("no_rain"));
    }

    public void testRoundTripConversion() {
        RandomVariable rv = this.particleSet.toRandomVariable();
        MockRandomizer r = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.9});
        ParticleSet ps2 = rv.toParticleSet(this.rainman, r, 10);
        ParticleFilterTest.assertEquals(8, ps2.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(2, ps2.numberOfParticlesWithState("no_rain"));
    }

    public void testTransitionModelGeneratesNewStateWhenGivenOldStateAndProbability() {
        TransitionModel tm = this.rainman.transitionModel();
        String oldState = "rain";
        String state1 = tm.getStateForProbability(oldState, this.randomizer.nextDouble());
        String state2 = tm.getStateForProbability(oldState, this.randomizer.nextDouble());
        ParticleFilterTest.assertEquals(state1, "rain");
        ParticleFilterTest.assertEquals(state2, "no_rain");
    }

    public void testParticleSetForPredictedStateGeneratedFromOldStateParticleSet() {
        MockRandomizer r = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet ps = this.rainman.prior().toParticleSet(this.rainman, r, 10);
        ParticleFilterTest.assertEquals(6, ps.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(4, ps.numberOfParticlesWithState("no_rain"));
        ParticleSet nps = ps.generateParticleSetForPredictedState(r);
        ParticleFilterTest.assertEquals(7, nps.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(3, nps.numberOfParticlesWithState("no_rain"));
    }

    public void testParticleSetForPerceptionUpdatedStateGeneratedFromPredictedStateParticleSetGivenPerception() {
        MockRandomizer r = new MockRandomizer(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9});
        ParticleSet starting = this.rainman.prior().toParticleSet(this.rainman, r, 10);
        ParticleSet predicted = starting.generateParticleSetForPredictedState(r);
        ParticleSet updatedWithPerceptionOfUmbrella = predicted.perceptionUpdate("carries_umbrella", r);
        ParticleFilterTest.assertEquals(9, updatedWithPerceptionOfUmbrella.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(1, updatedWithPerceptionOfUmbrella.numberOfParticlesWithState("no_rain"));
        ParticleSet updatedWithPerceptionOfNoUmbrella = predicted.perceptionUpdate("does_not_carry_umbrella", r);
        ParticleFilterTest.assertEquals(2, updatedWithPerceptionOfNoUmbrella.numberOfParticlesWithState("rain"));
        ParticleFilterTest.assertEquals(8, updatedWithPerceptionOfNoUmbrella.numberOfParticlesWithState("no_rain"));
    }
}

