/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolClassifier;
import java.util.Set;
import junit.framework.TestCase;

public class SymbolClassifierTest
extends TestCase {
    private SymbolClassifier classifier;
    private PEParser parser;

    @Override
    public void setUp() {
        this.classifier = new SymbolClassifier();
        this.parser = new PEParser();
    }

    public void testSimpleNegativeSymbol() {
        Sentence sentence = (Sentence)this.parser.parse("(NOT B)");
        Set<Symbol> neg = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> pos = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> pureNeg = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> purePos = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> pure = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> impure = this.classifier.getImpureSymbolsIn(sentence);
        Sentence b = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertEquals(1, neg.size());
        SymbolClassifierTest.assertTrue(neg.contains(b));
        SymbolClassifierTest.assertEquals(0, pos.size());
        SymbolClassifierTest.assertEquals(1, pureNeg.size());
        SymbolClassifierTest.assertTrue(pureNeg.contains(b));
        SymbolClassifierTest.assertEquals(0, purePos.size());
        SymbolClassifierTest.assertEquals(1, pure.size());
        SymbolClassifierTest.assertTrue(pure.contains(b));
        SymbolClassifierTest.assertEquals(0, impure.size());
    }

    public void testSimplePositiveSymbol() {
        Sentence sentence = (Sentence)this.parser.parse("B");
        Set<Symbol> neg = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> pos = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> pureNeg = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> purePos = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> pure = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> impure = this.classifier.getImpureSymbolsIn(sentence);
        SymbolClassifierTest.assertEquals(0, neg.size());
        SymbolClassifierTest.assertEquals(1, pos.size());
        Sentence b = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertTrue(pos.contains(b));
        SymbolClassifierTest.assertEquals(1, purePos.size());
        SymbolClassifierTest.assertTrue(purePos.contains(b));
        SymbolClassifierTest.assertEquals(0, pureNeg.size());
        SymbolClassifierTest.assertEquals(1, pure.size());
        SymbolClassifierTest.assertTrue(pure.contains(b));
        SymbolClassifierTest.assertEquals(0, impure.size());
    }

    public void testSingleSymbolPositiveAndNegative() {
        Sentence sentence = (Sentence)this.parser.parse("(B AND (NOT B))");
        Set<Symbol> neg = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> pos = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> pureNeg = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> purePos = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> pure = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> impure = this.classifier.getImpureSymbolsIn(sentence);
        Sentence b = (Sentence)this.parser.parse("B");
        SymbolClassifierTest.assertEquals(1, neg.size());
        SymbolClassifierTest.assertTrue(neg.contains(b));
        SymbolClassifierTest.assertEquals(1, pos.size());
        SymbolClassifierTest.assertTrue(pos.contains(b));
        SymbolClassifierTest.assertEquals(0, pureNeg.size());
        SymbolClassifierTest.assertEquals(0, purePos.size());
        SymbolClassifierTest.assertEquals(0, pure.size());
        SymbolClassifierTest.assertEquals(1, impure.size());
    }

    public void testAIMAExample() {
        Sentence sentence = (Sentence)this.parser.parse("(((A OR (NOT B)) AND ((NOT B) OR (NOT C))) AND (C OR A))");
        Set<Symbol> neg = this.classifier.getNegativeSymbolsIn(sentence);
        Set<Symbol> pos = this.classifier.getPositiveSymbolsIn(sentence);
        Set<Symbol> pureNeg = this.classifier.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> purePos = this.classifier.getPurePositiveSymbolsIn(sentence);
        Set<Symbol> pure = this.classifier.getPureSymbolsIn(sentence);
        Set<Symbol> impure = this.classifier.getImpureSymbolsIn(sentence);
        Sentence a = (Sentence)this.parser.parse("A");
        Sentence b = (Sentence)this.parser.parse("B");
        Sentence c = (Sentence)this.parser.parse("C");
        SymbolClassifierTest.assertEquals(2, neg.size());
        SymbolClassifierTest.assertTrue(neg.contains(b));
        SymbolClassifierTest.assertTrue(neg.contains(c));
        SymbolClassifierTest.assertEquals(2, pos.size());
        SymbolClassifierTest.assertTrue(pos.contains(a));
        SymbolClassifierTest.assertTrue(pos.contains(c));
        SymbolClassifierTest.assertEquals(1, pureNeg.size());
        SymbolClassifierTest.assertTrue(pureNeg.contains(b));
        SymbolClassifierTest.assertEquals(1, purePos.size());
        SymbolClassifierTest.assertTrue(purePos.contains(a));
        SymbolClassifierTest.assertEquals(2, pure.size());
        SymbolClassifierTest.assertTrue(pure.contains(a));
        SymbolClassifierTest.assertTrue(pure.contains(b));
        SymbolClassifierTest.assertEquals(1, impure.size());
        SymbolClassifierTest.assertTrue(impure.contains(c));
    }
}

