/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class ChainTest
extends TestCase {
    public void testIsEmpty() {
        Chain c = new Chain();
        ChainTest.assertTrue(c.isEmpty());
        c.addLiteral(new Literal(new Predicate("P", new ArrayList<Term>())));
        ChainTest.assertFalse(c.isEmpty());
        ArrayList<Literal> lits = new ArrayList<Literal>();
        lits.add(new Literal(new Predicate("P", new ArrayList<Term>())));
        c = new Chain(lits);
        ChainTest.assertFalse(c.isEmpty());
    }

    public void testContrapositives() {
        Literal p = new Literal(new Predicate("P", new ArrayList<Term>()));
        Literal notq = new Literal(new Predicate("Q", new ArrayList<Term>()), true);
        Literal notr = new Literal(new Predicate("R", new ArrayList<Term>()), true);
        Chain c = new Chain();
        List<Chain> conts = c.getContrapositives();
        ChainTest.assertEquals(0, conts.size());
        c.addLiteral(p);
        conts = c.getContrapositives();
        ChainTest.assertEquals(0, conts.size());
        c.addLiteral(notq);
        conts = c.getContrapositives();
        ChainTest.assertEquals(1, conts.size());
        ChainTest.assertEquals("<~Q(),P()>", conts.get(0).toString());
        c.addLiteral(notr);
        conts = c.getContrapositives();
        ChainTest.assertEquals(2, conts.size());
        ChainTest.assertEquals("<~Q(),P(),~R()>", conts.get(0).toString());
        ChainTest.assertEquals("<~R(),P(),~Q()>", conts.get(1).toString());
    }
}

