/*
 * Decompiled with CFR 0.152.
 */
package aima.search.map;

import aima.search.map.Map;
import aima.search.map.Point2D;
import aima.util.LabeledGraph;
import aima.util.Util;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class ExtendableMap
implements Map {
    private final LabeledGraph<String, Double> links = new LabeledGraph();
    private final Hashtable<String, Point2D> locationPositions = new Hashtable();

    public void clear() {
        this.links.clear();
        this.locationPositions.clear();
    }

    public void clearLinks() {
        this.links.clear();
    }

    @Override
    public List<String> getLocations() {
        return this.links.getVertexLabels();
    }

    public boolean isLocation(String str) {
        return this.links.isVertexLabel(str);
    }

    @Override
    public List<String> getLocationsLinkedTo(String fromLocation) {
        List<String> result = this.links.getSuccessors(fromLocation);
        Collections.sort(result);
        return result;
    }

    @Override
    public Double getDistance(String fromLocation, String toLocation) {
        return this.links.get(fromLocation, toLocation);
    }

    public void addUnidirectionalLink(String fromLocation, String toLocation, Double distance) {
        this.links.set(fromLocation, toLocation, distance);
    }

    public void addBidirectionalLink(String fromLocation, String toLocation, Double distance) {
        this.links.set(fromLocation, toLocation, distance);
        this.links.set(toLocation, fromLocation, distance);
    }

    @Override
    public String randomlyGenerateDestination() {
        return Util.selectRandomlyFromList(this.getLocations());
    }

    public void removeUnidirectionalLink(String fromLocation, String toLocation) {
        this.links.remove(fromLocation, toLocation);
    }

    public void removeBidirectionalLink(String fromLocation, String toLocation) {
        this.links.remove(fromLocation, toLocation);
        this.links.remove(toLocation, fromLocation);
    }

    public void setPosition(String loc, double x, double y) {
        this.locationPositions.put(loc, new Point2D(x, y));
    }

    public void setDistAndDirToRefLocation(String loc, double dist, int dir) {
        Point2D coords = new Point2D(-Math.sin((double)dir * Math.PI / 180.0) * dist, Math.cos((double)dir * Math.PI / 180.0) * dist);
        this.links.addVertex(loc);
        this.locationPositions.put(loc, coords);
    }

    @Override
    public Point2D getPosition(String loc) {
        return this.locationPositions.get(loc);
    }
}

