/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.EvaluationFunction;
import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.informed.SearchResult;
import java.util.ArrayList;
import java.util.List;

public class RecursiveBestFirstSearch
extends NodeExpander
implements Search {
    private final EvaluationFunction evaluationFunction;
    private static final String MAX_RECURSIVE_DEPTH = "maxRecursiveDepth";
    private static final String PATH_COST = "pathCost";
    private static final Double INFINITY = Double.MAX_VALUE;

    public RecursiveBestFirstSearch(EvaluationFunction ef) {
        this.evaluationFunction = ef;
    }

    @Override
    public List<String> search(Problem p) throws Exception {
        List<String> actions2 = new ArrayList<String>();
        this.clearInstrumentation();
        Node n = new Node(p.getInitialState());
        SearchResult sr = this.rbfs(p, n, this.evaluationFunction.getValue(p, n), INFINITY, 0);
        if (sr.getOutcome() == SearchResult.SearchOutcome.SOLUTION_FOUND) {
            Node s = sr.getSolution();
            actions2 = SearchUtils.actionsFromNodes(s.getPathFromRoot());
            this.setPathCost(s.getPathCost());
        }
        return actions2;
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(MAX_RECURSIVE_DEPTH, 0);
        this.metrics.set(PATH_COST, 0.0);
    }

    public void setMaxRecursiveDepth(int recursiveDepth) {
        int maxRdepth = this.metrics.getInt(MAX_RECURSIVE_DEPTH);
        if (recursiveDepth > maxRdepth) {
            this.metrics.set(MAX_RECURSIVE_DEPTH, recursiveDepth);
        }
    }

    public int getMaxRecursiveDepth() {
        return this.metrics.getInt(MAX_RECURSIVE_DEPTH);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double pathCost) {
        this.metrics.set(PATH_COST, pathCost);
    }

    private SearchResult rbfs(Problem p, Node n, Double fNode, Double fLimit, int recursiveDepth) {
        SearchResult sr;
        this.setMaxRecursiveDepth(recursiveDepth);
        if (p.isGoalState(n.getState())) {
            return new SearchResult(n, fLimit);
        }
        List<Node> successors = this.expandNode(n, p);
        if (0 == successors.size()) {
            return new SearchResult(null, INFINITY);
        }
        double[] f = new double[successors.size()];
        int size = successors.size();
        for (int s = 0; s < size; ++s) {
            f[s] = Math.max(this.evaluationFunction.getValue(p, successors.get(s)), fNode);
        }
        do {
            int bestIndex;
            if (f[bestIndex = this.getBestFValueIndex(f)] > fLimit) {
                return new SearchResult(null, f[bestIndex]);
            }
            int altIndex = this.getNextBestFValueIndex(f, bestIndex);
            sr = this.rbfs(p, successors.get(bestIndex), f[bestIndex], Math.min(fLimit, f[altIndex]), recursiveDepth + 1);
            f[bestIndex] = sr.getFCostLimit();
        } while (sr.getOutcome() != SearchResult.SearchOutcome.SOLUTION_FOUND);
        return sr;
    }

    private int getBestFValueIndex(double[] f) {
        int lidx = 0;
        Double lowestSoFar = INFINITY;
        for (int i = 0; i < f.length; ++i) {
            if (!(f[i] < lowestSoFar)) continue;
            lowestSoFar = f[i];
            lidx = i;
        }
        return lidx;
    }

    private int getNextBestFValueIndex(double[] f, int bestIndex) {
        int lidx = bestIndex;
        Double lowestSoFar = INFINITY;
        for (int i = 0; i < f.length; ++i) {
            if (i == bestIndex || !(f[i] < lowestSoFar)) continue;
            lowestSoFar = f[i];
            lidx = i;
        }
        return lidx;
    }
}

