/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.EvaluationFunction;
import aima.search.framework.Node;
import aima.search.framework.PrioritySearch;
import aima.search.framework.Problem;
import aima.search.framework.QueueSearch;
import java.util.Comparator;
import mcgraphresolver.aima_classes.informed.NodeStateInformed;
import mcgraphresolver.utils.SharePreferencesHandler;

public class BestFirstSearch
extends PrioritySearch {
    private final EvaluationFunction evaluationFunction;
    private SharePreferencesHandler sharePreferencesHandler;

    public BestFirstSearch(QueueSearch search, EvaluationFunction ef) {
        this.search = search;
        this.evaluationFunction = ef;
        this.sharePreferencesHandler = new SharePreferencesHandler();
    }

    @Override
    protected Comparator<Node> getComparator(final Problem p) {
        return new Comparator<Node>(){

            @Override
            public int compare(Node one, Node two) {
                Double f1 = BestFirstSearch.this.evaluationFunction.getValue(p, one);
                Double f2 = BestFirstSearch.this.evaluationFunction.getValue(p, two);
                if (BestFirstSearch.this.sharePreferencesHandler.isFringeOrderedByNodeLabelDesc() && f1.equals(f2) && one.getState() instanceof NodeStateInformed && two.getState() instanceof NodeStateInformed) {
                    String l1 = ((NodeStateInformed)one.getState()).getFxNodeGeneric().getBtnNode().getText();
                    String l2 = ((NodeStateInformed)two.getState()).getFxNodeGeneric().getBtnNode().getText();
                    return l1.compareTo(l2);
                }
                return f1.compareTo(f2);
            }
        };
    }
}

