/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb;

import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.kb.FOLKnowledgeBase;

public class FOLKnowledgeBaseFactory {
    public static FOLKnowledgeBase createKingsKnowledgeBase(InferenceProcedure infp) {
        FOLKnowledgeBase kb = new FOLKnowledgeBase(DomainFactory.kingsDomain(), infp);
        kb.tell("((King(x) AND Greedy(x)) => Evil(x))");
        kb.tell("King(John)");
        kb.tell("King(Richard)");
        kb.tell("Greedy(John)");
        return kb;
    }

    public static FOLKnowledgeBase createWeaponsKnowledgeBase(InferenceProcedure infp) {
        FOLKnowledgeBase kb = new FOLKnowledgeBase(DomainFactory.weaponsDomain(), infp);
        kb.tell("( (((American(x) AND Weapon(y)) AND Sells(x,y,z)) AND Hostile(z)) => Criminal(x))");
        kb.tell(" Owns(Nono, M1)");
        kb.tell(" Missile(M1)");
        kb.tell("((Missile(x) AND Owns(Nono,x)) => Sells(West,x,Nono))");
        kb.tell("(Missile(x) => Weapon(x))");
        kb.tell("(Enemy(x,America) => Hostile(x))");
        kb.tell("American(West)");
        kb.tell("Enemy(Nono,America)");
        return kb;
    }

    public static FOLKnowledgeBase createLovesAnimalKnowledgeBase(InferenceProcedure infp) {
        FOLKnowledgeBase kb = new FOLKnowledgeBase(DomainFactory.lovesAnimalDomain(), infp);
        kb.tell("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        kb.tell("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        kb.tell("FORALL x (Animal(x) => Loves(Jack, x))");
        kb.tell("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        kb.tell("Cat(Tuna)");
        kb.tell("FORALL x (Cat(x) => Animal(x))");
        return kb;
    }

    public static FOLKnowledgeBase createRingOfThievesKnowledgeBase(InferenceProcedure infp) {
        FOLKnowledgeBase kb = new FOLKnowledgeBase(DomainFactory.ringOfThievesDomain(), infp);
        kb.tell("(Skis(x) => NOT(Caught(x)))");
        kb.tell("(Caught(x) => NOT(Skis(x)))");
        kb.tell("((Parent(x,y) AND Caught(y)) => Skis(x))");
        kb.tell("(Skis(x) AND Friend(x,y) => Skis(y))");
        kb.tell("(Friend(x,y) => Friend(y,x))");
        kb.tell("Parent(Mike, Joe)");
        kb.tell("Parent(Janet,Joe)");
        kb.tell("Parent(Nancy,Mike)");
        kb.tell("Parent(Ernie,Janet)");
        kb.tell("Parent(Bert,Nancy)");
        kb.tell("Parent(Red,Ernie)");
        kb.tell("Friend(Red,Bert)");
        kb.tell("Friend(Drew,Nancy)");
        kb.tell("Caught(Mike)");
        kb.tell("Caught(Ernie)");
        return kb;
    }

    public static FOLKnowledgeBase createABCEqualityKnowledgeBase(InferenceProcedure infp, boolean includeEqualityAxioms) {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        FOLKnowledgeBase kb = new FOLKnowledgeBase(domain, infp);
        kb.tell("B = A");
        kb.tell("B = C");
        if (includeEqualityAxioms) {
            kb.tell("x = x");
            kb.tell("(x = y => y = x)");
            kb.tell("((x = y AND y = z) => x = z)");
        }
        return kb;
    }

    public static FOLKnowledgeBase createABCDEqualityAndSubstitutionKnowledgeBase(InferenceProcedure infp, boolean includeEqualityAxioms) {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addPredicate("P");
        domain.addFunction("F");
        FOLKnowledgeBase kb = new FOLKnowledgeBase(domain, infp);
        kb.tell("F(A) = B");
        kb.tell("F(B) = A");
        kb.tell("C = D");
        kb.tell("P(A)");
        kb.tell("P(C)");
        if (includeEqualityAxioms) {
            kb.tell("x = x");
            kb.tell("(x = y => y = x)");
            kb.tell("((x = y AND y = z) => x = z)");
            kb.tell("((x = y AND F(y) = z) => F(x) = z)");
            kb.tell("((x = y AND P(y)) => P(x))");
        }
        return kb;
    }
}

