/*
 * Decompiled with CFR 0.152.
 */
package aima.basic.vaccum;

import aima.basic.Agent;
import aima.basic.Environment;
import aima.basic.Percept;
import java.util.Hashtable;
import java.util.Random;

public class TrivialVaccumEnvironment
extends Environment {
    String location1 = "A";
    String location2 = "B";
    String defaultLocation = this.location1;
    Hashtable<String, String> status = new Hashtable();

    public TrivialVaccumEnvironment() {
        Random r = new Random();
        int i = r.nextInt(2);
        int j = r.nextInt(2);
        if (i == 0) {
            this.status.put(this.location1, "Clean");
        } else {
            this.status.put(this.location1, "Dirty");
        }
        if (j == 0) {
            this.status.put(this.location2, "Clean");
        } else {
            this.status.put(this.location2, "Dirty");
        }
    }

    public TrivialVaccumEnvironment(String loc1Status, String loc2Status) {
        this.status.put(this.location1, loc1Status);
        this.status.put(this.location2, loc2Status);
    }

    @Override
    public void executeAction(Agent a, String agentAction) {
        if (agentAction.equals("Right")) {
            this.setAgentLocation(a, this.location2);
            this.setAgentPerformance(a, this.getAgentperformance(a) - 1);
        } else if (agentAction.equals("Left")) {
            this.setAgentLocation(a, this.location1);
            this.setAgentPerformance(a, this.getAgentperformance(a) - 1);
        } else if (agentAction.equals("Suck")) {
            if (this.getLocationStatus(this.getAgentLocation(a)).equals("Dirty")) {
                this.setLocationStatus(this.getAgentLocation(a), "Clean");
                this.setAgentPerformance(a, this.getAgentperformance(a) + 10);
            }
        } else if (agentAction.equals("NoOP")) {
            a.die();
        }
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        Percept retval = new Percept();
        retval.setAttribute("location", anAgent.getAttribute("location"));
        retval.setAttribute("status", this.status.get(anAgent.getAttribute("location")));
        return retval;
    }

    @Override
    public void addAgent(Agent a) {
        this.addAgent(a, this.defaultLocation);
    }

    public void addAgent(Agent a, String location) {
        this.setAgentLocation(a, location);
        super.addAgent(a);
        this.setAgentPerformance(a, 0);
    }

    public String getLocation1Status() {
        return this.status.get(this.location1);
    }

    public String getLocation2Status() {
        return this.status.get(this.location2);
    }

    public String getLocationStatus(String location) {
        return this.status.get(location);
    }

    public Hashtable getStatus() {
        return this.status;
    }

    private void setAgentLocation(Agent a, String location) {
        a.setAttribute("location", location);
    }

    public String getAgentLocation(Agent a) {
        return (String)a.getAttribute("location");
    }

    private void setAgentPerformance(Agent a, int i) {
        a.setAttribute("performance", new Integer(i));
    }

    public int getAgentperformance(Agent a) {
        Integer i = (Integer)a.getAttribute("performance");
        return i;
    }

    private void setLocationStatus(String aLocation, String aStatus) {
        this.status.put(aLocation, aStatus);
    }
}

