/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSnackbar;
import fxgraph.FXGraph;
import fxgraph.FXNodeGeneric;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import mcgraphresolver.utils.Utils;

public class AddNewNodeController
implements Initializable {
    public BorderPane apAddNewNode;
    public VBox vbAddNewNode;
    public JFXButton btnAdd;
    public Label lblTitleToolbar;
    private FXGraph fxGraph;
    private FXNodeGeneric.nodeType nodeType;
    @FXML
    public Label lblEstimate;
    @FXML
    public TextField txtLabel;
    @FXML
    public TextField txtEstimate;
    public Utils utils = new Utils();
    @FXML
    public Label lblInsertEstimateValueNotice;
    public FXNodeGeneric fxNodeGenericToAdd;
    public JFXSnackbar snackbar;
    private ResourceBundle resourceBundle;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        this.snackbar = new JFXSnackbar((Pane)this.vbAddNewNode);
        this.lblInsertEstimateValueNotice.setText(String.format(this.resourceBundle.getString("text_insertEstimateValueNotice"), 0.0, 999999.99));
        this.txtLabel.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("[aA-zZ '0-9]*$") || newValue.length() > 20) {
                this.txtLabel.setText(oldValue);
            }
        });
        this.txtEstimate.setText("0.0");
        this.txtEstimate.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("\\d{0,6}([\\.]\\d{0,2})?")) {
                this.txtEstimate.setText(oldValue);
            }
        });
    }

    public void setFxGraph(FXGraph fxGraph) {
        this.fxGraph = fxGraph;
    }

    public void populateItems() {
        this.btnAdd.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]), () -> this.btnAdd.fire());
        this.lblTitleToolbar.setText(String.format(this.resourceBundle.getString("text_addNewNode"), FXNodeGeneric.getNodeTypeString(this.nodeType, this.resourceBundle).toUpperCase()));
    }

    public void setTypeNode(FXNodeGeneric.nodeType nodeType2) {
        this.nodeType = nodeType2;
    }

    public FXNodeGeneric getFXNodeGenericToAdd() {
        return this.fxNodeGenericToAdd;
    }

    @FXML
    private void handleSaveAction(ActionEvent event) {
        if (this.validate()) {
            String labelVBoxNodeToAdd = this.txtLabel.getText();
            double estimateVBoxNodeToAdd = Double.parseDouble(this.txtEstimate.getText());
            this.fxNodeGenericToAdd = new FXNodeGeneric(labelVBoxNodeToAdd, estimateVBoxNodeToAdd, this.fxGraph);
            Node source = (Node)event.getSource();
            Stage stage = (Stage)source.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    public boolean validate() {
        if (this.txtLabel.getText().isEmpty()) {
            this.snackbar.show(this.resourceBundle.getString("text_field_label_empty"), 2000L);
            return false;
        }
        if (this.txtEstimate.getText().isEmpty()) {
            this.snackbar.show(this.resourceBundle.getString("text_field_estimate_empty"), 2000L);
            return false;
        }
        if (this.fxGraph.getModel().exists(this.txtLabel.getText())) {
            this.snackbar.show(this.resourceBundle.getString("text_node_already_exists"), 2000L);
            return false;
        }
        return true;
    }
}

