/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXEdge;
import fxgraph.FXGraph;
import fxgraph.OnSelectionMode;
import java.util.ArrayList;
import javafx.scene.Node;

public class FXNode
implements OnSelectionMode {
    Node wrappedNode;
    FXGraph owner;
    double positionX;
    double positionY;
    private ArrayList<FXEdge> neighborhood = new ArrayList();

    public FXNode(FXGraph aOwner, Node aNode) {
        this.wrappedNode = aNode;
        this.owner = aOwner;
        aNode.setUserData((Object)this);
    }

    public FXNode(FXGraph aOwner) {
        this.owner = aOwner;
    }

    public FXNode() {
    }

    public void setOwner(FXGraph aOwner) {
        this.owner = aOwner;
    }

    public void setNode(Node aNode) {
        this.wrappedNode = aNode;
        aNode.setUserData((Object)this);
    }

    public void setPosition(double aPositionX, double aPositionY) {
        this.wrappedNode.relocate(aPositionX, aPositionY);
        this.positionX = aPositionX;
        this.positionY = aPositionY;
        this.owner.updateEdgeNodesFor(this);
    }

    public double getPositionX() {
        return this.positionX;
    }

    public double getPositionY() {
        return this.positionY;
    }

    public void addNeighbor(FXEdge edge) {
        if (this.neighborhood.contains(edge)) {
            return;
        }
        this.neighborhood.add(edge);
    }

    public ArrayList<FXEdge> getNeighborhood() {
        return this.neighborhood;
    }

    public void setNeighborhood(ArrayList<FXEdge> neighborhood) {
        this.neighborhood = neighborhood;
    }

    public void translatePosition(double aMovementX, double aMovementY, double aZoomLevel) {
        this.wrappedNode.setLayoutX(this.wrappedNode.getLayoutX() + aMovementX);
        this.wrappedNode.setLayoutY(this.wrappedNode.getLayoutY() + aMovementY);
        this.positionX += aMovementX / aZoomLevel;
        this.positionY += aMovementY / aZoomLevel;
        this.owner.updateEdgeNodesFor(this);
    }

    public void setZoomLevel(double aZoomLevel) {
        this.wrappedNode.setLayoutX(this.positionX * aZoomLevel);
        this.wrappedNode.setLayoutY(this.positionY * aZoomLevel);
        this.wrappedNode.setScaleX(aZoomLevel);
        this.wrappedNode.setScaleY(aZoomLevel);
        this.owner.updateEdgeNodesFor(this, aZoomLevel);
    }

    public Node getWrappedNode() {
        return this.wrappedNode;
    }

    public void setWrappedNode(Node wrappedNode) {
        this.wrappedNode = wrappedNode;
    }

    @Override
    public void onSelect() {
    }

    @Override
    public void onDeselect() {
    }
}

