/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.reasoning.HMMAgent;
import aima.probability.reasoning.HMMFactory;
import junit.framework.TestCase;

public class HMMAgentTest
extends TestCase {
    private static final double TOLERANCE = 0.001;
    private HMMAgent robot;
    private HMMAgent rainman;

    @Override
    public void setUp() {
        this.robot = new HMMAgent(HMMFactory.createRobotHMM());
        this.rainman = new HMMAgent(HMMFactory.createRainmanHMM());
    }

    public void testRobotInitialization() {
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("closed"));
    }

    public void testRobotHMMPredictionAndMeasurementUpdateStepsModifyBeliefCorrectly() {
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("closed"));
        this.robot.act("do_nothing");
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals(0.5, this.robot.belief().getProbabilityOf("closed"));
        this.robot.perceive("see_open");
        HMMAgentTest.assertEquals(0.75, this.robot.belief().getProbabilityOf("open"), 0.001);
        HMMAgentTest.assertEquals(0.25, this.robot.belief().getProbabilityOf("closed"), 0.001);
        this.robot.act("push");
        HMMAgentTest.assertEquals(0.95, this.robot.belief().getProbabilityOf("open"));
        HMMAgentTest.assertEquals(0.05, this.robot.belief().getProbabilityOf("closed"));
        this.robot.perceive("see_open");
        HMMAgentTest.assertEquals(0.983, this.robot.belief().getProbabilityOf("open"), 0.001);
        HMMAgentTest.assertEquals(0.017, this.robot.belief().getProbabilityOf("closed"), 0.001);
    }

    public void testRainmanInitialization() {
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("no_rain"));
    }

    public void testRainmanHMMPredictionAndMeasurementUpdateStepsModifyBeliefCorrectly() {
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("no_rain"));
        this.rainman.waitWithoutActing();
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("rain"));
        HMMAgentTest.assertEquals(0.5, this.rainman.belief().getProbabilityOf("no_rain"));
        this.rainman.perceive("carries_umbrella");
        HMMAgentTest.assertEquals(0.818, this.rainman.belief().getProbabilityOf("rain"), 0.001);
        HMMAgentTest.assertEquals(0.182, this.rainman.belief().getProbabilityOf("no_rain"), 0.001);
        this.rainman.waitWithoutActing();
        HMMAgentTest.assertEquals(0.627, this.rainman.belief().getProbabilityOf("rain"), 0.001);
        HMMAgentTest.assertEquals(0.373, this.rainman.belief().getProbabilityOf("no_rain"), 0.001);
        this.rainman.perceive("carries_umbrella");
        HMMAgentTest.assertEquals(0.883, this.rainman.belief().getProbabilityOf("rain"), 0.001);
        HMMAgentTest.assertEquals(0.117, this.rainman.belief().getProbabilityOf("no_rain"), 0.001);
    }
}

