/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import java.util.List;

public class HillClimbingSearch
extends NodeExpander
implements Search {
    private SearchOutcome outcome = SearchOutcome.FAILURE;
    private Object lastState = null;

    @Override
    public List search(Problem p) throws Exception {
        this.clearInstrumentation();
        this.outcome = SearchOutcome.FAILURE;
        this.lastState = null;
        Node current = new Node(p.getInitialState());
        Node neighbor = null;
        while (true) {
            List<Node> children;
            if ((neighbor = this.getHighestValuedNodeFrom(children = this.expandNode(current, p), p)) == null || this.getValue(p, neighbor) <= this.getValue(p, current)) {
                if (p.isGoalState(current.getState())) {
                    this.outcome = SearchOutcome.SOLUTION_FOUND;
                }
                this.lastState = current.getState();
                return SearchUtils.actionsFromNodes(current.getPathFromRoot());
            }
            current = neighbor;
        }
    }

    public SearchOutcome getOutcome() {
        return this.outcome;
    }

    public Object getLastSearchState() {
        return this.lastState;
    }

    private Node getHighestValuedNodeFrom(List children, Problem p) {
        double highestValue = Double.NEGATIVE_INFINITY;
        Node nodeWithHighestValue = null;
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            double value = this.getValue(p, child);
            if (!(value > highestValue)) continue;
            highestValue = value;
            nodeWithHighestValue = child;
        }
        return nodeWithHighestValue;
    }

    private double getValue(Problem p, Node n) {
        return -1.0 * this.getHeuristic(p, n);
    }

    private double getHeuristic(Problem p, Node aNode) {
        return p.getHeuristicFunction().getHeuristicValue(aNode.getState());
    }

    public static enum SearchOutcome {
        FAILURE,
        SOLUTION_FOUND;

    }
}

