/*
 * Decompiled with CFR 0.152.
 */
package aima.search.csp;

import aima.search.csp.CSP;
import aima.search.csp.Constraint;
import aima.search.csp.Domain;
import aima.search.csp.MapColoringConstraint;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MapCSP
extends CSP {
    public static String WA = "WA";
    public static String NT = "NT";
    public static String SA = "SA";
    public static String Q = "Q";
    public static String NSW = "NSW";
    public static String V = "V";
    public static String T = "T";
    public static String RED = "RED";
    public static String BLUE = "BLUE";
    public static String GREEN = "GREEN";

    private MapCSP(List<String> variables, Constraint constraints) {
        super(variables, constraints);
    }

    public static CSP getMap() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(WA);
        variables.add(NT);
        variables.add(SA);
        variables.add(Q);
        variables.add(NSW);
        variables.add(V);
        variables.add(T);
        ArrayList<String> colors = new ArrayList<String>();
        colors.add(RED);
        colors.add(BLUE);
        colors.add(GREEN);
        Domain domains = new Domain(variables);
        for (int i = 0; i < variables.size(); ++i) {
            String variable = (String)variables.get(i);
            domains.addToDomain(variable, colors);
        }
        Hashtable<String, List<String>> neighbors = new Hashtable<String, List<String>>();
        MapCSP.addToNeighbors(neighbors, T);
        MapCSP.addToNeighbors(neighbors, WA, NT, SA);
        MapCSP.addToNeighbors(neighbors, NT, WA, SA, Q);
        MapCSP.addToNeighbors(neighbors, SA, WA, NT, Q, NSW, V);
        MapCSP.addToNeighbors(neighbors, Q, NT, SA, NSW);
        MapCSP.addToNeighbors(neighbors, NSW, SA, Q, V);
        MapCSP.addToNeighbors(neighbors, V, SA, NSW);
        MapColoringConstraint mapConstraints = new MapColoringConstraint(neighbors);
        return new CSP(variables, mapConstraints, domains);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose) {
        ArrayList l = new ArrayList();
        neighbors.put(whose, l);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose, String one) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(one);
        neighbors.put(whose, l);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose, String one, String two) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(one);
        l.add(two);
        neighbors.put(whose, l);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose, String one, String two, String three) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(one);
        l.add(two);
        l.add(three);
        neighbors.put(whose, l);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose, String one, String two, String three, String four) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(one);
        l.add(two);
        l.add(three);
        l.add(four);
        neighbors.put(whose, l);
    }

    public static void addToNeighbors(Hashtable<String, List<String>> neighbors, String whose, String one, String two, String three, String four, String five) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(one);
        l.add(two);
        l.add(three);
        l.add(four);
        l.add(five);
        neighbors.put(whose, l);
    }
}

