/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.DataSetSpecification;
import aima.learning.framework.Example;
import aima.util.Util;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataSet {
    public List<Example> examples;
    public DataSetSpecification specification;

    protected DataSet() {
    }

    public DataSet(DataSetSpecification spec) {
        this.examples = new LinkedList<Example>();
        this.specification = spec;
    }

    public void add(Example e) {
        this.examples.add(e);
    }

    public int size() {
        return this.examples.size();
    }

    public Example getExample(int number) {
        return this.examples.get(number);
    }

    public DataSet removeExample(Example e) {
        DataSet ds = new DataSet(this.specification);
        for (Example eg : this.examples) {
            if (e.equals(eg)) continue;
            ds.add(eg);
        }
        return ds;
    }

    public double getInformationFor() {
        String attributeName = this.specification.getTarget();
        Hashtable<String, Integer> counts = new Hashtable<String, Integer>();
        for (Example e : this.examples) {
            String val = e.getAttributeValueAsString(attributeName);
            if (counts.containsKey(val)) {
                counts.put(val, (Integer)counts.get(val) + 1);
                continue;
            }
            counts.put(val, 1);
        }
        double totalTargetAttributeCount = 0.0;
        double[] data = new double[counts.keySet().size()];
        Iterator iter = counts.values().iterator();
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((Integer)iter.next()).intValue();
        }
        data = Util.normalize(data);
        return Util.information(data);
    }

    public Hashtable<String, DataSet> splitByAttribute(String attributeName) {
        Hashtable<String, DataSet> results = new Hashtable<String, DataSet>();
        for (Example e : this.examples) {
            String val = e.getAttributeValueAsString(attributeName);
            if (results.containsKey(val)) {
                results.get(val).add(e);
                continue;
            }
            DataSet ds = new DataSet(this.specification);
            ds.add(e);
            results.put(val, ds);
        }
        return results;
    }

    public double calculateGainFor(String parameterName) {
        Hashtable<String, DataSet> hash = this.splitByAttribute(parameterName);
        double totalSize = this.examples.size();
        double remainder = 0.0;
        for (String parameterValue : hash.keySet()) {
            double reducedDataSetSize = hash.get((Object)parameterValue).examples.size();
            remainder += reducedDataSetSize / totalSize * hash.get(parameterValue).getInformationFor();
        }
        return this.getInformationFor() - remainder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet other = (DataSet)o;
        return this.examples.equals(other.examples);
    }

    public int hashCode() {
        return 0;
    }

    public Iterator<Example> iterator() {
        return this.examples.iterator();
    }

    public DataSet copy() {
        DataSet ds = new DataSet(this.specification);
        for (Example e : this.examples) {
            ds.add(e);
        }
        return ds;
    }

    public List<String> getAttributeNames() {
        return this.specification.getAttributeNames();
    }

    public String getTargetAttributeName() {
        return this.specification.getTarget();
    }

    public DataSet emptyDataSet() {
        return new DataSet(this.specification);
    }

    public void setSpecification(DataSetSpecification specification) {
        this.specification = specification;
    }

    public List<String> getPossibleAttributeValues(String attributeName) {
        return this.specification.getPossibleAttributeValues(attributeName);
    }

    public DataSet matchingDataSet(String attributeName, String attributeValue) {
        DataSet ds = new DataSet(this.specification);
        for (Example e : this.examples) {
            if (!e.getAttributeValueAsString(attributeName).equals(attributeValue)) continue;
            ds.add(e);
        }
        return ds;
    }

    public List<String> getNonTargetAttributes() {
        return Util.removeFrom(this.getAttributeNames(), this.getTargetAttributeName());
    }
}

