/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import java.util.Set;
import junit.framework.TestCase;

public class CNFClauseGathererTest
extends TestCase {
    private CNFClauseGatherer gatherer;
    private PEParser parser;

    @Override
    public void setUp() {
        this.parser = new PEParser();
        this.gatherer = new CNFClauseGatherer();
    }

    public void testSymbol() {
        Sentence simple = (Sentence)this.parser.parse("A");
        Sentence a = (Sentence)this.parser.parse("A");
        Set<Sentence> clauses = this.gatherer.getClausesFrom(simple);
        CNFClauseGathererTest.assertNotNull(clauses);
        CNFClauseGathererTest.assertEquals(1, clauses.size());
        CNFClauseGathererTest.assertTrue(clauses.contains(a));
    }

    public void testNotSentence() {
        Sentence simple = (Sentence)this.parser.parse("(NOT A)");
        Sentence a = (Sentence)this.parser.parse("(NOT A)");
        Set<Sentence> clauses = this.gatherer.getClausesFrom(simple);
        CNFClauseGathererTest.assertNotNull(clauses);
        CNFClauseGathererTest.assertEquals(1, clauses.size());
        CNFClauseGathererTest.assertTrue(clauses.contains(a));
    }

    public void testSimpleAndClause() {
        Sentence simple = (Sentence)this.parser.parse("(A AND B)");
        Sentence a = (Sentence)this.parser.parse("A");
        Sentence b = (Sentence)this.parser.parse("B");
        Set<Sentence> clauses = this.gatherer.getClausesFrom(simple);
        CNFClauseGathererTest.assertEquals(2, clauses.size());
        CNFClauseGathererTest.assertTrue(clauses.contains(a));
        CNFClauseGathererTest.assertTrue(clauses.contains(b));
    }

    public void testMultiAndClause() {
        Sentence simple = (Sentence)this.parser.parse("((A AND B) AND C)");
        Set<Sentence> clauses = this.gatherer.getClausesFrom(simple);
        CNFClauseGathererTest.assertEquals(3, clauses.size());
        Sentence a = (Sentence)this.parser.parse("A");
        Sentence b = (Sentence)this.parser.parse("B");
        Sentence c = (Sentence)this.parser.parse("C");
        CNFClauseGathererTest.assertTrue(clauses.contains(a));
        CNFClauseGathererTest.assertTrue(clauses.contains(b));
        CNFClauseGathererTest.assertTrue(clauses.contains(c));
    }

    public void testMultiAndClause2() {
        Sentence simple = (Sentence)this.parser.parse("(A AND (B AND C))");
        Set<Sentence> clauses = this.gatherer.getClausesFrom(simple);
        CNFClauseGathererTest.assertEquals(3, clauses.size());
        Sentence a = (Sentence)this.parser.parse("A");
        Sentence b = (Sentence)this.parser.parse("B");
        Sentence c = (Sentence)this.parser.parse("C");
        CNFClauseGathererTest.assertTrue(clauses.contains(a));
        CNFClauseGathererTest.assertTrue(clauses.contains(b));
        CNFClauseGathererTest.assertTrue(clauses.contains(c));
    }

    public void testAimaExample() {
        Sentence aimaEg = (Sentence)this.parser.parse("( B11 <=> (P12 OR P21))");
        CNFTransformer transformer = new CNFTransformer();
        Sentence transformed = transformer.transform(aimaEg);
        Set<Sentence> clauses = this.gatherer.getClausesFrom(transformed);
        Sentence clause1 = (Sentence)this.parser.parse("( B11 OR  ( NOT P12 )  )");
        Sentence clause2 = (Sentence)this.parser.parse("( B11 OR  ( NOT P21 )  )");
        Sentence clause3 = (Sentence)this.parser.parse("(  ( NOT B11 )  OR  ( P12 OR P21 ) )");
        CNFClauseGathererTest.assertEquals(3, clauses.size());
        CNFClauseGathererTest.assertTrue(clauses.contains(clause1));
        CNFClauseGathererTest.assertTrue(clauses.contains(clause2));
        CNFClauseGathererTest.assertTrue(clauses.contains(clause3));
    }
}

