/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.LinkedHashMap;
import junit.framework.TestCase;

public class FOLSubstTest
extends TestCase {
    private FOLParser parser;
    private SubstVisitor sv;

    @Override
    public void setUp() {
        this.parser = new FOLParser(DomainFactory.crusadesDomain());
        this.sv = new SubstVisitor();
    }

    public void testSubstSingleVariableSucceedsWithPredicate() {
        Sentence beforeSubst = this.parser.parse("King(x)");
        Sentence expectedAfterSubst = this.parser.parse(" King(John) ");
        Sentence expectedAfterSubstCopy = expectedAfterSubst.copy();
        FOLSubstTest.assertEquals(expectedAfterSubst, expectedAfterSubstCopy);
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(beforeSubst, this.parser.parse("King(x)"));
    }

    public void testSubstSingleVariableFailsWithPredicate() {
        Sentence beforeSubst = this.parser.parse("King(x)");
        Sentence expectedAfterSubst = this.parser.parse(" King(x) ");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("y"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(beforeSubst, this.parser.parse("King(x)"));
    }

    public void testMultipleVariableSubstitutionWithPredicate() {
        Sentence beforeSubst = this.parser.parse("King(x,y)");
        Sentence expectedAfterSubst = this.parser.parse(" King(John ,England) ");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        p.put(new Variable("y"), new Constant("England"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(beforeSubst, this.parser.parse("King(x,y)"));
    }

    public void testMultipleVariablePartiallySucceedsWithPredicate() {
        Sentence beforeSubst = this.parser.parse("King(x,y)");
        Sentence expectedAfterSubst = this.parser.parse(" King(John ,y) ");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        p.put(new Variable("z"), new Constant("England"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(beforeSubst, this.parser.parse("King(x,y)"));
    }

    public void testSubstSingleVariableSucceedsWithTermEquality() {
        Sentence beforeSubst = this.parser.parse("BrotherOf(x) = EnemyOf(y)");
        Sentence expectedAfterSubst = this.parser.parse("BrotherOf(John) = EnemyOf(Saladin)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        p.put(new Variable("y"), new Constant("Saladin"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(beforeSubst, this.parser.parse("BrotherOf(x) = EnemyOf(y)"));
    }

    public void testSubstSingleVariableSucceedsWithTermEquality2() {
        Sentence beforeSubst = this.parser.parse("BrotherOf(John) = x)");
        Sentence expectedAfterSubst = this.parser.parse("BrotherOf(John) = Richard");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("Richard"));
        p.put(new Variable("y"), new Constant("Saladin"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("BrotherOf(John) = x)"), beforeSubst);
    }

    public void testSubstWithUniversalQuantifierAndSngleVariable() {
        Sentence beforeSubst = this.parser.parse("FORALL x King(x))");
        Sentence expectedAfterSubst = this.parser.parse("King(John)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("FORALL x King(x))"), beforeSubst);
    }

    public void testSubstWithUniversalQuantifierAndZeroVariablesMatched() {
        Sentence beforeSubst = this.parser.parse("FORALL x King(x))");
        Sentence expectedAfterSubst = this.parser.parse("FORALL x King(x)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("y"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("FORALL x King(x))"), beforeSubst);
    }

    public void testSubstWithUniversalQuantifierAndOneOfTwoVariablesMatched() {
        Sentence beforeSubst = this.parser.parse("FORALL x,y King(x,y))");
        Sentence expectedAfterSubst = this.parser.parse("FORALL x King(x,John)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("y"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("FORALL x,y King(x,y))"), beforeSubst);
    }

    public void testSubstWithExistentialQuantifierAndSngleVariable() {
        Sentence beforeSubst = this.parser.parse("EXISTS x King(x))");
        Sentence expectedAfterSubst = this.parser.parse("King(John)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("EXISTS x King(x)"), beforeSubst);
    }

    public void testSubstWithNOTSentenceAndSngleVariable() {
        Sentence beforeSubst = this.parser.parse("NOT King(x))");
        Sentence expectedAfterSubst = this.parser.parse("NOT King(John)");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("NOT King(x))"), beforeSubst);
    }

    public void testConnectiveANDSentenceAndSngleVariable() {
        Sentence beforeSubst = this.parser.parse("EXISTS x ( King(x) AND BrotherOf(x) = EnemyOf(y) )");
        Sentence expectedAfterSubst = this.parser.parse("( King(John) AND BrotherOf(John) = EnemyOf(Saladin) )");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        p.put(new Variable("y"), new Constant("Saladin"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("EXISTS x ( King(x) AND BrotherOf(x) = EnemyOf(y) )"), beforeSubst);
    }

    public void testParanthisedSingleVariable() {
        Sentence beforeSubst = this.parser.parse("((( King(x))))");
        Sentence expectedAfterSubst = this.parser.parse("King(John) ");
        LinkedHashMap<Variable, Term> p = new LinkedHashMap<Variable, Term>();
        p.put(new Variable("x"), new Constant("John"));
        Sentence afterSubst = this.sv.subst(p, beforeSubst);
        FOLSubstTest.assertEquals(expectedAfterSubst, afterSubst);
        FOLSubstTest.assertEquals(this.parser.parse("((( King(x))))"), beforeSubst);
    }
}

