/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.otter.defaultimpl.DefaultClauseSimplifier;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.test.logictest.foltest.CommonFOLInferenceProcedureTests;
import java.util.ArrayList;
import junit.framework.Assert;

public class FOLOTTERLikeTheoremProverTest
extends CommonFOLInferenceProcedureTests {
    public void testDefaultClauseSimplifier() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("ZERO");
        domain.addConstant("ONE");
        domain.addPredicate("P");
        domain.addFunction("Plus");
        domain.addFunction("Power");
        FOLParser parser = new FOLParser(domain);
        ArrayList<TermEquality> rewrites = new ArrayList<TermEquality>();
        rewrites.add((TermEquality)parser.parse("Plus(x, ZERO) = x"));
        rewrites.add((TermEquality)parser.parse("Plus(ZERO, x) = x"));
        rewrites.add((TermEquality)parser.parse("Power(x, ONE) = x"));
        rewrites.add((TermEquality)parser.parse("Power(x, ZERO) = ONE"));
        DefaultClauseSimplifier simplifier = new DefaultClauseSimplifier(rewrites);
        Sentence s1 = parser.parse("((P(Plus(y,ZERO),Plus(ZERO,y)) OR P(Power(y, ONE),Power(y,ZERO))) OR P(Power(y,ZERO),Plus(y,ZERO)))");
        CNFConverter cnfConverter = new CNFConverter(parser);
        CNF cnf = cnfConverter.convertToCNF(s1);
        FOLOTTERLikeTheoremProverTest.assertEquals(1, cnf.getNumberOfClauses());
        Clause simplified = simplifier.simplify(cnf.getConjunctionOfClauses().get(0));
        FOLOTTERLikeTheoremProverTest.assertEquals("[P(y,y), P(y,ONE), P(ONE,y)]", simplified.toString());
    }

    public void testExhaustsSearchSpace() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("alternate");
        domain.addPredicate("bar");
        domain.addPredicate("fri_sat");
        domain.addPredicate("hungry");
        domain.addPredicate("patrons");
        domain.addPredicate("price");
        domain.addPredicate("raining");
        domain.addPredicate("reservation");
        domain.addPredicate("type");
        domain.addPredicate("wait_estimate");
        domain.addPredicate("will_wait");
        domain.addConstant("Some");
        domain.addConstant("Full");
        domain.addConstant("French");
        domain.addConstant("Thai");
        domain.addConstant("Burger");
        domain.addConstant("$");
        domain.addConstant("_30_60");
        domain.addConstant("X0");
        FOLParser parser = new FOLParser(domain);
        String c1 = "patrons(v,Some)";
        String c2 = "patrons(v,Full) AND (hungry(v) AND type(v,French))";
        String c3 = "patrons(v,Full) AND (hungry(v) AND (type(v,Thai) AND fri_sat(v)))";
        String c4 = "patrons(v,Full) AND (hungry(v) AND type(v,Burger))";
        String sh = "FORALL v (will_wait(v) <=> (" + c1 + " OR (" + c2 + " OR (" + c3 + " OR (" + c4 + ")))))";
        Sentence hypothesis = parser.parse(sh);
        Sentence desc = parser.parse("(((((((((alternate(X0) AND NOT(bar(X0))) AND NOT(fri_sat(X0))) AND hungry(X0)) AND patrons(X0,Full)) AND price(X0,$)) AND NOT(raining(X0))) AND NOT(reservation(X0))) AND type(X0,Thai)) AND wait_estimate(X0,_30_60))");
        Sentence classification = parser.parse("will_wait(X0)");
        FOLKnowledgeBase kb = new FOLKnowledgeBase(domain, new FOLOTTERLikeTheoremProver(false));
        kb.tell(hypothesis);
        kb.tell(desc);
        InferenceResult ir = kb.ask(classification);
        Assert.assertFalse(ir.isTrue());
        Assert.assertTrue(ir.isPossiblyFalse());
        Assert.assertFalse(ir.isUnknownDueToTimeout());
        Assert.assertFalse(ir.isPartialResultDueToTimeout());
        Assert.assertEquals(0, ir.getProofs().size());
    }

    public void testDefiniteClauseKBKingsQueryCriminalXFalse() {
        this.testDefiniteClauseKBKingsQueryCriminalXFalse(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryRichardEvilFalse() {
        this.testDefiniteClauseKBKingsQueryRichardEvilFalse(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryJohnEvilSucceeds() {
        this.testDefiniteClauseKBKingsQueryJohnEvilSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds() {
        this.testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds() {
        this.testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds() {
        this.testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew() {
        this.testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew(new FOLOTTERLikeTheoremProver(2000L, false));
    }

    public void testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds() {
        this.testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds() {
        this.testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse() {
        this.testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(new FOLOTTERLikeTheoremProver(false), true);
    }

    public void testEqualityAxiomsKBabcAEqualsCSucceeds() {
        this.testEqualityAxiomsKBabcAEqualsCSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds() {
        this.testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdPDSucceeds() {
        this.xtestEqualityAndSubstitutionAxiomsKBabcdPDSucceeds(new FOLOTTERLikeTheoremProver(false));
    }

    public void testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds() {
        this.testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds(new FOLOTTERLikeTheoremProver(false), false);
    }

    public void testEqualityNoAxiomsKBabcAEqualsCSucceeds() {
        this.testEqualityNoAxiomsKBabcAEqualsCSucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }

    public void testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds() {
        this.testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds(new FOLOTTERLikeTheoremProver(true), false);
    }
}

