/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DLTestFactory;
import aima.learning.learners.CurrentBestLearner;
import aima.learning.learners.DecisionListLearner;
import aima.learning.learners.DecisionTreeLearner;
import aima.learning.learners.MajorityLearner;
import aima.test.learningtest.MockDLTestFactory;
import aima.test.learningtest.MockDataSetSpecification;
import java.util.ArrayList;
import junit.framework.TestCase;

public class LearnerTests
extends TestCase {
    public void testMajorityLearner() throws Exception {
        MajorityLearner learner = new MajorityLearner();
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        learner.train(ds);
        int[] result = learner.test(ds);
        LearnerTests.assertEquals(6, result[0]);
        LearnerTests.assertEquals(6, result[1]);
    }

    public void testDefaultUsedWhenTrainingDataSetHasNoExamples() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner learner = new DecisionTreeLearner();
        DataSet ds2 = ds.emptyDataSet();
        LearnerTests.assertEquals(0, ds2.size());
        learner.train(ds2);
        LearnerTests.assertEquals("Unable To Classify", learner.predict(ds.getExample(0)));
    }

    public void testClassificationReturnedWhenAllExamplesHaveTheSameClassification() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner learner = new DecisionTreeLearner();
        DataSet ds2 = ds.emptyDataSet();
        ds2.add(ds.getExample(0));
        ds2.add(ds.getExample(2));
        ds2.add(ds.getExample(3));
        learner.train(ds2);
        LearnerTests.assertEquals("Yes", learner.predict(ds.getExample(0)));
    }

    public void testMajorityReturnedWhenAttributesToExamineIsEmpty() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner learner = new DecisionTreeLearner();
        DataSet ds2 = ds.emptyDataSet();
        ds2.add(ds.getExample(0));
        ds2.add(ds.getExample(1));
        ds2.add(ds.getExample(2));
        ds2.add(ds.getExample(3));
        ds2.setSpecification(new MockDataSetSpecification("will_wait"));
        learner.train(ds2);
        LearnerTests.assertEquals("Yes", learner.predict(ds.getExample(1)));
    }

    public void testInducedTreeClassifiesDataSetCorrectly() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionTreeLearner learner = new DecisionTreeLearner();
        learner.train(ds);
        int[] result = learner.test(ds);
        LearnerTests.assertEquals(12, result[0]);
        LearnerTests.assertEquals(0, result[1]);
    }

    public void testDecisionListLearnerReturnsNegativeDLWhenDataSetEmpty() throws Exception {
        DecisionListLearner learner = new DecisionListLearner("Yes", "No", new MockDLTestFactory(null));
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DataSet empty = ds.emptyDataSet();
        learner.train(empty);
        LearnerTests.assertEquals("No", learner.predict(ds.getExample(0)));
        LearnerTests.assertEquals("No", learner.predict(ds.getExample(1)));
        LearnerTests.assertEquals("No", learner.predict(ds.getExample(2)));
    }

    public void testDecisionListLearnerReturnsFailureWhenTestsEmpty() throws Exception {
        DecisionListLearner learner = new DecisionListLearner("Yes", "No", new MockDLTestFactory(new ArrayList<DLTest>()));
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        learner.train(ds);
        LearnerTests.assertEquals("Failure", learner.predict(ds.getExample(0)));
    }

    public void testDecisionListTestRunOnRestaurantDataSet() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        DecisionListLearner learner = new DecisionListLearner("Yes", "No", new DLTestFactory());
        learner.train(ds);
        int[] result = learner.test(ds);
        LearnerTests.assertEquals(12, result[0]);
        LearnerTests.assertEquals(0, result[1]);
    }

    public void testCurrentBestLearnerOnRestaurantDataSet() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        CurrentBestLearner learner = new CurrentBestLearner("Yes");
        learner.train(ds);
        int[] result = learner.test(ds);
        LearnerTests.assertEquals(12, result[0]);
        LearnerTests.assertEquals(0, result[1]);
    }
}

