/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nodestore;

import aima.search.framework.Node;
import aima.search.framework.NodeStore;
import java.util.Hashtable;
import java.util.List;

public class CachedStateNodeStore
implements NodeStore {
    private NodeStore nodeStore;
    private Hashtable<Object, Node> cachedState = new Hashtable();

    public CachedStateNodeStore(NodeStore aNodeStore) {
        this.nodeStore = aNodeStore;
    }

    public boolean containsNodeBasedOn(Object state) {
        return this.cachedState.containsKey(state);
    }

    public Node getNodeBasedOn(Object state) {
        return this.cachedState.get(state);
    }

    @Override
    public void add(Node anItem) {
        this.nodeStore.add(anItem);
        this.cachedState.put(anItem.getState(), anItem);
    }

    @Override
    public Node remove() {
        Node n = this.nodeStore.remove();
        this.cachedState.remove(n.getState());
        return n;
    }

    @Override
    public void add(List<Node> nodes) {
        this.nodeStore.add(nodes);
        for (Node n : nodes) {
            this.cachedState.put(n.getState(), n);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodeStore.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeStore.size();
    }
}

