/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.demos;

import aima.learning.reinforcement.PassiveADPAgent;
import aima.learning.reinforcement.PassiveTDAgent;
import aima.learning.reinforcement.QLearningAgent;
import aima.learning.reinforcement.QTable;
import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import aima.probability.EnumerateJointAsk;
import aima.probability.EnumerationAsk;
import aima.probability.JavaRandomizer;
import aima.probability.ProbabilityDistribution;
import aima.probability.Query;
import aima.probability.RandomVariable;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPFactory;
import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.ParticleSet;
import aima.util.Pair;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ProbabilityDemo {
    public static void main(String[] args) {
        ProbabilityDemo.enumerationJointAskDemo();
        ProbabilityDemo.enumerationAskDemo();
        ProbabilityDemo.priorSampleDemo();
        ProbabilityDemo.rejectionSamplingDemo();
        ProbabilityDemo.likelihoodWeightingDemo();
        ProbabilityDemo.mcmcAskDemo();
        ProbabilityDemo.forwardBackWardDemo();
        ProbabilityDemo.particleFilterinfDemo();
        ProbabilityDemo.valueIterationDemo();
        ProbabilityDemo.policyIterationDemo();
        ProbabilityDemo.passiveADPgentDemo();
        ProbabilityDemo.passiveTDAgentDemo();
        ProbabilityDemo.qLearningAgentDemo();
    }

    private static void forwardBackWardDemo() {
        System.out.println("\nForward BackWard Demo\n");
        HiddenMarkovModel rainmanHmm = HMMFactory.createRainmanHMM();
        System.out.println("Creating a Hdden Markov Model to represent the model in Fig 15.5 ");
        ArrayList<String> perceptions = new ArrayList<String>();
        perceptions.add("carries_umbrella");
        perceptions.add("carries_umbrella");
        List<RandomVariable> results = rainmanHmm.forward_backward(perceptions);
        RandomVariable smoothedDayOne = results.get(1);
        System.out.println("Smoothed Probability Of Raining on Day One = " + smoothedDayOne.getProbabilityOf("rain"));
        System.out.println("Smoothed Probability Of NOT Raining on Day One =" + smoothedDayOne.getProbabilityOf("no_rain"));
        RandomVariable smoothedDayTwo = results.get(2);
        System.out.println("Smoothed Probability Of Raining on Day Two = " + smoothedDayTwo.getProbabilityOf("rain"));
        System.out.println("Smoothed Probability Of NOT Raining on Day Two = " + smoothedDayTwo.getProbabilityOf("no_rain"));
    }

    private static void particleFilterinfDemo() {
        System.out.println("\nParticle Filtering Demo\n");
        HiddenMarkovModel rainman = HMMFactory.createRainmanHMM();
        JavaRandomizer r = new JavaRandomizer();
        ParticleSet starting = rainman.prior().toParticleSet(rainman, r, 1000);
        System.out.println("at the beginning, " + starting.numberOfParticlesWithState("rain") + " particles 0f 1000 indicate status == 'raining' ");
        System.out.println("at the beginning, " + starting.numberOfParticlesWithState("no_rain") + " particles of 1000 indicate status == 'NOT raining' ");
        System.out.println("\n Filtering Particle Set.On perception == 'SEE_UMBRELLA' ..\n");
        ParticleSet afterSeeingUmbrella = starting.filter("carries_umbrella", r);
        System.out.println("after filtering " + afterSeeingUmbrella.numberOfParticlesWithState("rain") + " particles of 1000 indicate status == 'raining' ");
        System.out.println("after filtering " + afterSeeingUmbrella.numberOfParticlesWithState("no_rain") + " particles of 1000 indicate status == 'NOT raining' ");
    }

    private static void valueIterationDemo() {
        System.out.println("\nValue Iteration Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> fourByThreeMDP = MDPFactory.createFourByThreeMDP();
        System.out.println("Beginning Value Iteration");
        MDPUtilityFunction<CellWorldPosition> uf = fourByThreeMDP.valueIterationTillMAximumUtilityGrowthFallsBelowErrorMargin(1.0, 1.0E-5);
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printUtility(uf, i, j);
            }
        }
    }

    private static void printUtility(MDPUtilityFunction<CellWorldPosition> uf, int i, int j) {
        System.out.println("Utility of (" + i + " , " + j + " ) " + uf.getUtility(new CellWorldPosition(i, j)));
    }

    private static void policyIterationDemo() {
        System.out.println("\nPolicy Iteration Demo\n");
        System.out.println("\nValue Iteration Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> fourByThreeMDP = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> policy = fourByThreeMDP.policyIteration(1.0);
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printPolicy(i, j, policy);
            }
        }
    }

    private static void printPolicy(int i, int j, MDPPolicy<CellWorldPosition, String> policy) {
        System.out.println("Reccomended Action for (" + i + " , " + j + " )  =  " + policy.getAction(new CellWorldPosition(i, j)));
    }

    private static void passiveADPgentDemo() {
        int i;
        System.out.println("\nPassive ADP Agent Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> fourByThree = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> policy = new MDPPolicy<CellWorldPosition, String>();
        System.out.println("Creating a policy to reflect the policy in Fig 17.3");
        policy.setAction(new CellWorldPosition(1, 1), "up");
        policy.setAction(new CellWorldPosition(1, 2), "left");
        policy.setAction(new CellWorldPosition(1, 3), "left");
        policy.setAction(new CellWorldPosition(1, 4), "left");
        policy.setAction(new CellWorldPosition(2, 1), "up");
        policy.setAction(new CellWorldPosition(2, 3), "up");
        policy.setAction(new CellWorldPosition(3, 1), "right");
        policy.setAction(new CellWorldPosition(3, 2), "right");
        policy.setAction(new CellWorldPosition(3, 3), "right");
        PassiveADPAgent<CellWorldPosition, String> agent = new PassiveADPAgent<CellWorldPosition, String>(fourByThree, policy);
        JavaRandomizer r = new JavaRandomizer();
        System.out.println("Deriving Utility Function using the Passive ADP Agent  From 100 trials in the 4 by 3 world");
        MDPUtilityFunction<CellWorldPosition> uf = null;
        for (i = 0; i < 100; ++i) {
            agent.executeTrial(r);
            uf = agent.getUtilityFunction();
        }
        for (i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printUtility(uf, i, j);
            }
        }
    }

    private static void passiveTDAgentDemo() {
        int i;
        System.out.println("\nPassive TD Agent Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> fourByThree = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> policy = new MDPPolicy<CellWorldPosition, String>();
        System.out.println("Creating a policy to reflect the policy in Fig 17.3");
        policy.setAction(new CellWorldPosition(1, 1), "up");
        policy.setAction(new CellWorldPosition(1, 2), "left");
        policy.setAction(new CellWorldPosition(1, 3), "left");
        policy.setAction(new CellWorldPosition(1, 4), "left");
        policy.setAction(new CellWorldPosition(2, 1), "up");
        policy.setAction(new CellWorldPosition(2, 3), "up");
        policy.setAction(new CellWorldPosition(3, 1), "right");
        policy.setAction(new CellWorldPosition(3, 2), "right");
        policy.setAction(new CellWorldPosition(3, 3), "right");
        PassiveTDAgent<CellWorldPosition, String> agent = new PassiveTDAgent<CellWorldPosition, String>(fourByThree, policy);
        JavaRandomizer r = new JavaRandomizer();
        System.out.println("Deriving Utility Function in the Passive ADP Agent  From 200 trials in the 4 by 3 world");
        MDPUtilityFunction<CellWorldPosition> uf = null;
        for (i = 0; i < 200; ++i) {
            agent.executeTrial(r);
            uf = agent.getUtilityFunction();
        }
        for (i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printUtility(uf, i, j);
            }
        }
    }

    private static void qLearningAgentDemo() {
        System.out.println("\nQ Learning Agent Demo Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> fourByThree = MDPFactory.createFourByThreeMDP();
        QLearningAgent<CellWorldPosition, String> qla = new QLearningAgent<CellWorldPosition, String>(fourByThree);
        JavaRandomizer r = new JavaRandomizer();
        Hashtable<Pair<CellWorldPosition, String>, Double> q = null;
        QTable<CellWorldPosition, String> qTable = null;
        System.out.println("After 100 trials in the 4 by 3 world");
        for (int i = 0; i < 100; ++i) {
            qla.executeTrial(r);
            q = qla.getQ();
            qTable = qla.getQTable();
        }
        System.out.println("Final Q table" + qTable);
    }

    public static void enumerationJointAskDemo() {
        System.out.println("\nEnumerationJointAsk Demo\n");
        ProbabilityDistribution jp = new ProbabilityDistribution("ToothAche", "Cavity", "Catch");
        jp.set(true, true, true, 0.108);
        jp.set(true, true, false, 0.012);
        jp.set(false, true, true, 0.072);
        jp.set(false, true, false, 0.008);
        jp.set(true, false, true, 0.016);
        jp.set(true, false, false, 0.064);
        jp.set(false, false, true, 0.144);
        jp.set(false, false, false, 0.008);
        Query q = new Query("Cavity", new String[]{"ToothAche"}, new boolean[]{true});
        double[] probs = EnumerateJointAsk.ask(q, jp);
        System.out.println("Using the full joint distribution of page 475 of Aima 2nd Edition");
        System.out.println("Probability distribution of ToothAche using Enumeration joint ask is " + ProbabilityDemo.string(probs));
    }

    private static void priorSampleDemo() {
        System.out.println("\nPriorSample Demo\n");
        BayesNet net = ProbabilityDemo.createWetGrassNetwork();
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition generates");
        Hashtable table = net.getPriorSample();
        System.out.println(table.toString());
    }

    private static void rejectionSamplingDemo() {
        BayesNet net = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> evidence = new Hashtable<String, Boolean>();
        evidence.put("Sprinkler", Boolean.TRUE);
        double[] results = net.rejectionSample("Rain", evidence, 100);
        System.out.println("\nRejectionSampling Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(results));
    }

    private static void likelihoodWeightingDemo() {
        BayesNet net = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> evidence = new Hashtable<String, Boolean>();
        evidence.put("Sprinkler", Boolean.TRUE);
        double[] results = net.likelihoodWeighting("Rain", evidence, 100);
        System.out.println("\nLikelihoodWeighting Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(results));
    }

    private static void mcmcAskDemo() {
        BayesNet net = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> evidence = new Hashtable<String, Boolean>();
        evidence.put("Sprinkler", Boolean.TRUE);
        double[] results = net.mcmcAsk("Rain", evidence, 100);
        System.out.println("\nMCMCAsk Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(results));
    }

    public static void enumerationAskDemo() {
        System.out.println("\nEnumerationAsk Demo\n");
        Query q = new Query("Burglary", new String[]{"JohnCalls", "MaryCalls"}, new boolean[]{true, true});
        double[] probs = EnumerationAsk.ask(q, ProbabilityDemo.createBurglaryNetwork());
        System.out.println("Using the Burglary BayesNet from page 494 of AIMA 2nd Edition");
        System.out.println("Querying the probability of Burglary|JohnCalls=true, MaryCalls=true gives " + ProbabilityDemo.string(probs));
    }

    private static BayesNet createBurglaryNetwork() {
        BayesNetNode burglary = new BayesNetNode("Burglary");
        BayesNetNode earthquake = new BayesNetNode("EarthQuake");
        BayesNetNode alarm = new BayesNetNode("Alarm");
        BayesNetNode johnCalls = new BayesNetNode("JohnCalls");
        BayesNetNode maryCalls = new BayesNetNode("MaryCalls");
        alarm.influencedBy(burglary, earthquake);
        johnCalls.influencedBy(alarm);
        maryCalls.influencedBy(alarm);
        burglary.setProbability(true, 0.001);
        earthquake.setProbability(true, 0.002);
        alarm.setProbability(true, true, 0.95);
        alarm.setProbability(true, false, 0.94);
        alarm.setProbability(false, true, 0.29);
        alarm.setProbability(false, false, 0.001);
        johnCalls.setProbability(true, 0.9);
        johnCalls.setProbability(false, 0.05);
        maryCalls.setProbability(true, 0.7);
        maryCalls.setProbability(false, 0.01);
        BayesNet net = new BayesNet(burglary, earthquake);
        return net;
    }

    private static BayesNet createWetGrassNetwork() {
        BayesNetNode cloudy = new BayesNetNode("Cloudy");
        BayesNetNode sprinkler = new BayesNetNode("Sprinkler");
        BayesNetNode rain = new BayesNetNode("Rain");
        BayesNetNode wetGrass = new BayesNetNode("WetGrass");
        sprinkler.influencedBy(cloudy);
        rain.influencedBy(cloudy);
        wetGrass.influencedBy(rain, sprinkler);
        cloudy.setProbability(true, 0.5);
        sprinkler.setProbability(true, 0.1);
        sprinkler.setProbability(false, 0.5);
        rain.setProbability(true, 0.8);
        rain.setProbability(false, 0.2);
        wetGrass.setProbability(true, true, 0.99);
        wetGrass.setProbability(true, false, 0.9);
        wetGrass.setProbability(false, true, 0.9);
        wetGrass.setProbability(false, false, 0.0);
        BayesNet net = new BayesNet(cloudy);
        return net;
    }

    private static String string(double[] probs) {
        return " [ " + probs[0] + " , " + probs[1] + " ] ";
    }
}

