/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.logic.propositional.algorithms.Model;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ProbabilityDistribution {
    private List<Row> rows;
    String[] variableNames;

    public ProbabilityDistribution(String variableNameOne) {
        this(new String[]{variableNameOne});
    }

    public ProbabilityDistribution(String variableNameOne, String variableNameTwo) {
        this(new String[]{variableNameOne, variableNameTwo});
    }

    public ProbabilityDistribution(String variableNameOne, String variableNameTwo, String variableNameThree) {
        this(new String[]{variableNameOne, variableNameTwo, variableNameThree});
    }

    public ProbabilityDistribution(String variableNameOne, String variableNameTwo, String variableNameThree, String variableNameFour) {
        this(new String[]{variableNameOne, variableNameTwo, variableNameThree, variableNameFour});
    }

    public ProbabilityDistribution(String[] variableNames) {
        this.variableNames = variableNames;
        this.rows = new ArrayList<Row>();
    }

    public void set(boolean[] values, double probability) {
        Model m = new Model();
        for (int i = 0; i < this.variableNames.length; ++i) {
            m = m.extend(this.variableNames[i], values[i]);
        }
        this.rows.add(new Row(m, probability));
    }

    public void set(boolean value1, double probability) {
        this.set(new boolean[]{value1}, probability);
    }

    public void set(boolean value1, boolean value2, double probability) {
        this.set(new boolean[]{value1, value2}, probability);
    }

    public void set(boolean value1, boolean value2, boolean value3, double probability) {
        this.set(new boolean[]{value1, value2, value3}, probability);
    }

    public void set(boolean value1, boolean value2, boolean value3, boolean value4, double probability) {
        this.set(new boolean[]{value1, value2, value3, value4}, probability);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Row row : this.rows) {
            buf.append(row.toString() + "\n");
        }
        return buf.toString();
    }

    public double probabilityOf(Hashtable conditions) {
        double prob = 0.0;
        for (Row row : this.rows) {
            Iterator iter = conditions.keySet().iterator();
            boolean rowMeetsAllConditions = true;
            while (iter.hasNext()) {
                boolean value;
                String variable = (String)iter.next();
                if (row.model.matches(variable, value = ((Boolean)conditions.get(variable)).booleanValue())) continue;
                rowMeetsAllConditions = false;
                break;
            }
            if (!rowMeetsAllConditions) continue;
            prob += row.probability;
        }
        return prob;
    }

    public double probabilityOf(String variableName, boolean b) {
        Hashtable<String, Boolean> h = new Hashtable<String, Boolean>();
        h.put(variableName, new Boolean(b));
        return this.probabilityOf(h);
    }

    class Row {
        Model model;
        double probability;

        Row(Model m, double probability) {
            this.model = m;
            this.probability = probability;
        }

        public String toString() {
            return this.model.toString() + " => " + this.probability;
        }
    }
}

