/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing;

import aima.logic.common.Lexer;
import aima.logic.common.Token;
import java.util.HashSet;
import java.util.Set;

public class PELexer
extends Lexer {
    Set<String> connectors = new HashSet<String>();

    public PELexer() {
        this.connectors.add("NOT");
        this.connectors.add("AND");
        this.connectors.add("OR");
        this.connectors.add("=>");
        this.connectors.add("<=>");
    }

    public PELexer(String inputString) {
        this();
        this.setInput(inputString);
    }

    @Override
    public Token nextToken() {
        Object result = null;
        if (this.lookAhead(1) == '(') {
            this.consume();
            return new Token(2, "(");
        }
        if (this.lookAhead(1) == ')') {
            this.consume();
            return new Token(3, ")");
        }
        if (this.identifierDetected()) {
            return this.symbol();
        }
        if (Character.isWhitespace(this.lookAhead(1))) {
            this.consume();
            return this.nextToken();
        }
        if (this.lookAhead(1) == '\uffff') {
            return new Token(9999, "EOI");
        }
        throw new RuntimeException("Lexing error on character " + this.lookAhead(1));
    }

    private boolean identifierDetected() {
        return Character.isJavaIdentifierStart((char)this.lookAheadBuffer[0]) || this.partOfConnector();
    }

    private boolean partOfConnector() {
        return this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>';
    }

    private Token symbol() {
        StringBuffer sbuf = new StringBuffer();
        while (Character.isLetterOrDigit(this.lookAhead(1)) || this.lookAhead(1) == '=' || this.lookAhead(1) == '<' || this.lookAhead(1) == '>') {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        String symbol = sbuf.toString();
        if (this.isConnector(symbol)) {
            return new Token(5, sbuf.toString());
        }
        if (symbol.equalsIgnoreCase("true")) {
            return new Token(11, "TRUE");
        }
        if (symbol.equalsIgnoreCase("false")) {
            return new Token(12, "FALSE");
        }
        return new Token(1, sbuf.toString());
    }

    private Token connector() {
        StringBuffer sbuf = new StringBuffer();
        while (Character.isLetterOrDigit(this.lookAhead(1))) {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        return new Token(5, sbuf.toString());
    }

    private Token whiteSpace() {
        StringBuffer sbuf = new StringBuffer();
        while (Character.isWhitespace(this.lookAhead(1))) {
            sbuf.append(this.lookAhead(1));
            this.consume();
        }
        return new Token(1000, sbuf.toString());
    }

    private boolean isConnector(String aSymbol) {
        return this.connectors.contains(aSymbol);
    }
}

