/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.SymbolComparator;
import aima.logic.propositional.parsing.ast.UnarySentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolClassifier;
import aima.util.Converter;
import aima.util.LogicUtils;
import aima.util.SetOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PLResolution {
    public boolean plResolution(KnowledgeBase kb, String alpha) {
        return this.plResolution(kb, (Sentence)new PEParser().parse(alpha));
    }

    public boolean plResolution(KnowledgeBase kb, Sentence alpha) {
        BinarySentence kBAndNotAlpha = new BinarySentence("AND", kb.asSentence(), new UnarySentence(alpha));
        Set<Sentence> clauses = new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(kBAndNotAlpha));
        clauses = this.filterOutClausesWithTwoComplementaryLiterals(clauses);
        Set<Object> newClauses = new HashSet();
        while (true) {
            List<List<Sentence>> pairs = this.getCombinationPairs(new Converter<Sentence>().setToList(clauses));
            for (int i = 0; i < pairs.size(); ++i) {
                List<Sentence> pair = pairs.get(i);
                Set<Sentence> resolvents = this.plResolve(pair.get(0), pair.get(1));
                if ((resolvents = this.filterOutClausesWithTwoComplementaryLiterals(resolvents)).contains(new Symbol("EMPTY_CLAUSE"))) {
                    return true;
                }
                newClauses = new SetOps<Sentence>().union(newClauses, resolvents);
            }
            if (new SetOps<Sentence>().intersection(newClauses, clauses).size() == newClauses.size()) {
                return false;
            }
            clauses = new SetOps<Sentence>().union(newClauses, clauses);
            clauses = this.filterOutClausesWithTwoComplementaryLiterals(clauses);
        }
    }

    private Set<Sentence> filterOutClausesWithTwoComplementaryLiterals(Set<Sentence> clauses) {
        HashSet<Sentence> filtered = new HashSet<Sentence>();
        SymbolClassifier classifier = new SymbolClassifier();
        for (Sentence clause : clauses) {
            Set<Symbol> negativeSymbols;
            Set<Symbol> positiveSymbols = classifier.getPositiveSymbolsIn(clause);
            if (new SetOps<Symbol>().intersection(positiveSymbols, negativeSymbols = classifier.getNegativeSymbolsIn(clause)).size() != 0) continue;
            filtered.add(clause);
        }
        return filtered;
    }

    public Set<Sentence> plResolve(Sentence clause1, Sentence clause2) {
        HashSet<Sentence> resolvents = new HashSet<Sentence>();
        ClauseSymbols cs = new ClauseSymbols(clause1, clause2);
        for (Symbol symbol : cs.getComplementedSymbols()) {
            resolvents.add(this.createResolventClause(cs, symbol));
        }
        return resolvents;
    }

    private Sentence createResolventClause(ClauseSymbols cs, Symbol toRemove) {
        int i;
        List<Symbol> positiveSymbols = new Converter<Symbol>().setToList(new SetOps<Symbol>().union(cs.clause1PositiveSymbols, cs.clause2PositiveSymbols));
        List<Symbol> negativeSymbols = new Converter<Symbol>().setToList(new SetOps<Symbol>().union(cs.clause1NegativeSymbols, cs.clause2NegativeSymbols));
        if (positiveSymbols.contains(toRemove)) {
            positiveSymbols.remove(toRemove);
        }
        if (negativeSymbols.contains(toRemove)) {
            negativeSymbols.remove(toRemove);
        }
        Collections.sort(positiveSymbols, new SymbolComparator());
        Collections.sort(negativeSymbols, new SymbolComparator());
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        for (i = 0; i < positiveSymbols.size(); ++i) {
            sentences.add(positiveSymbols.get(i));
        }
        for (i = 0; i < negativeSymbols.size(); ++i) {
            sentences.add(new UnarySentence(negativeSymbols.get(i)));
        }
        if (sentences.size() == 0) {
            return new Symbol("EMPTY_CLAUSE");
        }
        return LogicUtils.chainWith("OR", sentences);
    }

    private List<List<Sentence>> getCombinationPairs(List<Sentence> clausesList) {
        int odd = clausesList.size() % 2;
        int midpoint = 0;
        midpoint = odd == 1 ? clausesList.size() / 2 + 1 : clausesList.size() / 2;
        ArrayList<List<Sentence>> pairs = new ArrayList<List<Sentence>>();
        for (int i = 0; i < clausesList.size(); ++i) {
            for (int j = i; j < clausesList.size(); ++j) {
                Sentence second;
                ArrayList<Sentence> pair = new ArrayList<Sentence>();
                Sentence first = clausesList.get(i);
                if (first.equals(second = clausesList.get(j))) continue;
                pair.add(first);
                pair.add(second);
                pairs.add(pair);
            }
        }
        return pairs;
    }

    public boolean plResolution(String kbs, String alphaString) {
        KnowledgeBase kb = new KnowledgeBase();
        kb.tell(kbs);
        Sentence alpha = (Sentence)new PEParser().parse(alphaString);
        return this.plResolution(kb, alpha);
    }

    class ClauseSymbols {
        Set<Symbol> clause1Symbols;
        Set<Symbol> clause1PositiveSymbols;
        Set<Symbol> clause1NegativeSymbols;
        Set<Symbol> clause2Symbols;
        Set<Symbol> clause2PositiveSymbols;
        Set<Symbol> clause2NegativeSymbols;
        Set<Symbol> positiveInClause1NegativeInClause2;
        Set<Symbol> negativeInClause1PositiveInClause2;

        public ClauseSymbols(Sentence clause1, Sentence clause2) {
            SymbolClassifier classifier = new SymbolClassifier();
            this.clause1Symbols = classifier.getSymbolsIn(clause1);
            this.clause1PositiveSymbols = classifier.getPositiveSymbolsIn(clause1);
            this.clause1NegativeSymbols = classifier.getNegativeSymbolsIn(clause1);
            this.clause2Symbols = classifier.getSymbolsIn(clause2);
            this.clause2PositiveSymbols = classifier.getPositiveSymbolsIn(clause2);
            this.clause2NegativeSymbols = classifier.getNegativeSymbolsIn(clause2);
            this.positiveInClause1NegativeInClause2 = new SetOps<Symbol>().intersection(this.clause1PositiveSymbols, this.clause2NegativeSymbols);
            this.negativeInClause1PositiveInClause2 = new SetOps<Symbol>().intersection(this.clause1NegativeSymbols, this.clause2PositiveSymbols);
        }

        public Set getComplementedSymbols() {
            return new SetOps<Symbol>().union(this.positiveInClause1NegativeInClause2, this.negativeInClause1PositiveInClause2);
        }
    }
}

