/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.knowledge.CurrentBestLearning;
import aima.learning.knowledge.FOLDataSetDomain;
import aima.learning.knowledge.FOLExample;
import aima.learning.knowledge.Hypothesis;
import aima.logic.fol.inference.FOLOTTERLikeTheoremProver;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.kb.FOLKnowledgeBase;
import java.util.ArrayList;

public class CurrentBestLearner
implements Learner {
    private String trueGoalValue = null;
    private FOLDataSetDomain folDSDomain = null;
    private FOLKnowledgeBase kb = null;
    private Hypothesis currentBestHypothesis = null;

    public CurrentBestLearner(String trueGoalValue) {
        this.trueGoalValue = trueGoalValue;
    }

    @Override
    public void train(DataSet ds) {
        this.folDSDomain = new FOLDataSetDomain(ds.specification, this.trueGoalValue);
        ArrayList<FOLExample> folExamples = new ArrayList<FOLExample>();
        int egNo = 1;
        for (Example e : ds.examples) {
            folExamples.add(new FOLExample(this.folDSDomain, e, egNo));
            ++egNo;
        }
        this.kb = new FOLKnowledgeBase(this.folDSDomain, new FOLOTTERLikeTheoremProver(1000L, false));
        CurrentBestLearning cbl = new CurrentBestLearning(this.folDSDomain, this.kb);
        this.currentBestHypothesis = cbl.currentBestLearning(folExamples);
    }

    @Override
    public String predict(Example e) {
        String prediction = "~" + e.targetValue();
        if (null != this.currentBestHypothesis) {
            FOLExample etp = new FOLExample(this.folDSDomain, e, 0);
            this.kb.clear();
            this.kb.tell(etp.getDescription());
            this.kb.tell(this.currentBestHypothesis.getHypothesis());
            InferenceResult ir = this.kb.ask(etp.getClassification());
            if (ir.isTrue()) {
                if (this.trueGoalValue.equals(e.targetValue())) {
                    prediction = e.targetValue();
                }
            } else if ((ir.isPossiblyFalse() || ir.isUnknownDueToTimeout()) && !this.trueGoalValue.equals(e.targetValue())) {
                prediction = e.targetValue();
            }
        }
        return prediction;
    }

    @Override
    public int[] test(DataSet ds) {
        int[] results = new int[]{0, 0};
        for (Example e : ds.examples) {
            if (e.targetValue().equals(this.predict(e))) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }
}

