/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class TicTacToeBoard {
    private static final String O = "O";
    private static final String X = "X";
    String[] topRow = new String[]{" ", " ", " "};
    String[] midRow = new String[]{" ", " ", " "};
    String[] bottomRow = new String[]{" ", " ", " "};

    private String[] whichRow(int rowNumber) {
        String[] whichRow = null;
        if (rowNumber == 0) {
            whichRow = this.topRow;
        } else if (rowNumber == 1) {
            whichRow = this.midRow;
        } else if (rowNumber == 2) {
            whichRow = this.bottomRow;
        }
        return whichRow;
    }

    public boolean isEmpty(int row, int col) {
        String[] whichRow = this.whichRow(row);
        return whichRow[col] == " ";
    }

    public void markX(int row, int col) {
        this.mark(row, col, X);
    }

    public void markO(int row, int col) {
        this.mark(row, col, O);
    }

    public void mark(int row, int col, String symbol) {
        String[] whichRow = null;
        whichRow = this.whichRow(row);
        whichRow[col] = symbol;
    }

    public boolean isAnyRowComplete() {
        boolean retVal = false;
        for (int i = 0; i < 3; ++i) {
            String[] whichRow = this.whichRow(i);
            if (whichRow[0] == " " || whichRow[0] != whichRow[1] || whichRow[1] != whichRow[2]) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public boolean isAnyColumnComplete() {
        boolean retVal = false;
        for (int i = 0; i < 3; ++i) {
            if (this.topRow[i] == " " || this.topRow[i] != this.midRow[i] || this.midRow[i] != this.bottomRow[i]) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public boolean isAnyDiagonalComplete() {
        boolean retVal = false;
        if (this.topRow[0] != " " && this.topRow[0] == this.midRow[1] && this.midRow[1] == this.bottomRow[2]) {
            retVal = true;
        } else if (this.topRow[2] != " " && this.topRow[2] == this.midRow[1] && this.midRow[1] == this.bottomRow[0]) {
            retVal = true;
        }
        return retVal;
    }

    public boolean lineThroughBoard() {
        return this.isAnyRowComplete() || this.isAnyColumnComplete() || this.isAnyDiagonalComplete();
    }

    public String getValue(int row, int col) {
        String[] whichRow = this.whichRow(row);
        return whichRow[col];
    }

    private void setValue(int row, int col, String val) {
        String[] whichRow = this.whichRow(row);
        whichRow[col] = val;
    }

    public void print() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String value = this.getValue(i, j);
                String printValue = value == " " ? "-" : value;
                System.out.print(printValue + " ");
            }
            System.out.println();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String value = this.getValue(i, j);
                String printValue = value == " " ? "-" : value;
                buf.append(printValue + " ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public TicTacToeBoard cloneBoard() {
        return (TicTacToeBoard)this.clone();
    }

    public Object clone() {
        TicTacToeBoard newBoard = new TicTacToeBoard();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String s = this.getValue(i, j);
                newBoard.setValue(i, j, s);
            }
        }
        return newBoard;
    }

    public int getNumberOfMarkedPositions() {
        int retVal = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.isEmpty(i, j)) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    public List getUnMarkedPositions() {
        ArrayList<XYLocation> retVal = new ArrayList<XYLocation>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.isEmpty(i, j)) continue;
                retVal.add(new XYLocation(i, j));
            }
        }
        return retVal;
    }

    public boolean equals(Object anObj) {
        boolean retVal = true;
        TicTacToeBoard anotherBoard = (TicTacToeBoard)anObj;
        boolean secondBreak = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (anotherBoard.getValue(i, j) == this.getValue(i, j)) continue;
                retVal = false;
                secondBreak = true;
                break;
            }
            if (!secondBreak) break;
        }
        return retVal;
    }

    public boolean isMarked(String string, int i, int j) {
        return this.getValue(i, j).equals(string);
    }
}

