/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.basic.XYLocation;
import aima.games.AlphaBeta;
import aima.games.Game;
import aima.games.GameState;
import aima.games.TicTacToeBoard;
import java.util.ArrayList;

public class TicTacToe
extends Game {
    public TicTacToe() {
        ArrayList<XYLocation> moves = new ArrayList<XYLocation>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                XYLocation loc = new XYLocation(i, j);
                moves.add(loc);
            }
        }
        this.initialState.put("moves", moves);
        this.initialState.put("player", "X");
        this.initialState.put("utility", new Integer(0));
        this.initialState.put("board", new TicTacToeBoard());
        this.initialState.put("level", new Integer(0));
        this.presentState = this.initialState;
    }

    public TicTacToeBoard getBoard(GameState state) {
        return (TicTacToeBoard)state.get("board");
    }

    @Override
    public ArrayList getSuccessorStates(GameState state) {
        GameState temp = this.presentState;
        ArrayList<GameState> retVal = new ArrayList<GameState>();
        int parentLevel = this.getLevel(state);
        for (int i = 0; i < this.getMoves(state).size(); ++i) {
            XYLocation loc = (XYLocation)this.getMoves(state).get(i);
            GameState aState = this.makeMove(state, loc);
            aState.put("moveMade", loc);
            aState.put("level", new Integer(parentLevel + 1));
            retVal.add(aState);
        }
        this.presentState = temp;
        return retVal;
    }

    @Override
    public GameState makeMove(GameState state, Object o) {
        XYLocation loc = (XYLocation)o;
        return this.makeMove(state, loc.getXCoOrdinate(), loc.getYCoOrdinate());
    }

    public GameState makeMove(GameState state, int x, int y) {
        GameState temp = this.getMove(state, x, y);
        if (temp != null) {
            this.presentState = temp;
        }
        return this.presentState;
    }

    public GameState makeMove(int x, int y) {
        GameState state = this.presentState;
        GameState temp = this.getMove(state, x, y);
        if (temp != null) {
            this.presentState = temp;
        }
        return this.presentState;
    }

    public GameState getMove(GameState state, int x, int y) {
        GameState retVal = null;
        XYLocation loc = new XYLocation(x, y);
        ArrayList moves = this.getMoves(state);
        ArrayList newMoves = (ArrayList)moves.clone();
        if (moves.contains(loc)) {
            int index = newMoves.indexOf(loc);
            newMoves.remove(index);
            retVal = new GameState();
            retVal.put("moves", newMoves);
            TicTacToeBoard newBoard = this.getBoard(state).cloneBoard();
            if (this.getPlayerToMove(state) == "X") {
                newBoard.markX(x, y);
                retVal.put("player", "O");
            } else {
                newBoard.markO(x, y);
                retVal.put("player", "X");
            }
            retVal.put("board", newBoard);
            retVal.put("utility", new Integer(this.computeUtility(newBoard, this.getPlayerToMove(this.getState()))));
            retVal.put("level", new Integer(this.getLevel(state) + 1));
        }
        return retVal;
    }

    @Override
    public int computeUtility(GameState state) {
        int utility = this.computeUtility((TicTacToeBoard)state.get("board"), this.getPlayerToMove(state));
        return utility;
    }

    private int computeUtility(TicTacToeBoard aBoard, String playerToMove) {
        int retVal = 0;
        if (aBoard.lineThroughBoard()) {
            retVal = playerToMove.equals("X") ? -1 : 1;
        }
        return retVal;
    }

    @Override
    public boolean terminalTest(GameState state) {
        TicTacToeBoard board = (TicTacToeBoard)state.get("board");
        boolean line = board.lineThroughBoard();
        boolean filled = board.getNumberOfMarkedPositions() == 9;
        return line || filled;
    }

    public void printPossibleMoves() {
        System.out.println("Possible moves");
        ArrayList moves = this.getMoves(this.presentState);
        for (int i = 0; i < moves.size(); ++i) {
            XYLocation moveLoc = (XYLocation)moves.get(i);
            GameState newState = this.getMove(this.presentState, moveLoc.getXCoOrdinate(), moveLoc.getYCoOrdinate());
            TicTacToeBoard board = (TicTacToeBoard)newState.get("board");
            System.out.println("utility = " + this.computeUtility(newState));
            System.out.println("");
        }
    }

    @Override
    public int getMiniMaxValue(GameState state) {
        if (this.getPlayerToMove(state).equalsIgnoreCase("X")) {
            return this.maxValue(state);
        }
        return this.minValue(state);
    }

    @Override
    public int getAlphaBetaValue(GameState state) {
        if (this.getPlayerToMove(state).equalsIgnoreCase("X")) {
            AlphaBeta initial = new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE);
            int max = this.maxValue(state, initial);
            return max;
        }
        AlphaBeta initial = new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE);
        return this.minValue(state, initial);
    }
}

