/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.utils;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public class ImageTracer {
    public static String versionnumber = "1.1.2";
    static byte[] pathscan_dir_lookup = new byte[]{0, 0, 3, 0, 1, 0, 3, 0, 0, 3, 3, 1, 0, 3, 0, 0};
    static boolean[] pathscan_holepath_lookup = new boolean[]{false, false, false, false, false, false, false, true, false, false, false, true, false, true, true, false};
    static byte[][][] pathscan_combined_lookup = new byte[][][]{new byte[][]{{-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}, new byte[][]{{0, 1, 0, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {0, 2, -1, 0}}, new byte[][]{{-1, -1, -1, -1}, {-1, -1, -1, -1}, {0, 1, 0, -1}, {0, 0, 1, 0}}, new byte[][]{{0, 0, 1, 0}, {-1, -1, -1, -1}, {0, 2, -1, 0}, {-1, -1, -1, -1}}, new byte[][]{{-1, -1, -1, -1}, {0, 0, 1, 0}, {0, 3, 0, 1}, {-1, -1, -1, -1}}, new byte[][]{{13, 3, 0, 1}, {13, 2, -1, 0}, {7, 1, 0, -1}, {7, 0, 1, 0}}, new byte[][]{{-1, -1, -1, -1}, {0, 1, 0, -1}, {-1, -1, -1, -1}, {0, 3, 0, 1}}, new byte[][]{{0, 3, 0, 1}, {0, 2, -1, 0}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}, new byte[][]{{0, 3, 0, 1}, {0, 2, -1, 0}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}, new byte[][]{{-1, -1, -1, -1}, {0, 1, 0, -1}, {-1, -1, -1, -1}, {0, 3, 0, 1}}, new byte[][]{{11, 1, 0, -1}, {14, 0, 1, 0}, {14, 3, 0, 1}, {11, 2, -1, 0}}, new byte[][]{{-1, -1, -1, -1}, {0, 0, 1, 0}, {0, 3, 0, 1}, {-1, -1, -1, -1}}, new byte[][]{{0, 0, 1, 0}, {-1, -1, -1, -1}, {0, 2, -1, 0}, {-1, -1, -1, -1}}, new byte[][]{{-1, -1, -1, -1}, {-1, -1, -1, -1}, {0, 1, 0, -1}, {0, 0, 1, 0}}, new byte[][]{{0, 1, 0, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {0, 2, -1, 0}}, new byte[][]{{-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}}};
    static double[][] gks = new double[][]{{0.27901, 0.44198, 0.27901}, {0.135336, 0.228569, 0.272192, 0.228569, 0.135336}, {0.086776, 0.136394, 0.178908, 0.195843, 0.178908, 0.136394, 0.086776}, {0.063327, 0.093095, 0.122589, 0.144599, 0.152781, 0.144599, 0.122589, 0.093095, 0.063327}, {0.049692, 0.069304, 0.089767, 0.107988, 0.120651, 0.125194, 0.120651, 0.107988, 0.089767, 0.069304, 0.049692}};

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("ERROR: there's no input filename. Basic usage: \r\n\r\njava -jar ImageTracer.jar <filename>\r\n\r\nor\r\n\r\njava -jar ImageTracer.jar help");
            } else if (ImageTracer.arraycontains(args, "help") > -1) {
                System.out.println("Example usage:\r\n\r\njava -jar ImageTracer.jar <filename> outfilename test.svg ltres 1 qtres 1 pathomit 8 colorsampling 1 numberofcolors 16 mincolorratio 0.02 colorquantcycles 3 scale 1 simplifytolerance 0 roundcoords 1 lcpr 0 qcpr 0 desc 1 viewbox 0 blurradius 0 blurdelta 20 \r\n\r\nOnly <filename> is mandatory, if some of the other optional parameters are missing, they will be set to these defaults. \r\nWarning: if outfilename is not specified, then <filename>.svg will be overwritten.\r\nSee https://github.com/jankovicsandras/imagetracerjava for details. \r\nThis is version " + versionnumber);
            } else {
                String outfilename = args[0] + ".svg";
                HashMap<String, Float> options = new HashMap<String, Float>();
                String[] parameternames = new String[]{"ltres", "qtres", "pathomit", "colorsampling", "numberofcolors", "mincolorratio", "colorquantcycles", "scale", "simplifytolerance", "roundcoords", "lcpr", "qcpr", "desc", "viewbox", "blurradius", "blurdelta", "outfilename"};
                int j = -1;
                float f = -1.0f;
                for (String parametername : parameternames) {
                    j = ImageTracer.arraycontains(args, parametername);
                    if (j <= -1) continue;
                    if (parametername == "outfilename") {
                        if (j >= args.length - 1) continue;
                        outfilename = args[j + 1];
                        continue;
                    }
                    f = ImageTracer.parsenext(args, j);
                    if (!(f > -1.0f)) continue;
                    options.put(parametername, new Float(f));
                }
                ImageTracer.saveString(outfilename, ImageTracer.imageToSVG(args[0], options, (byte[][])null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int arraycontains(String[] arr, String str) {
        for (int j = 0; j < arr.length; ++j) {
            if (!arr[j].toLowerCase().equals(str)) continue;
            return j;
        }
        return -1;
    }

    public static float parsenext(String[] arr, int i) {
        if (i < arr.length - 1) {
            try {
                return Float.parseFloat(arr[i + 1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1.0f;
    }

    public static void saveString(String filename, String str) throws Exception {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(str);
        bw.close();
    }

    public static ImageData loadImageData(String filename) throws Exception {
        BufferedImage image = ImageIO.read(new File(filename));
        return ImageTracer.loadImageData(image);
    }

    public static ImageData loadImageData(BufferedImage image) throws Exception {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rawdata = image.getRGB(0, 0, width, height, null, 0, width);
        byte[] data = new byte[rawdata.length * 4];
        for (int i = 0; i < rawdata.length; ++i) {
            data[i * 4 + 3] = ImageTracer.bytetrans((byte)(rawdata[i] >>> 24));
            data[i * 4] = ImageTracer.bytetrans((byte)(rawdata[i] >>> 16));
            data[i * 4 + 1] = ImageTracer.bytetrans((byte)(rawdata[i] >>> 8));
            data[i * 4 + 2] = ImageTracer.bytetrans((byte)rawdata[i]);
        }
        return new ImageData(width, height, data);
    }

    public static byte bytetrans(byte b) {
        if (b < 0) {
            return (byte)(b + 128);
        }
        return (byte)(b - 128);
    }

    public static String imageToSVG(String filename, HashMap<String, Float> options, byte[][] palette) throws Exception {
        options = ImageTracer.checkoptions(options);
        ImageData imgd = ImageTracer.loadImageData(filename);
        return ImageTracer.imagedataToSVG(imgd, options, palette);
    }

    public static String imageToSVG(BufferedImage image, HashMap<String, Float> options, byte[][] palette) throws Exception {
        options = ImageTracer.checkoptions(options);
        ImageData imgd = ImageTracer.loadImageData(image);
        return ImageTracer.imagedataToSVG(imgd, options, palette);
    }

    public static String imagedataToSVG(ImageData imgd, HashMap<String, Float> options, byte[][] palette) {
        options = ImageTracer.checkoptions(options);
        IndexedImage ii = ImageTracer.imagedataToTracedata(imgd, options, palette);
        return ImageTracer.getsvgstring(ii, options);
    }

    public IndexedImage imageToTracedata(String filename, HashMap<String, Float> options, byte[][] palette) throws Exception {
        options = ImageTracer.checkoptions(options);
        ImageData imgd = ImageTracer.loadImageData(filename);
        return ImageTracer.imagedataToTracedata(imgd, options, palette);
    }

    public IndexedImage imageToTracedata(BufferedImage image, HashMap<String, Float> options, byte[][] palette) throws Exception {
        options = ImageTracer.checkoptions(options);
        ImageData imgd = ImageTracer.loadImageData(image);
        return ImageTracer.imagedataToTracedata(imgd, options, palette);
    }

    public static IndexedImage imagedataToTracedata(ImageData imgd, HashMap<String, Float> options, byte[][] palette) {
        IndexedImage ii = ImageTracer.colorquantization(imgd, palette, options);
        int[][][] rawlayers = ImageTracer.layering(ii);
        ArrayList<ArrayList<ArrayList<Integer[]>>> bps = ImageTracer.batchpathscan(rawlayers, (int)Math.floor(options.get("pathomit").floatValue()));
        ArrayList<ArrayList<ArrayList<Double[]>>> bis = ImageTracer.batchinternodes(bps);
        ii.layers = ImageTracer.batchtracelayers(bis, options.get("ltres").floatValue(), options.get("qtres").floatValue());
        return ii;
    }

    public static HashMap<String, Float> checkoptions(HashMap<String, Float> options) {
        if (options == null) {
            options = new HashMap();
        }
        if (!options.containsKey("ltres")) {
            options.put("ltres", Float.valueOf(1.0f));
        }
        if (!options.containsKey("qtres")) {
            options.put("qtres", Float.valueOf(1.0f));
        }
        if (!options.containsKey("pathomit")) {
            options.put("pathomit", Float.valueOf(8.0f));
        }
        if (!options.containsKey("colorsampling")) {
            options.put("colorsampling", Float.valueOf(1.0f));
        }
        if (!options.containsKey("numberofcolors")) {
            options.put("numberofcolors", Float.valueOf(16.0f));
        }
        if (!options.containsKey("mincolorratio")) {
            options.put("mincolorratio", Float.valueOf(0.02f));
        }
        if (!options.containsKey("colorquantcycles")) {
            options.put("colorquantcycles", Float.valueOf(3.0f));
        }
        if (!options.containsKey("scale")) {
            options.put("scale", Float.valueOf(1.0f));
        }
        if (!options.containsKey("simplifytolerance")) {
            options.put("simplifytolerance", Float.valueOf(0.0f));
        }
        if (!options.containsKey("roundcoords")) {
            options.put("roundcoords", Float.valueOf(1.0f));
        }
        if (!options.containsKey("lcpr")) {
            options.put("lcpr", Float.valueOf(0.0f));
        }
        if (!options.containsKey("qcpr")) {
            options.put("qcpr", Float.valueOf(0.0f));
        }
        if (!options.containsKey("desc")) {
            options.put("desc", Float.valueOf(1.0f));
        }
        if (!options.containsKey("viewbox")) {
            options.put("viewbox", Float.valueOf(0.0f));
        }
        if (!options.containsKey("blurradius")) {
            options.put("blurradius", Float.valueOf(0.0f));
        }
        if (!options.containsKey("blurdelta")) {
            options.put("blurdelta", Float.valueOf(20.0f));
        }
        return options;
    }

    public static IndexedImage colorquantization(ImageData imgd, byte[][] palette, HashMap<String, Float> options) {
        int numberofcolors = (int)Math.floor(options.get("numberofcolors").floatValue());
        float minratio = options.get("mincolorratio").floatValue();
        int cycles = (int)Math.floor(options.get("colorquantcycles").floatValue());
        int[][] arr = new int[imgd.height + 2][imgd.width + 2];
        for (int j = 0; j < imgd.height + 2; ++j) {
            arr[j][0] = -1;
            arr[j][imgd.width + 1] = -1;
        }
        for (int i = 0; i < imgd.width + 2; ++i) {
            arr[0][i] = -1;
            arr[imgd.height + 1][i] = -1;
        }
        int idx = 0;
        if (palette == null) {
            palette = options.get("colorsampling").floatValue() != 0.0f ? ImageTracer.samplepalette(numberofcolors, imgd) : ImageTracer.generatepalette(numberofcolors);
        }
        if (options.get("blurradius").floatValue() > 0.0f) {
            imgd = ImageTracer.blur(imgd, options.get("blurradius").floatValue(), options.get("blurdelta").floatValue());
        }
        long[][] paletteacc = new long[palette.length][5];
        for (int cnt = 0; cnt < cycles; ++cnt) {
            if (cnt > 0) {
                for (int k = 0; k < palette.length; ++k) {
                    float ratio;
                    if (paletteacc[k][3] > 0L) {
                        palette[k][0] = (byte)(-128L + paletteacc[k][0] / paletteacc[k][4]);
                        palette[k][1] = (byte)(-128L + paletteacc[k][1] / paletteacc[k][4]);
                        palette[k][2] = (byte)(-128L + paletteacc[k][2] / paletteacc[k][4]);
                        palette[k][3] = (byte)(-128L + paletteacc[k][3] / paletteacc[k][4]);
                    }
                    if (!((ratio = (float)((double)paletteacc[k][4] / (double)(imgd.width * imgd.height))) < minratio) || cnt >= cycles - 1) continue;
                    palette[k][0] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                    palette[k][1] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                    palette[k][2] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                    palette[k][3] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                }
            }
            for (int i = 0; i < palette.length; ++i) {
                paletteacc[i][0] = 0L;
                paletteacc[i][1] = 0L;
                paletteacc[i][2] = 0L;
                paletteacc[i][3] = 0L;
                paletteacc[i][4] = 0L;
            }
            for (int j = 0; j < imgd.height; ++j) {
                for (int i = 0; i < imgd.width; ++i) {
                    idx = (j * imgd.width + i) * 4;
                    int cdl = 1024;
                    int ci = 0;
                    for (int k = 0; k < palette.length; ++k) {
                        int c4;
                        int c3;
                        int c2;
                        int c1 = Math.abs(palette[k][0] - imgd.data[idx]);
                        int cd = c1 + (c2 = Math.abs(palette[k][1] - imgd.data[idx + 1])) + (c3 = Math.abs(palette[k][2] - imgd.data[idx + 2])) + (c4 = Math.abs(palette[k][3] - imgd.data[idx + 3])) * 4;
                        if (cd >= cdl) continue;
                        cdl = cd;
                        ci = k;
                    }
                    long[] lArray = paletteacc[ci];
                    lArray[0] = lArray[0] + (long)(128 + imgd.data[idx]);
                    long[] lArray2 = paletteacc[ci];
                    lArray2[1] = lArray2[1] + (long)(128 + imgd.data[idx + 1]);
                    long[] lArray3 = paletteacc[ci];
                    lArray3[2] = lArray3[2] + (long)(128 + imgd.data[idx + 2]);
                    long[] lArray4 = paletteacc[ci];
                    lArray4[3] = lArray4[3] + (long)(128 + imgd.data[idx + 3]);
                    long[] lArray5 = paletteacc[ci];
                    lArray5[4] = lArray5[4] + 1L;
                    arr[j + 1][i + 1] = ci;
                }
            }
        }
        return new IndexedImage(arr, palette);
    }

    public static byte[][] generatepalette(int numberofcolors) {
        byte[][] palette = new byte[numberofcolors][4];
        if (numberofcolors < 8) {
            double graystep = 255.0 / (double)(numberofcolors - 1);
            for (int ccnt = 0; ccnt < numberofcolors; ccnt = (int)((byte)(ccnt + 1))) {
                palette[ccnt][0] = (byte)(-128L + Math.round((double)ccnt * graystep));
                palette[ccnt][1] = (byte)(-128L + Math.round((double)ccnt * graystep));
                palette[ccnt][2] = (byte)(-128L + Math.round((double)ccnt * graystep));
                palette[ccnt][3] = 127;
            }
        } else {
            int rcnt;
            int colorqnum = (int)Math.floor(Math.pow(numberofcolors, 0.3333333333333333));
            int colorstep = (int)Math.floor(255 / (colorqnum - 1));
            int ccnt = 0;
            for (rcnt = 0; rcnt < colorqnum; ++rcnt) {
                for (int gcnt = 0; gcnt < colorqnum; ++gcnt) {
                    for (int bcnt = 0; bcnt < colorqnum; ++bcnt) {
                        palette[ccnt][0] = (byte)(-128 + rcnt * colorstep);
                        palette[ccnt][1] = (byte)(-128 + gcnt * colorstep);
                        palette[ccnt][2] = (byte)(-128 + bcnt * colorstep);
                        palette[ccnt][3] = 127;
                        ++ccnt;
                    }
                }
            }
            for (rcnt = ccnt; rcnt < numberofcolors; ++rcnt) {
                palette[ccnt][0] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                palette[ccnt][1] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                palette[ccnt][2] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
                palette[ccnt][3] = (byte)(-128.0 + Math.floor(Math.random() * 255.0));
            }
        }
        return palette;
    }

    public static byte[][] samplepalette(int numberofcolors, ImageData imgd) {
        int idx = 0;
        byte[][] palette = new byte[numberofcolors][4];
        for (int i = 0; i < numberofcolors; ++i) {
            idx = (int)(Math.floor(Math.random() * (double)imgd.data.length / 4.0) * 4.0);
            palette[i][0] = imgd.data[idx];
            palette[i][1] = imgd.data[idx + 1];
            palette[i][2] = imgd.data[idx + 2];
            palette[i][3] = imgd.data[idx + 3];
        }
        return palette;
    }

    public static int[][][] layering(IndexedImage ii) {
        int val = 0;
        int aw = ii.array[0].length;
        int ah = ii.array.length;
        int[][][] layers = new int[ii.palette.length][ah][aw];
        for (int j = 1; j < ah - 1; ++j) {
            for (int i = 1; i < aw - 1; ++i) {
                val = ii.array[j][i];
                boolean n1 = ii.array[j - 1][i - 1] == val;
                int n2 = ii.array[j - 1][i] == val ? 1 : 0;
                int n3 = ii.array[j - 1][i + 1] == val ? 1 : 0;
                int n4 = ii.array[j][i - 1] == val ? 1 : 0;
                int n5 = ii.array[j][i + 1] == val ? 1 : 0;
                int n6 = ii.array[j + 1][i - 1] == val ? 1 : 0;
                int n7 = ii.array[j + 1][i] == val ? 1 : 0;
                int n8 = ii.array[j + 1][i + 1] == val ? 1 : 0;
                layers[val][j + 1][i + 1] = 1 + n5 * 2 + n8 * 4 + n7 * 8;
                if (n4 == 0) {
                    layers[val][j + 1][i] = 2 + n7 * 4 + n6 * 8;
                }
                if (n2 == 0) {
                    layers[val][j][i + 1] = 0 + n3 * 2 + n5 * 4 + 8;
                }
                if (n1) continue;
                layers[val][j][i] = 0 + n2 * 2 + 4 + n4 * 8;
            }
        }
        return layers;
    }

    public static ArrayList<ArrayList<Integer[]>> pathscan(int[][] arr, float pathomit) {
        ArrayList<ArrayList<Integer[]>> paths = new ArrayList<ArrayList<Integer[]>>();
        int px = 0;
        int py = 0;
        int w = arr[0].length;
        int h = arr.length;
        byte dir = 0;
        boolean pathfinished = true;
        boolean holepath = false;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (arr[j][i] == 0 || arr[j][i] == 15) continue;
                px = i;
                py = j;
                paths.add(new ArrayList());
                ArrayList<Integer[]> thispath = paths.get(paths.size() - 1);
                pathfinished = false;
                dir = pathscan_dir_lookup[arr[py][px]];
                holepath = pathscan_holepath_lookup[arr[py][px]];
                while (!pathfinished) {
                    thispath.add(new Integer[3]);
                    thispath.get((int)(thispath.size() - 1))[0] = px - 1;
                    thispath.get((int)(thispath.size() - 1))[1] = py - 1;
                    thispath.get((int)(thispath.size() - 1))[2] = arr[py][px];
                    byte[] lookuprow = pathscan_combined_lookup[arr[py][px]][dir];
                    arr[py][px] = lookuprow[0];
                    dir = lookuprow[1];
                    if ((px += lookuprow[2]) - 1 != thispath.get(0)[0] || (py += lookuprow[3]) - 1 != thispath.get(0)[1]) continue;
                    pathfinished = true;
                    if (!holepath && !((float)thispath.size() < pathomit)) continue;
                    paths.remove(thispath);
                }
            }
        }
        return paths;
    }

    public static ArrayList<ArrayList<ArrayList<Integer[]>>> batchpathscan(int[][][] layers, float pathomit) {
        ArrayList<ArrayList<ArrayList<Integer[]>>> bpaths = new ArrayList<ArrayList<ArrayList<Integer[]>>>();
        for (int[][] layer : layers) {
            bpaths.add(ImageTracer.pathscan(layer, pathomit));
        }
        return bpaths;
    }

    public static ArrayList<ArrayList<Double[]>> internodes(ArrayList<ArrayList<Integer[]>> paths) {
        ArrayList<ArrayList<Double[]>> ins = new ArrayList<ArrayList<Double[]>>();
        Double[] nextpoint = new Double[2];
        int palen = 0;
        int nextidx = 0;
        int nextidx2 = 0;
        for (int pacnt = 0; pacnt < paths.size(); ++pacnt) {
            ins.add(new ArrayList());
            ArrayList<Double[]> thisinp = ins.get(ins.size() - 1);
            palen = paths.get(pacnt).size();
            for (int pcnt = 0; pcnt < palen; ++pcnt) {
                nextidx = (pcnt + 1) % palen;
                nextidx2 = (pcnt + 2) % palen;
                thisinp.add(new Double[3]);
                Double[] thispoint = thisinp.get(thisinp.size() - 1);
                Integer[] pp1 = paths.get(pacnt).get(pcnt);
                Integer[] pp2 = paths.get(pacnt).get(nextidx);
                Integer[] pp3 = paths.get(pacnt).get(nextidx2);
                thispoint[0] = (double)(pp1[0] + pp2[0]) / 2.0;
                thispoint[1] = (double)(pp1[1] + pp2[1]) / 2.0;
                nextpoint[0] = (double)(pp2[0] + pp3[0]) / 2.0;
                nextpoint[1] = (double)(pp2[1] + pp3[1]) / 2.0;
                if (thispoint[0] < nextpoint[0]) {
                    if (thispoint[1] < nextpoint[1]) {
                        thispoint[2] = 1.0;
                        continue;
                    }
                    if (thispoint[1] > nextpoint[1]) {
                        thispoint[2] = 7.0;
                        continue;
                    }
                    thispoint[2] = 0.0;
                    continue;
                }
                if (thispoint[0] > nextpoint[0]) {
                    if (thispoint[1] < nextpoint[1]) {
                        thispoint[2] = 3.0;
                        continue;
                    }
                    if (thispoint[1] > nextpoint[1]) {
                        thispoint[2] = 5.0;
                        continue;
                    }
                    thispoint[2] = 4.0;
                    continue;
                }
                thispoint[2] = thispoint[1] < nextpoint[1] ? Double.valueOf(2.0) : (thispoint[1] > nextpoint[1] ? Double.valueOf(6.0) : Double.valueOf(8.0));
            }
        }
        return ins;
    }

    static ArrayList<ArrayList<ArrayList<Double[]>>> batchinternodes(ArrayList<ArrayList<ArrayList<Integer[]>>> bpaths) {
        ArrayList<ArrayList<ArrayList<Double[]>>> binternodes = new ArrayList<ArrayList<ArrayList<Double[]>>>();
        for (int k = 0; k < bpaths.size(); ++k) {
            binternodes.add(ImageTracer.internodes(bpaths.get(k)));
        }
        return binternodes;
    }

    public static ArrayList<Double[]> tracepath(ArrayList<Double[]> path, float ltreshold, float qtreshold) {
        int pcnt = 0;
        int seqend = 0;
        ArrayList<Double[]> smp = new ArrayList<Double[]>();
        int pathlength = path.size();
        while (pcnt < pathlength) {
            double segtype1 = path.get(pcnt)[2];
            double segtype2 = -1.0;
            for (seqend = pcnt + 1; (path.get(seqend)[2] == segtype1 || path.get(seqend)[2] == segtype2 || segtype2 == -1.0) && seqend < pathlength - 1; ++seqend) {
                if (path.get(seqend)[2] == segtype1 || segtype2 != -1.0) continue;
                segtype2 = path.get(seqend)[2];
            }
            if (seqend == pathlength - 1) {
                seqend = 0;
            }
            smp.addAll(ImageTracer.fitseq(path, ltreshold, qtreshold, pcnt, seqend));
            if (seqend > 0) {
                pcnt = seqend;
                continue;
            }
            pcnt = pathlength;
        }
        return smp;
    }

    public static ArrayList<Double[]> fitseq(ArrayList<Double[]> path, float ltreshold, float qtreshold, int seqstart, int seqend) {
        double dist2;
        double py;
        double px;
        ArrayList<Double[]> segment = new ArrayList<Double[]>();
        int pathlength = path.size();
        if (seqend > pathlength || seqend < 0) {
            return segment;
        }
        int errorpoint = seqstart;
        boolean curvepass = true;
        double errorval = 0.0;
        double tl = seqend - seqstart;
        if (tl < 0.0) {
            tl += (double)pathlength;
        }
        double vx = (path.get(seqend)[0] - path.get(seqstart)[0]) / tl;
        double vy = (path.get(seqend)[1] - path.get(seqstart)[1]) / tl;
        int pcnt = (seqstart + 1) % pathlength;
        while (pcnt != seqend) {
            double pl = pcnt - seqstart;
            if (pl < 0.0) {
                pl += (double)pathlength;
            }
            px = path.get(seqstart)[0] + vx * pl;
            py = path.get(seqstart)[1] + vy * pl;
            dist2 = (path.get(pcnt)[0] - px) * (path.get(pcnt)[0] - px) + (path.get(pcnt)[1] - py) * (path.get(pcnt)[1] - py);
            if (dist2 > (double)ltreshold) {
                curvepass = false;
            }
            if (dist2 > errorval) {
                errorpoint = pcnt;
                errorval = dist2;
            }
            pcnt = (pcnt + 1) % pathlength;
        }
        if (curvepass) {
            segment.add(new Double[7]);
            Double[] thissegment = segment.get(segment.size() - 1);
            thissegment[0] = 1.0;
            thissegment[1] = path.get(seqstart)[0];
            thissegment[2] = path.get(seqstart)[1];
            thissegment[3] = path.get(seqend)[0];
            thissegment[4] = path.get(seqend)[1];
            thissegment[5] = 0.0;
            thissegment[6] = 0.0;
            return segment;
        }
        int fitpoint = errorpoint;
        curvepass = true;
        errorval = 0.0;
        double t = (double)(fitpoint - seqstart) / tl;
        double t1 = (1.0 - t) * (1.0 - t);
        double t2 = 2.0 * (1.0 - t) * t;
        double t3 = t * t;
        double cpx = (t1 * path.get(seqstart)[0] + t3 * path.get(seqend)[0] - path.get(fitpoint)[0]) / -t2;
        double cpy = (t1 * path.get(seqstart)[1] + t3 * path.get(seqend)[1] - path.get(fitpoint)[1]) / -t2;
        pcnt = seqstart + 1;
        while (pcnt != seqend) {
            t = (double)(pcnt - seqstart) / tl;
            t1 = (1.0 - t) * (1.0 - t);
            t2 = 2.0 * (1.0 - t) * t;
            t3 = t * t;
            px = t1 * path.get(seqstart)[0] + t2 * cpx + t3 * path.get(seqend)[0];
            py = t1 * path.get(seqstart)[1] + t2 * cpy + t3 * path.get(seqend)[1];
            dist2 = (path.get(pcnt)[0] - px) * (path.get(pcnt)[0] - px) + (path.get(pcnt)[1] - py) * (path.get(pcnt)[1] - py);
            if (dist2 > (double)qtreshold) {
                curvepass = false;
            }
            if (dist2 > errorval) {
                errorpoint = pcnt;
                errorval = dist2;
            }
            pcnt = (pcnt + 1) % pathlength;
        }
        if (curvepass) {
            segment.add(new Double[7]);
            Double[] thissegment = segment.get(segment.size() - 1);
            thissegment[0] = 2.0;
            thissegment[1] = path.get(seqstart)[0];
            thissegment[2] = path.get(seqstart)[1];
            thissegment[3] = cpx;
            thissegment[4] = cpy;
            thissegment[5] = path.get(seqend)[0];
            thissegment[6] = path.get(seqend)[1];
            return segment;
        }
        int splitpoint = (fitpoint + errorpoint) / 2;
        segment = ImageTracer.fitseq(path, ltreshold, qtreshold, seqstart, splitpoint);
        segment.addAll(ImageTracer.fitseq(path, ltreshold, qtreshold, splitpoint, seqend));
        return segment;
    }

    public static ArrayList<ArrayList<Double[]>> batchtracepaths(ArrayList<ArrayList<Double[]>> internodepaths, float ltres, float qtres) {
        ArrayList<ArrayList<Double[]>> btracedpaths = new ArrayList<ArrayList<Double[]>>();
        for (int k = 0; k < internodepaths.size(); ++k) {
            btracedpaths.add(ImageTracer.tracepath(internodepaths.get(k), ltres, qtres));
        }
        return btracedpaths;
    }

    public static ArrayList<ArrayList<ArrayList<Double[]>>> batchtracelayers(ArrayList<ArrayList<ArrayList<Double[]>>> binternodes, float ltres, float qtres) {
        ArrayList<ArrayList<ArrayList<Double[]>>> btbis = new ArrayList<ArrayList<ArrayList<Double[]>>>();
        for (int k = 0; k < binternodes.size(); ++k) {
            btbis.add(ImageTracer.batchtracepaths(binternodes.get(k), ltres, qtres));
        }
        return btbis;
    }

    public static float roundtodec(float val, float places) {
        return (float)((double)Math.round((double)val * Math.pow(10.0, places)) / Math.pow(10.0, places));
    }

    public static void svgpathstring(StringBuilder sb, String desc, ArrayList<Double[]> segments, String colorstr, HashMap<String, Float> options) {
        int pcnt;
        float scale = options.get("scale").floatValue();
        float lcpr = options.get("lcpr").floatValue();
        float qcpr = options.get("qcpr").floatValue();
        float roundcoords = (float)Math.floor(options.get("roundcoords").floatValue());
        sb.append("<path ").append(desc).append(colorstr).append("d=\"").append("M ").append(segments.get(0)[1] * (double)scale).append(" ").append(segments.get(0)[2] * (double)scale).append(" ");
        if (roundcoords == -1.0f) {
            for (pcnt = 0; pcnt < segments.size(); ++pcnt) {
                if (segments.get(pcnt)[0] == 1.0) {
                    sb.append("L ").append(segments.get(pcnt)[3] * (double)scale).append(" ").append(segments.get(pcnt)[4] * (double)scale).append(" ");
                    continue;
                }
                sb.append("Q ").append(segments.get(pcnt)[3] * (double)scale).append(" ").append(segments.get(pcnt)[4] * (double)scale).append(" ").append(segments.get(pcnt)[5] * (double)scale).append(" ").append(segments.get(pcnt)[6] * (double)scale).append(" ");
            }
        } else {
            for (pcnt = 0; pcnt < segments.size(); ++pcnt) {
                if (segments.get(pcnt)[0] == 1.0) {
                    sb.append("L ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[3] * (double)scale), roundcoords)).append(" ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[4] * (double)scale), roundcoords)).append(" ");
                    continue;
                }
                sb.append("Q ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[3] * (double)scale), roundcoords)).append(" ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[4] * (double)scale), roundcoords)).append(" ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[5] * (double)scale), roundcoords)).append(" ").append(ImageTracer.roundtodec((float)(segments.get(pcnt)[6] * (double)scale), roundcoords)).append(" ");
            }
        }
        sb.append("Z\" />");
        for (pcnt = 0; pcnt < segments.size(); ++pcnt) {
            if (lcpr > 0.0f && segments.get(pcnt)[0] == 1.0) {
                sb.append("<circle cx=\"").append(segments.get(pcnt)[3] * (double)scale).append("\" cy=\"").append(segments.get(pcnt)[4] * (double)scale).append("\" r=\"").append(lcpr).append("\" fill=\"white\" stroke-width=\"").append((double)lcpr * 0.2).append("\" stroke=\"black\" />");
            }
            if (!(qcpr > 0.0f) || segments.get(pcnt)[0] != 2.0) continue;
            sb.append("<circle cx=\"").append(segments.get(pcnt)[3] * (double)scale).append("\" cy=\"").append(segments.get(pcnt)[4] * (double)scale).append("\" r=\"").append(qcpr).append("\" fill=\"cyan\" stroke-width=\"").append((double)qcpr * 0.2).append("\" stroke=\"black\" />");
            sb.append("<circle cx=\"").append(segments.get(pcnt)[5] * (double)scale).append("\" cy=\"").append(segments.get(pcnt)[6] * (double)scale).append("\" r=\"").append(qcpr).append("\" fill=\"white\" stroke-width=\"").append((double)qcpr * 0.2).append("\" stroke=\"black\" />");
            sb.append("<line x1=\"").append(segments.get(pcnt)[1] * (double)scale).append("\" y1=\"").append(segments.get(pcnt)[2] * (double)scale).append("\" x2=\"").append(segments.get(pcnt)[3] * (double)scale).append("\" y2=\"").append(segments.get(pcnt)[4] * (double)scale).append("\" stroke-width=\"").append((double)qcpr * 0.2).append("\" stroke=\"cyan\" />");
            sb.append("<line x1=\"").append(segments.get(pcnt)[3] * (double)scale).append("\" y1=\"").append(segments.get(pcnt)[4] * (double)scale).append("\" x2=\"").append(segments.get(pcnt)[5] * (double)scale).append("\" y2=\"").append(segments.get(pcnt)[6] * (double)scale).append("\" stroke-width=\"").append((double)qcpr * 0.2).append("\" stroke=\"cyan\" />");
        }
    }

    public static String getsvgstring(IndexedImage ii, HashMap<String, Float> options) {
        options = ImageTracer.checkoptions(options);
        int w = (int)((float)ii.width * options.get("scale").floatValue());
        int h = (int)((float)ii.height * options.get("scale").floatValue());
        String viewboxorviewport = options.get("viewbox").floatValue() != 0.0f ? "viewBox=\"0 0 " + w + " " + h + "\" " : "width=\"" + w + "\" height=\"" + h + "\" ";
        StringBuilder svgstr = new StringBuilder("<svg " + viewboxorviewport + "version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" ");
        if (options.get("desc").floatValue() != 0.0f) {
            svgstr.append("desc=\"Created with ImageTracer.java version " + versionnumber + "\" ");
        }
        svgstr.append(">");
        TreeMap<Double, Integer[]> zindex = new TreeMap<Double, Integer[]>();
        for (int k = 0; k < ii.layers.size(); ++k) {
            for (int pcnt = 0; pcnt < ii.layers.get(k).size(); ++pcnt) {
                double label = ii.layers.get(k).get(pcnt).get(0)[2] * (double)w + ii.layers.get(k).get(pcnt).get(0)[1];
                if (!zindex.containsKey(label)) {
                    zindex.put(label, new Integer[2]);
                }
                ((Integer[])zindex.get((Object)Double.valueOf((double)label)))[0] = new Integer(k);
                ((Integer[])zindex.get((Object)Double.valueOf((double)label)))[1] = new Integer(pcnt);
            }
        }
        String thisdesc = "";
        for (Map.Entry entry : zindex.entrySet()) {
            thisdesc = options.get("desc").floatValue() != 0.0f ? "desc=\"l " + ((Integer[])entry.getValue())[0] + " p " + ((Integer[])entry.getValue())[1] + "\" " : "";
            ImageTracer.svgpathstring(svgstr, thisdesc, ii.layers.get(((Integer[])entry.getValue())[0]).get(((Integer[])entry.getValue())[1]), ImageTracer.tosvgcolorstr(ii.palette[((Integer[])entry.getValue())[0]]), options);
        }
        svgstr.append("</svg>");
        return svgstr.toString();
    }

    static String tosvgcolorstr(byte[] c) {
        return "fill=\"rgb(" + (c[0] + 128) + "," + (c[1] + 128) + "," + (c[2] + 128) + ")\" stroke=\"rgb(" + (c[0] + 128) + "," + (c[1] + 128) + "," + (c[2] + 128) + ")\" stroke-width=\"1\" opacity=\"" + (double)(c[3] + 128) / 255.0 + "\" ";
    }

    static ImageData blur(ImageData imgd, float rad, float del) {
        int idx;
        int k;
        double wacc;
        double aacc;
        double bacc;
        double gacc;
        double racc;
        int i;
        int j;
        int delta;
        ImageData imgd2 = new ImageData(imgd.width, imgd.height, new byte[imgd.width * imgd.height * 4]);
        int radius = (int)Math.floor(rad);
        if (radius < 1) {
            return imgd;
        }
        if (radius > 5) {
            radius = 5;
        }
        if ((delta = (int)Math.abs(del)) > 1024) {
            delta = 1024;
        }
        double[] thisgk = gks[radius - 1];
        for (j = 0; j < imgd.height; ++j) {
            for (i = 0; i < imgd.width; ++i) {
                racc = 0.0;
                gacc = 0.0;
                bacc = 0.0;
                aacc = 0.0;
                wacc = 0.0;
                for (k = -radius; k < radius + 1; ++k) {
                    if (i + k <= 0 || i + k >= imgd.width) continue;
                    idx = (j * imgd.width + i + k) * 4;
                    racc += (double)imgd.data[idx] * thisgk[k + radius];
                    gacc += (double)imgd.data[idx + 1] * thisgk[k + radius];
                    bacc += (double)imgd.data[idx + 2] * thisgk[k + radius];
                    aacc += (double)imgd.data[idx + 3] * thisgk[k + radius];
                    wacc += thisgk[k + radius];
                }
                idx = (j * imgd.width + i) * 4;
                imgd2.data[idx] = (byte)Math.floor(racc / wacc);
                imgd2.data[idx + 1] = (byte)Math.floor(gacc / wacc);
                imgd2.data[idx + 2] = (byte)Math.floor(bacc / wacc);
                imgd2.data[idx + 3] = (byte)Math.floor(aacc / wacc);
            }
        }
        byte[] himgd = (byte[])imgd2.data.clone();
        for (j = 0; j < imgd.height; ++j) {
            for (i = 0; i < imgd.width; ++i) {
                racc = 0.0;
                gacc = 0.0;
                bacc = 0.0;
                aacc = 0.0;
                wacc = 0.0;
                for (k = -radius; k < radius + 1; ++k) {
                    if (j + k <= 0 || j + k >= imgd.height) continue;
                    idx = ((j + k) * imgd.width + i) * 4;
                    racc += (double)himgd[idx] * thisgk[k + radius];
                    gacc += (double)himgd[idx + 1] * thisgk[k + radius];
                    bacc += (double)himgd[idx + 2] * thisgk[k + radius];
                    aacc += (double)himgd[idx + 3] * thisgk[k + radius];
                    wacc += thisgk[k + radius];
                }
                idx = (j * imgd.width + i) * 4;
                imgd2.data[idx] = (byte)Math.floor(racc / wacc);
                imgd2.data[idx + 1] = (byte)Math.floor(gacc / wacc);
                imgd2.data[idx + 2] = (byte)Math.floor(bacc / wacc);
                imgd2.data[idx + 3] = (byte)Math.floor(aacc / wacc);
            }
        }
        for (j = 0; j < imgd.height; ++j) {
            for (i = 0; i < imgd.width; ++i) {
                idx = (j * imgd.width + i) * 4;
                int d = Math.abs(imgd2.data[idx] - imgd.data[idx]) + Math.abs(imgd2.data[idx + 1] - imgd.data[idx + 1]) + Math.abs(imgd2.data[idx + 2] - imgd.data[idx + 2]) + Math.abs(imgd2.data[idx + 3] - imgd.data[idx + 3]);
                if (d <= delta) continue;
                imgd2.data[idx] = imgd.data[idx];
                imgd2.data[idx + 1] = imgd.data[idx + 1];
                imgd2.data[idx + 2] = imgd.data[idx + 2];
                imgd2.data[idx + 3] = imgd.data[idx + 3];
            }
        }
        return imgd2;
    }

    public static class ImageData {
        public int width;
        public int height;
        public byte[] data;

        public ImageData(int mwidth, int mheight, byte[] mdata) {
            this.width = mwidth;
            this.height = mheight;
            this.data = mdata;
        }
    }

    public static class IndexedImage {
        public int width;
        public int height;
        public int[][] array;
        public byte[][] palette;
        public ArrayList<ArrayList<ArrayList<Double[]>>> layers;

        public IndexedImage(int[][] marray, byte[][] mpalette) {
            this.array = marray;
            this.palette = mpalette;
            this.width = marray[0].length - 2;
            this.height = marray.length - 2;
        }
    }
}

