/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probreasoningtest;

import aima.probability.RandomVariable;
import aima.probability.reasoning.FixedLagSmoothing;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class HMMTest
extends TestCase {
    private HiddenMarkovModel robotHmm;
    private HiddenMarkovModel rainmanHmm;
    private static final double TOLERANCE = 0.001;

    @Override
    public void setUp() {
        this.robotHmm = HMMFactory.createRobotHMM();
        this.rainmanHmm = HMMFactory.createRainmanHMM();
    }

    public void testRobotHMMInitialization() {
        HMMTest.assertEquals(0.5, this.robotHmm.prior().getProbabilityOf("open"));
        HMMTest.assertEquals(0.5, this.robotHmm.prior().getProbabilityOf("closed"));
    }

    public void testRainmanHmmInitialization() {
        HMMTest.assertEquals(0.5, this.rainmanHmm.prior().getProbabilityOf("rain"));
        HMMTest.assertEquals(0.5, this.rainmanHmm.prior().getProbabilityOf("no_rain"));
    }

    public void testForwardMessagingWorksForFiltering() {
        RandomVariable afterOneStep = this.robotHmm.forward(this.robotHmm.prior(), "do_nothing", "see_open");
        HMMTest.assertEquals(0.75, afterOneStep.getProbabilityOf("open"), 0.001);
        HMMTest.assertEquals(0.25, afterOneStep.getProbabilityOf("closed"), 0.001);
        RandomVariable afterTwoSteps = this.robotHmm.forward(afterOneStep, "push", "see_open");
        HMMTest.assertEquals(0.983, afterTwoSteps.getProbabilityOf("open"), 0.001);
        HMMTest.assertEquals(0.017, afterTwoSteps.getProbabilityOf("closed"), 0.001);
    }

    public void testRecursiveBackwardMessageCalculationIsCorrect() {
        RandomVariable afterOneStep = this.rainmanHmm.forward(this.rainmanHmm.prior(), "do_nothing", "carries_umbrella");
        RandomVariable afterTwoSteps = this.rainmanHmm.forward(afterOneStep, "do_nothing", "carries_umbrella");
        RandomVariable postSequence = afterTwoSteps.duplicate().createUnitBelief();
        RandomVariable smoothed = this.rainmanHmm.calculate_next_backward_message(afterOneStep, postSequence, "carries_umbrella");
        HMMTest.assertEquals(0.883, smoothed.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.117, smoothed.getProbabilityOf("no_rain"), 0.001);
    }

    public void testForwardBackwardOnRainmanHmm() {
        ArrayList<String> perceptions = new ArrayList<String>();
        perceptions.add("carries_umbrella");
        perceptions.add("carries_umbrella");
        List<RandomVariable> results = this.rainmanHmm.forward_backward(perceptions);
        HMMTest.assertEquals(3, results.size());
        HMMTest.assertNull(results.get(0));
        RandomVariable smoothedDayOne = results.get(1);
        HMMTest.assertEquals(0.982, smoothedDayOne.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.018, smoothedDayOne.getProbabilityOf("no_rain"), 0.001);
        RandomVariable smoothedDayTwo = results.get(2);
        HMMTest.assertEquals(0.883, smoothedDayTwo.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.117, smoothedDayTwo.getProbabilityOf("no_rain"), 0.001);
    }

    public void testForwardBackwardOnRainmanHmmFor3daysData() {
        ArrayList<String> perceptions = new ArrayList<String>();
        perceptions.add("carries_umbrella");
        perceptions.add("carries_umbrella");
        perceptions.add("does_not_carry_umbrella");
        List<RandomVariable> results = this.rainmanHmm.forward_backward(perceptions);
        HMMTest.assertEquals(4, results.size());
        HMMTest.assertNull(results.get(0));
        RandomVariable smoothedDayOne = results.get(1);
        HMMTest.assertEquals(0.964, smoothedDayOne.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.036, smoothedDayOne.getProbabilityOf("no_rain"), 0.001);
        RandomVariable smoothedDayTwo = results.get(2);
        HMMTest.assertEquals(0.484, smoothedDayTwo.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.516, smoothedDayTwo.getProbabilityOf("no_rain"), 0.001);
        RandomVariable smoothedDayThree = results.get(3);
        HMMTest.assertEquals(0.19, smoothedDayThree.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.81, smoothedDayThree.getProbabilityOf("no_rain"), 0.001);
    }

    public void xtestForwardBackwardAndFixedLagSmoothingGiveSameResults() {
        ArrayList<String> perceptions = new ArrayList<String>();
        String dayOnePerception = "carries_umbrella";
        String dayTwoPerception = "carries_umbrella";
        String dayThreePerception = "does_not_carry_umbrella";
        perceptions.add(dayOnePerception);
        perceptions.add(dayTwoPerception);
        perceptions.add(dayThreePerception);
        List<RandomVariable> fbResults = this.rainmanHmm.forward_backward(perceptions);
        HMMTest.assertEquals(4, fbResults.size());
        RandomVariable fbDayOneResult = fbResults.get(1);
        System.out.println(fbDayOneResult);
        FixedLagSmoothing fls = new FixedLagSmoothing(this.rainmanHmm, 2);
        HMMTest.assertNull(fls.smooth(dayOnePerception));
        System.out.println(fls.smooth(dayTwoPerception));
        RandomVariable flsDayoneResult = fls.smooth(dayThreePerception);
        System.out.println(flsDayoneResult);
    }

    public void testOneStepFixedLagSmoothingOnRainManHmm() {
        FixedLagSmoothing fls = new FixedLagSmoothing(this.rainmanHmm, 1);
        RandomVariable smoothedDayZero = fls.smooth("carries_umbrella");
        HMMTest.assertEquals(0.627, smoothedDayZero.getProbabilityOf("rain"), 0.001);
        RandomVariable smoothedDayOne = fls.smooth("carries_umbrella");
        HMMTest.assertEquals(0.883, smoothedDayOne.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.117, smoothedDayOne.getProbabilityOf("no_rain"), 0.001);
        RandomVariable smoothedDayTwo = fls.smooth("does_not_carry_umbrella");
        HMMTest.assertEquals(0.799, smoothedDayTwo.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.201, smoothedDayTwo.getProbabilityOf("no_rain"), 0.001);
    }

    public void testOneStepFixedLagSmoothingOnRainManHmmWithDifferingEvidence() {
        FixedLagSmoothing fls = new FixedLagSmoothing(this.rainmanHmm, 1);
        RandomVariable smoothedDayZero = fls.smooth("carries_umbrella");
        HMMTest.assertEquals(0.627, smoothedDayZero.getProbabilityOf("rain"), 0.001);
        RandomVariable smoothedDayOne = fls.smooth("does_not_carry_umbrella");
        HMMTest.assertEquals(0.702, smoothedDayOne.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.297, smoothedDayOne.getProbabilityOf("no_rain"), 0.001);
    }

    public void testTwoStepFixedLagSmoothingOnRainManHmm() {
        FixedLagSmoothing fls = new FixedLagSmoothing(this.rainmanHmm, 2);
        RandomVariable smoothedOne = fls.smooth("carries_umbrella");
        HMMTest.assertNull(smoothedOne);
        smoothedOne = fls.smooth("carries_umbrella");
        HMMTest.assertEquals(0.653, smoothedOne.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.346, smoothedOne.getProbabilityOf("no_rain"), 0.001);
        RandomVariable smoothedTwo = fls.smooth("carries_umbrella");
        HMMTest.assertEquals(0.894, smoothedTwo.getProbabilityOf("rain"), 0.001);
        HMMTest.assertEquals(0.105, smoothedTwo.getProbabilityOf("no_rain"), 0.001);
    }
}

