/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.CNFConverter;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Sentence;
import junit.framework.TestCase;

public class CNFConverterTest
extends TestCase {
    public void testExamplePg295() {
        FOLDomain domain = DomainFactory.weaponsDomain();
        FOLParser parser = new FOLParser(domain);
        Sentence origSentence = parser.parse("FORALL x ((((American(x) AND Weapon(y)) AND Sells(x, y, z)) AND Hostile(z)) => Criminal(x))");
        CNFConverter cnfConv = new CNFConverter(parser);
        CNF cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~American(x), ~Hostile(z), ~Sells(x,y,z), ~Weapon(y), Criminal(x)]", cnf.toString());
    }

    public void testExamplePg296() {
        FOLDomain domain = DomainFactory.lovesAnimalDomain();
        FOLParser parser = new FOLParser(domain);
        Sentence origSentence = parser.parse("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        CNFConverter cnfConv = new CNFConverter(parser);
        CNF cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[Animal(SF0(x)), Loves(SF1(x),x)],[~Loves(x,SF0(x)), Loves(SF1(x),x)]", cnf.toString());
    }

    public void testExamplesPg299() {
        FOLDomain domain = DomainFactory.lovesAnimalDomain();
        FOLParser parser = new FOLParser(domain);
        Sentence origSentence = parser.parse("FORALL x (FORALL y (Animal(y) => Loves(x, y)) => EXISTS y Loves(y, x))");
        CNFConverter cnfConv = new CNFConverter(parser);
        CNF cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[Animal(SF0(x)), Loves(SF1(x),x)],[~Loves(x,SF0(x)), Loves(SF1(x),x)]", cnf.toString());
        origSentence = parser.parse("FORALL x (EXISTS y (Animal(y) AND Kills(x, y)) => FORALL z NOT(Loves(z, x)))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~Animal(y), ~Kills(x,y), ~Loves(z,x)]", cnf.toString());
        origSentence = parser.parse("FORALL x (Animal(x) => Loves(Jack, x))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~Animal(x), Loves(Jack,x)]", cnf.toString());
        origSentence = parser.parse("(Kills(Jack, Tuna) OR Kills(Curiosity, Tuna))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[Kills(Curiosity,Tuna), Kills(Jack,Tuna)]", cnf.toString());
        origSentence = parser.parse("Cat(Tuna)");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[Cat(Tuna)]", cnf.toString());
        origSentence = parser.parse("FORALL x (Cat(x) => Animal(x))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~Cat(x), Animal(x)]", cnf.toString());
        origSentence = parser.parse("NOT(Kills(Curiosity, Tuna))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~Kills(Curiosity,Tuna)]", cnf.toString());
    }

    public void testNestedExistsAndOrs() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("P");
        domain.addPredicate("R");
        domain.addPredicate("Q");
        FOLParser parser = new FOLParser(domain);
        Sentence origSentence = parser.parse("EXISTS w (FORALL x ( (EXISTS z (Q(w, z))) => (EXISTS y (NOT(P(x, y)) AND R(y))) ) )");
        CNFConverter cnfConv = new CNFConverter(parser);
        CNF cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~P(x,SF0(x)), ~Q(SC0,z)],[~Q(SC0,z), R(SF0(x))]", cnf.toString());
        origSentence = parser.parse("FORALL x1 (FORALL y1 (P(x1, y1) => EXISTS z1 (Q(x1, y1, z1))))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~P(x1,y1), Q(x1,y1,SF1(x1,y1))]", cnf.toString());
        origSentence = parser.parse("EXISTS x2 (FORALL y2 (FORALL z2 (R(y2, z2) <=> Q(x2, y2, z2))))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~R(y2,z2), Q(SC1,y2,z2)],[~Q(SC1,y2,z2), R(y2,z2)]", cnf.toString());
        origSentence = parser.parse("FORALL x3 (EXISTS y3 (NOT(P(x3, y3)) => FORALL z3 (Q(x3, y3, z3))))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[P(x3,SF2(x3)), Q(x3,SF2(x3),z3)]", cnf.toString());
        origSentence = parser.parse("NOT(EXISTS w4 (EXISTS x4 (EXISTS y4 ( EXISTS z4 (R(x4, y4) AND Q(x4, w4, z4))))))");
        cnf = cnfConv.convertToCNF(origSentence);
        CNFConverterTest.assertEquals("[~Q(x4,w4,z4), ~R(x4,y4)]", cnf.toString());
    }

    public void testImplicationsAndExtendedAndsOrs() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("Cheat");
        domain.addPredicate("Extra");
        domain.addPredicate("Knows");
        domain.addPredicate("Diff");
        domain.addPredicate("F");
        domain.addPredicate("A");
        domain.addPredicate("Probation");
        domain.addPredicate("Award");
        FOLParser parser = new FOLParser(domain);
        CNFConverter cnfConv = new CNFConverter(parser);
        Sentence def1 = parser.parse("(Cheat(x,y) => F(x,y))");
        CNF cnfDef1 = cnfConv.convertToCNF(def1);
        CNFConverterTest.assertEquals("[~Cheat(x,y), F(x,y)]", cnfDef1.toString());
        Sentence def2 = parser.parse("((Extra(x,y) OR Knows(x)) => A(x,y))");
        CNF cnfDef2 = cnfConv.convertToCNF(def2);
        CNFConverterTest.assertEquals("[~Extra(x,y), A(x,y)],[~Knows(x), A(x,y)]", cnfDef2.toString());
        Sentence def3 = parser.parse("(((NOT(((F(x,y) AND F(x,z)) AND Diff(y,z)))) OR Probation(x)) AND (((F(x,y) AND F(x,z)) AND Diff(y,z)) OR NOT(Probation(x))))");
        CNF cnfDef3 = cnfConv.convertToCNF(def3);
        CNFConverterTest.assertEquals("[~Diff(y,z), ~F(x,y), ~F(x,z), Probation(x)],[~Probation(x), F(x,y)],[~Probation(x), F(x,z)],[~Probation(x), Diff(y,z)]", cnfDef3.toString());
        Sentence def4 = parser.parse("(((NOT(((A(x,y) AND A(x,z)) AND Diff(y,z)))) OR Award(x)) AND (((A(x,y) AND A(x,z)) AND Diff(y,z)) OR NOT(Award(x))))");
        CNF cnfDef4 = cnfConv.convertToCNF(def4);
        CNFConverterTest.assertEquals("[~A(x,y), ~A(x,z), ~Diff(y,z), Award(x)],[~Award(x), A(x,y)],[~Award(x), A(x,z)],[~Award(x), Diff(y,z)]", cnfDef4.toString());
        Sentence def5 = parser.parse("( ( NOT(F(x,y)) OR NOT(A(x,y))) AND ( F(x,y) OR NOT(NOT(A(x,y))) ) )");
        CNF cnfDef5 = cnfConv.convertToCNF(def5);
        CNFConverterTest.assertEquals("[~A(x,y), ~F(x,y)],[A(x,y), F(x,y)]", cnfDef5.toString());
    }

    public void testNegationsAndNestedImplications() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("P");
        domain.addPredicate("Q");
        domain.addPredicate("R");
        domain.addConstant("A");
        FOLParser parser = new FOLParser(domain);
        CNFConverter cnfConv = new CNFConverter(parser);
        Sentence sent = parser.parse("NOT(((((NOT(P(A)) OR NOT(Q(A)))) => NOT((P(A) OR Q(A)))) => R(A)))");
        CNF cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~P(A), P(A)],[~P(A), Q(A)],[~Q(A), P(A)],[~Q(A), Q(A)],[~R(A)]", cnf.toString());
    }

    public void testInductionAxiomSchema() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("Equal");
        domain.addFunction("Plus");
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("N");
        domain.addConstant("ONE");
        domain.addConstant("ZERO");
        FOLParser parser = new FOLParser(domain);
        CNFConverter cnfConv = new CNFConverter(parser);
        Sentence sent = parser.parse("NOT(FORALL x (FORALL y (Equal(Plus(Plus(x,y),ZERO), Plus(x,Plus(y,ZERO))))))");
        CNF cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Equal(Plus(Plus(SC0,SC1),ZERO),Plus(SC0,Plus(SC1,ZERO)))]", cnf.toString());
        sent = parser.parse("((Equal(Plus(Plus(A,B),ZERO), Plus(A,Plus(B,ZERO))) AND (FORALL x (FORALL y (FORALL z(Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z))) => Equal(Plus(Plus(x,y),Plus(z,ONE)), Plus(x,Plus(y,Plus(z,ONE))))))))) => FORALL x (FORALL y (FORALL z(Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z)))))))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Equal(Plus(Plus(A,B),ZERO),Plus(A,Plus(B,ZERO))), Equal(Plus(Plus(q0,q1),q2),Plus(q0,Plus(q1,q2))), Equal(Plus(Plus(SC2,SC3),SC4),Plus(SC2,Plus(SC3,SC4)))],[~Equal(Plus(Plus(A,B),ZERO),Plus(A,Plus(B,ZERO))), ~Equal(Plus(Plus(SC2,SC3),Plus(SC4,ONE)),Plus(SC2,Plus(SC3,Plus(SC4,ONE)))), Equal(Plus(Plus(q0,q1),q2),Plus(q0,Plus(q1,q2)))]", cnf.toString());
        sent = parser.parse("NOT(FORALL x (FORALL y (FORALL z (Equal(Plus(Plus(x,y),z), Plus(x,Plus(y,z)))))))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Equal(Plus(Plus(SC5,SC6),SC7),Plus(SC5,Plus(SC6,SC7)))]", cnf.toString());
    }

    public void testTermEquality() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("P");
        domain.addPredicate("Q");
        domain.addPredicate("R");
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addFunction("Plus");
        domain.addConstant("ONE");
        domain.addConstant("ZERO");
        FOLParser parser = new FOLParser(domain);
        CNFConverter cnfConv = new CNFConverter(parser);
        Sentence sent = parser.parse("x = y");
        CNF cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[x = y]", cnf.toString());
        sent = parser.parse("NOT(x = y)");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~x = y]", cnf.toString());
        sent = parser.parse("A = B");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[A = B]", cnf.toString());
        sent = parser.parse("NOT(A = B)");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~A = B]", cnf.toString());
        sent = parser.parse("NOT(((((NOT(A = B) OR NOT(D = C))) => NOT((A = B OR D = C))) => A = D))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~A = B, A = B],[~A = B, D = C],[~D = C, A = B],[~D = C, D = C],[~A = D]", cnf.toString());
        sent = parser.parse("NOT(FORALL x (FORALL y (Plus(Plus(x,y),ZERO) = Plus(x,Plus(y,ZERO)))))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Plus(Plus(SC0,SC1),ZERO) = Plus(SC0,Plus(SC1,ZERO))]", cnf.toString());
        sent = parser.parse("((Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)) AND (FORALL x (FORALL y (FORALL z(Plus(Plus(x,y),z) = Plus(x,Plus(y,z)) => Plus(Plus(x,y),Plus(z,ONE)) = Plus(x,Plus(y,Plus(z,ONE)))))))) => FORALL x (FORALL y (FORALL z(Plus(Plus(x,y),z) = Plus(x,Plus(y,z))))))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)), Plus(Plus(q0,q1),q2) = Plus(q0,Plus(q1,q2)), Plus(Plus(SC2,SC3),SC4) = Plus(SC2,Plus(SC3,SC4))],[~Plus(Plus(A,B),ZERO) = Plus(A,Plus(B,ZERO)), ~Plus(Plus(SC2,SC3),Plus(SC4,ONE)) = Plus(SC2,Plus(SC3,Plus(SC4,ONE))), Plus(Plus(q0,q1),q2) = Plus(q0,Plus(q1,q2))]", cnf.toString());
        sent = parser.parse("NOT(FORALL x (FORALL y (FORALL z (Plus(Plus(x,y),z) = Plus(x,Plus(y,z))))))");
        cnf = cnfConv.convertToCNF(sent);
        CNFConverterTest.assertEquals("[~Plus(Plus(SC5,SC6),SC7) = Plus(SC5,Plus(SC6,SC7))]", cnf.toString());
    }
}

