/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.Randomizer;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ParticleSet {
    private List<Particle> particles = new ArrayList<Particle>();
    private HiddenMarkovModel hmm;

    public ParticleSet(HiddenMarkovModel hmm) {
        this.hmm = hmm;
    }

    public ParticleSet filter(String perception, Randomizer r) {
        return this.generateParticleSetForPredictedState(r).perceptionUpdate(perception, r);
    }

    public ParticleSet filter(String action, String perception, Randomizer r) {
        return this.generateParticleSetForPredictedState(action, r).perceptionUpdate(perception, r);
    }

    public int numberOfParticlesWithState(String state) {
        int total = 0;
        for (Particle p : this.particles) {
            if (!p.hasState(state)) continue;
            ++total;
        }
        return total;
    }

    public void add(Particle particle) {
        this.particles.add(particle);
    }

    public int size() {
        return this.particles.size();
    }

    public RandomVariable toRandomVariable() {
        ArrayList<String> states = new ArrayList<String>();
        Hashtable<String, Integer> stateCount = new Hashtable<String, Integer>();
        for (Particle p : this.particles) {
            String state = p.getState();
            if (!states.contains(state)) {
                states.add(state);
                stateCount.put(state, 0);
            }
            stateCount.put(state, (Integer)stateCount.get(state) + 1);
        }
        RandomVariable result = new RandomVariable(states);
        for (String state : stateCount.keySet()) {
            result.setProbabilityOf(state, (double)((Integer)stateCount.get(state)).intValue() / (double)this.particles.size());
        }
        return result;
    }

    public ParticleSet generateParticleSetForPredictedState(Randomizer randomizer) {
        return this.generateParticleSetForPredictedState("do_nothing", randomizer);
    }

    public ParticleSet generateParticleSetForPredictedState(String action, Randomizer randomizer) {
        ParticleSet predictedParticleSet = new ParticleSet(this.hmm);
        for (Particle p : this.particles) {
            String newState = this.hmm.transitionModel().getStateForProbability(p.getState(), action, randomizer.nextDouble());
            Particle generatedParticle = new Particle(newState);
            predictedParticleSet.add(generatedParticle);
        }
        return predictedParticleSet;
    }

    public ParticleSet perceptionUpdate(String perception, Randomizer r) {
        for (Particle p : this.particles) {
            double particleWeight = this.hmm.sensorModel().get(p.getState(), perception);
            p.setWeight(particleWeight);
        }
        ParticleSet result = new ParticleSet(this.hmm);
        while (result.size() != this.size()) {
            for (Particle p : this.particles) {
                double probability = r.nextDouble();
                if (!(probability <= p.getWeight()) || result.size() >= this.size()) continue;
                result.add(new Particle(p.getState(), p.getWeight()));
            }
        }
        return result;
    }

    public Particle getParticle(int i) {
        return this.particles.get(i);
    }
}

